package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  RemoveAuthorizerConfig,
  ReservedDomainConfigurationName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateDomainConfigurationRequest(
    domainConfigurationName: ReservedDomainConfigurationName,
    authorizerConfig: Option[zio.aws.iot.model.AuthorizerConfig] = None,
    domainConfigurationStatus: Option[
      zio.aws.iot.model.DomainConfigurationStatus
    ] = None,
    removeAuthorizerConfig: Option[RemoveAuthorizerConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationRequest = {
    import UpdateDomainConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationRequest
      .builder()
      .domainConfigurationName(
        ReservedDomainConfigurationName.unwrap(
          domainConfigurationName
        ): java.lang.String
      )
      .optionallyWith(authorizerConfig.map(value => value.buildAwsValue()))(
        _.authorizerConfig
      )
      .optionallyWith(domainConfigurationStatus.map(value => value.unwrap))(
        _.domainConfigurationStatus
      )
      .optionallyWith(
        removeAuthorizerConfig.map(value =>
          RemoveAuthorizerConfig.unwrap(value): java.lang.Boolean
        )
      )(_.removeAuthorizerConfig)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateDomainConfigurationRequest.ReadOnly =
    zio.aws.iot.model.UpdateDomainConfigurationRequest.wrap(buildAwsValue())
}
object UpdateDomainConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateDomainConfigurationRequest =
      zio.aws.iot.model.UpdateDomainConfigurationRequest(
        domainConfigurationName,
        authorizerConfig.map(value => value.asEditable),
        domainConfigurationStatus.map(value => value),
        removeAuthorizerConfig.map(value => value)
      )
    def domainConfigurationName: ReservedDomainConfigurationName
    def authorizerConfig: Option[zio.aws.iot.model.AuthorizerConfig.ReadOnly]
    def domainConfigurationStatus
        : Option[zio.aws.iot.model.DomainConfigurationStatus]
    def removeAuthorizerConfig: Option[RemoveAuthorizerConfig]
    def getDomainConfigurationName
        : ZIO[Any, Nothing, ReservedDomainConfigurationName] =
      ZIO.succeed(domainConfigurationName)
    def getAuthorizerConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.AuthorizerConfig.ReadOnly] =
      AwsError.unwrapOptionField("authorizerConfig", authorizerConfig)
    def getDomainConfigurationStatus
        : ZIO[Any, AwsError, zio.aws.iot.model.DomainConfigurationStatus] =
      AwsError.unwrapOptionField(
        "domainConfigurationStatus",
        domainConfigurationStatus
      )
    def getRemoveAuthorizerConfig: ZIO[Any, AwsError, RemoveAuthorizerConfig] =
      AwsError.unwrapOptionField(
        "removeAuthorizerConfig",
        removeAuthorizerConfig
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationRequest
  ) extends zio.aws.iot.model.UpdateDomainConfigurationRequest.ReadOnly {
    override val domainConfigurationName: ReservedDomainConfigurationName =
      zio.aws.iot.model.primitives
        .ReservedDomainConfigurationName(impl.domainConfigurationName())
    override val authorizerConfig
        : Option[zio.aws.iot.model.AuthorizerConfig.ReadOnly] = scala
      .Option(impl.authorizerConfig())
      .map(value => zio.aws.iot.model.AuthorizerConfig.wrap(value))
    override val domainConfigurationStatus
        : Option[zio.aws.iot.model.DomainConfigurationStatus] = scala
      .Option(impl.domainConfigurationStatus())
      .map(value => zio.aws.iot.model.DomainConfigurationStatus.wrap(value))
    override val removeAuthorizerConfig: Option[RemoveAuthorizerConfig] = scala
      .Option(impl.removeAuthorizerConfig())
      .map(value => zio.aws.iot.model.primitives.RemoveAuthorizerConfig(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationRequest
  ): zio.aws.iot.model.UpdateDomainConfigurationRequest.ReadOnly = new Wrapper(
    impl
  )
}
