package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.Version
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateDynamicThingGroupResponse(
    version: Option[Version] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateDynamicThingGroupResponse = {
    import UpdateDynamicThingGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateDynamicThingGroupResponse
      .builder()
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.Long)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateDynamicThingGroupResponse.ReadOnly =
    zio.aws.iot.model.UpdateDynamicThingGroupResponse.wrap(buildAwsValue())
}
object UpdateDynamicThingGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateDynamicThingGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateDynamicThingGroupResponse =
      zio.aws.iot.model
        .UpdateDynamicThingGroupResponse(version.map(value => value))
    def version: Option[Version]
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateDynamicThingGroupResponse
  ) extends zio.aws.iot.model.UpdateDynamicThingGroupResponse.ReadOnly {
    override val version: Option[Version] = scala
      .Option(impl.version())
      .map(value => zio.aws.iot.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateDynamicThingGroupResponse
  ): zio.aws.iot.model.UpdateDynamicThingGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
