package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{NamespaceId, JobDescription, JobId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateJobRequest(
    jobId: JobId,
    description: Option[JobDescription] = None,
    presignedUrlConfig: Option[zio.aws.iot.model.PresignedUrlConfig] = None,
    jobExecutionsRolloutConfig: Option[
      zio.aws.iot.model.JobExecutionsRolloutConfig
    ] = None,
    abortConfig: Option[zio.aws.iot.model.AbortConfig] = None,
    timeoutConfig: Option[zio.aws.iot.model.TimeoutConfig] = None,
    namespaceId: Option[NamespaceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateJobRequest = {
    import UpdateJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(
        description.map(value => JobDescription.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(presignedUrlConfig.map(value => value.buildAwsValue()))(
        _.presignedUrlConfig
      )
      .optionallyWith(
        jobExecutionsRolloutConfig.map(value => value.buildAwsValue())
      )(_.jobExecutionsRolloutConfig)
      .optionallyWith(abortConfig.map(value => value.buildAwsValue()))(
        _.abortConfig
      )
      .optionallyWith(timeoutConfig.map(value => value.buildAwsValue()))(
        _.timeoutConfig
      )
      .optionallyWith(
        namespaceId.map(value => NamespaceId.unwrap(value): java.lang.String)
      )(_.namespaceId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateJobRequest.ReadOnly =
    zio.aws.iot.model.UpdateJobRequest.wrap(buildAwsValue())
}
object UpdateJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateJobRequest =
      zio.aws.iot.model.UpdateJobRequest(
        jobId,
        description.map(value => value),
        presignedUrlConfig.map(value => value.asEditable),
        jobExecutionsRolloutConfig.map(value => value.asEditable),
        abortConfig.map(value => value.asEditable),
        timeoutConfig.map(value => value.asEditable),
        namespaceId.map(value => value)
      )
    def jobId: JobId
    def description: Option[JobDescription]
    def presignedUrlConfig
        : Option[zio.aws.iot.model.PresignedUrlConfig.ReadOnly]
    def jobExecutionsRolloutConfig
        : Option[zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly]
    def abortConfig: Option[zio.aws.iot.model.AbortConfig.ReadOnly]
    def timeoutConfig: Option[zio.aws.iot.model.TimeoutConfig.ReadOnly]
    def namespaceId: Option[NamespaceId]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getDescription: ZIO[Any, AwsError, JobDescription] =
      AwsError.unwrapOptionField("description", description)
    def getPresignedUrlConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.PresignedUrlConfig.ReadOnly] =
      AwsError.unwrapOptionField("presignedUrlConfig", presignedUrlConfig)
    def getJobExecutionsRolloutConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jobExecutionsRolloutConfig",
      jobExecutionsRolloutConfig
    )
    def getAbortConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.AbortConfig.ReadOnly] =
      AwsError.unwrapOptionField("abortConfig", abortConfig)
    def getTimeoutConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.TimeoutConfig.ReadOnly] =
      AwsError.unwrapOptionField("timeoutConfig", timeoutConfig)
    def getNamespaceId: ZIO[Any, AwsError, NamespaceId] =
      AwsError.unwrapOptionField("namespaceId", namespaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateJobRequest
  ) extends zio.aws.iot.model.UpdateJobRequest.ReadOnly {
    override val jobId: JobId = zio.aws.iot.model.primitives.JobId(impl.jobId())
    override val description: Option[JobDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.iot.model.primitives.JobDescription(value))
    override val presignedUrlConfig
        : Option[zio.aws.iot.model.PresignedUrlConfig.ReadOnly] = scala
      .Option(impl.presignedUrlConfig())
      .map(value => zio.aws.iot.model.PresignedUrlConfig.wrap(value))
    override val jobExecutionsRolloutConfig
        : Option[zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly] = scala
      .Option(impl.jobExecutionsRolloutConfig())
      .map(value => zio.aws.iot.model.JobExecutionsRolloutConfig.wrap(value))
    override val abortConfig: Option[zio.aws.iot.model.AbortConfig.ReadOnly] =
      scala
        .Option(impl.abortConfig())
        .map(value => zio.aws.iot.model.AbortConfig.wrap(value))
    override val timeoutConfig
        : Option[zio.aws.iot.model.TimeoutConfig.ReadOnly] = scala
      .Option(impl.timeoutConfig())
      .map(value => zio.aws.iot.model.TimeoutConfig.wrap(value))
    override val namespaceId: Option[NamespaceId] = scala
      .Option(impl.namespaceId())
      .map(value => zio.aws.iot.model.primitives.NamespaceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateJobRequest
  ): zio.aws.iot.model.UpdateJobRequest.ReadOnly = new Wrapper(impl)
}
