package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{RoleArn, MitigationActionName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateMitigationActionRequest(
    actionName: MitigationActionName,
    roleArn: Option[RoleArn] = None,
    actionParams: Option[zio.aws.iot.model.MitigationActionParams] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateMitigationActionRequest = {
    import UpdateMitigationActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateMitigationActionRequest
      .builder()
      .actionName(MitigationActionName.unwrap(actionName): java.lang.String)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(actionParams.map(value => value.buildAwsValue()))(
        _.actionParams
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateMitigationActionRequest.ReadOnly =
    zio.aws.iot.model.UpdateMitigationActionRequest.wrap(buildAwsValue())
}
object UpdateMitigationActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateMitigationActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateMitigationActionRequest =
      zio.aws.iot.model.UpdateMitigationActionRequest(
        actionName,
        roleArn.map(value => value),
        actionParams.map(value => value.asEditable)
      )
    def actionName: MitigationActionName
    def roleArn: Option[RoleArn]
    def actionParams: Option[zio.aws.iot.model.MitigationActionParams.ReadOnly]
    def getActionName: ZIO[Any, Nothing, MitigationActionName] =
      ZIO.succeed(actionName)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getActionParams: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.MitigationActionParams.ReadOnly
    ] = AwsError.unwrapOptionField("actionParams", actionParams)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateMitigationActionRequest
  ) extends zio.aws.iot.model.UpdateMitigationActionRequest.ReadOnly {
    override val actionName: MitigationActionName =
      zio.aws.iot.model.primitives.MitigationActionName(impl.actionName())
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.RoleArn(value))
    override val actionParams
        : Option[zio.aws.iot.model.MitigationActionParams.ReadOnly] = scala
      .Option(impl.actionParams())
      .map(value => zio.aws.iot.model.MitigationActionParams.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateMitigationActionRequest
  ): zio.aws.iot.model.UpdateMitigationActionRequest.ReadOnly = new Wrapper(
    impl
  )
}
