package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  CredentialDurationSeconds,
  RoleArn,
  RoleAlias
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateRoleAliasRequest(
    roleAlias: RoleAlias,
    roleArn: Option[RoleArn] = None,
    credentialDurationSeconds: Option[CredentialDurationSeconds] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateRoleAliasRequest = {
    import UpdateRoleAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateRoleAliasRequest
      .builder()
      .roleAlias(RoleAlias.unwrap(roleAlias): java.lang.String)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        credentialDurationSeconds.map(value =>
          CredentialDurationSeconds.unwrap(value): Integer
        )
      )(_.credentialDurationSeconds)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateRoleAliasRequest.ReadOnly =
    zio.aws.iot.model.UpdateRoleAliasRequest.wrap(buildAwsValue())
}
object UpdateRoleAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateRoleAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateRoleAliasRequest =
      zio.aws.iot.model.UpdateRoleAliasRequest(
        roleAlias,
        roleArn.map(value => value),
        credentialDurationSeconds.map(value => value)
      )
    def roleAlias: RoleAlias
    def roleArn: Option[RoleArn]
    def credentialDurationSeconds: Option[CredentialDurationSeconds]
    def getRoleAlias: ZIO[Any, Nothing, RoleAlias] = ZIO.succeed(roleAlias)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getCredentialDurationSeconds
        : ZIO[Any, AwsError, CredentialDurationSeconds] = AwsError
      .unwrapOptionField("credentialDurationSeconds", credentialDurationSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateRoleAliasRequest
  ) extends zio.aws.iot.model.UpdateRoleAliasRequest.ReadOnly {
    override val roleAlias: RoleAlias =
      zio.aws.iot.model.primitives.RoleAlias(impl.roleAlias())
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.RoleArn(value))
    override val credentialDurationSeconds: Option[CredentialDurationSeconds] =
      scala
        .Option(impl.credentialDurationSeconds())
        .map(value =>
          zio.aws.iot.model.primitives.CredentialDurationSeconds(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateRoleAliasRequest
  ): zio.aws.iot.model.UpdateRoleAliasRequest.ReadOnly = new Wrapper(impl)
}
