package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  StreamVersion,
  StreamDescription,
  StreamArn,
  StreamId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateStreamResponse(
    streamId: Option[StreamId] = None,
    streamArn: Option[StreamArn] = None,
    description: Option[StreamDescription] = None,
    streamVersion: Option[StreamVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateStreamResponse = {
    import UpdateStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateStreamResponse
      .builder()
      .optionallyWith(
        streamId.map(value => StreamId.unwrap(value): java.lang.String)
      )(_.streamId)
      .optionallyWith(
        streamArn.map(value => StreamArn.unwrap(value): java.lang.String)
      )(_.streamArn)
      .optionallyWith(
        description.map(value =>
          StreamDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        streamVersion.map(value => StreamVersion.unwrap(value): Integer)
      )(_.streamVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateStreamResponse.ReadOnly =
    zio.aws.iot.model.UpdateStreamResponse.wrap(buildAwsValue())
}
object UpdateStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateStreamResponse =
      zio.aws.iot.model.UpdateStreamResponse(
        streamId.map(value => value),
        streamArn.map(value => value),
        description.map(value => value),
        streamVersion.map(value => value)
      )
    def streamId: Option[StreamId]
    def streamArn: Option[StreamArn]
    def description: Option[StreamDescription]
    def streamVersion: Option[StreamVersion]
    def getStreamId: ZIO[Any, AwsError, StreamId] =
      AwsError.unwrapOptionField("streamId", streamId)
    def getStreamArn: ZIO[Any, AwsError, StreamArn] =
      AwsError.unwrapOptionField("streamArn", streamArn)
    def getDescription: ZIO[Any, AwsError, StreamDescription] =
      AwsError.unwrapOptionField("description", description)
    def getStreamVersion: ZIO[Any, AwsError, StreamVersion] =
      AwsError.unwrapOptionField("streamVersion", streamVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateStreamResponse
  ) extends zio.aws.iot.model.UpdateStreamResponse.ReadOnly {
    override val streamId: Option[StreamId] = scala
      .Option(impl.streamId())
      .map(value => zio.aws.iot.model.primitives.StreamId(value))
    override val streamArn: Option[StreamArn] = scala
      .Option(impl.streamArn())
      .map(value => zio.aws.iot.model.primitives.StreamArn(value))
    override val description: Option[StreamDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.iot.model.primitives.StreamDescription(value))
    override val streamVersion: Option[StreamVersion] = scala
      .Option(impl.streamVersion())
      .map(value => zio.aws.iot.model.primitives.StreamVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateStreamResponse
  ): zio.aws.iot.model.UpdateStreamResponse.ReadOnly = new Wrapper(impl)
}
