package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  RemoveThingType,
  OptionalVersion,
  ThingTypeName,
  ThingName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateThingRequest(
    thingName: ThingName,
    thingTypeName: Option[ThingTypeName] = None,
    attributePayload: Option[zio.aws.iot.model.AttributePayload] = None,
    expectedVersion: Option[OptionalVersion] = None,
    removeThingType: Option[RemoveThingType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateThingRequest = {
    import UpdateThingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateThingRequest
      .builder()
      .thingName(ThingName.unwrap(thingName): java.lang.String)
      .optionallyWith(
        thingTypeName.map(value =>
          ThingTypeName.unwrap(value): java.lang.String
        )
      )(_.thingTypeName)
      .optionallyWith(attributePayload.map(value => value.buildAwsValue()))(
        _.attributePayload
      )
      .optionallyWith(
        expectedVersion.map(value =>
          OptionalVersion.unwrap(value): java.lang.Long
        )
      )(_.expectedVersion)
      .optionallyWith(
        removeThingType.map(value =>
          RemoveThingType.unwrap(value): java.lang.Boolean
        )
      )(_.removeThingType)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateThingRequest.ReadOnly =
    zio.aws.iot.model.UpdateThingRequest.wrap(buildAwsValue())
}
object UpdateThingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateThingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateThingRequest =
      zio.aws.iot.model.UpdateThingRequest(
        thingName,
        thingTypeName.map(value => value),
        attributePayload.map(value => value.asEditable),
        expectedVersion.map(value => value),
        removeThingType.map(value => value)
      )
    def thingName: ThingName
    def thingTypeName: Option[ThingTypeName]
    def attributePayload: Option[zio.aws.iot.model.AttributePayload.ReadOnly]
    def expectedVersion: Option[OptionalVersion]
    def removeThingType: Option[RemoveThingType]
    def getThingName: ZIO[Any, Nothing, ThingName] = ZIO.succeed(thingName)
    def getThingTypeName: ZIO[Any, AwsError, ThingTypeName] =
      AwsError.unwrapOptionField("thingTypeName", thingTypeName)
    def getAttributePayload
        : ZIO[Any, AwsError, zio.aws.iot.model.AttributePayload.ReadOnly] =
      AwsError.unwrapOptionField("attributePayload", attributePayload)
    def getExpectedVersion: ZIO[Any, AwsError, OptionalVersion] =
      AwsError.unwrapOptionField("expectedVersion", expectedVersion)
    def getRemoveThingType: ZIO[Any, AwsError, RemoveThingType] =
      AwsError.unwrapOptionField("removeThingType", removeThingType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateThingRequest
  ) extends zio.aws.iot.model.UpdateThingRequest.ReadOnly {
    override val thingName: ThingName =
      zio.aws.iot.model.primitives.ThingName(impl.thingName())
    override val thingTypeName: Option[ThingTypeName] = scala
      .Option(impl.thingTypeName())
      .map(value => zio.aws.iot.model.primitives.ThingTypeName(value))
    override val attributePayload
        : Option[zio.aws.iot.model.AttributePayload.ReadOnly] = scala
      .Option(impl.attributePayload())
      .map(value => zio.aws.iot.model.AttributePayload.wrap(value))
    override val expectedVersion: Option[OptionalVersion] = scala
      .Option(impl.expectedVersion())
      .map(value => zio.aws.iot.model.primitives.OptionalVersion(value))
    override val removeThingType: Option[RemoveThingType] = scala
      .Option(impl.removeThingType())
      .map(value => zio.aws.iot.model.primitives.RemoveThingType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateThingRequest
  ): zio.aws.iot.model.UpdateThingRequest.ReadOnly = new Wrapper(impl)
}
