package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{AwsArn, VpcId, SecurityGroupId, SubnetId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class VpcDestinationSummary(
    subnetIds: Option[Iterable[SubnetId]] = None,
    securityGroups: Option[Iterable[SecurityGroupId]] = None,
    vpcId: Option[VpcId] = None,
    roleArn: Option[AwsArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.VpcDestinationSummary = {
    import VpcDestinationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.VpcDestinationSummary
      .builder()
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        roleArn.map(value => AwsArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.VpcDestinationSummary.ReadOnly =
    zio.aws.iot.model.VpcDestinationSummary.wrap(buildAwsValue())
}
object VpcDestinationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.VpcDestinationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.VpcDestinationSummary =
      zio.aws.iot.model.VpcDestinationSummary(
        subnetIds.map(value => value),
        securityGroups.map(value => value),
        vpcId.map(value => value),
        roleArn.map(value => value)
      )
    def subnetIds: Option[List[SubnetId]]
    def securityGroups: Option[List[SecurityGroupId]]
    def vpcId: Option[VpcId]
    def roleArn: Option[AwsArn]
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getSecurityGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getRoleArn: ZIO[Any, AwsError, AwsArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.VpcDestinationSummary
  ) extends zio.aws.iot.model.VpcDestinationSummary.ReadOnly {
    override val subnetIds: Option[List[SubnetId]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.SubnetId(item)
        }.toList
      )
    override val securityGroups: Option[List[SecurityGroupId]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val vpcId: Option[VpcId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.iot.model.primitives.VpcId(value))
    override val roleArn: Option[AwsArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.AwsArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.VpcDestinationSummary
  ): zio.aws.iot.model.VpcDestinationSummary.ReadOnly = new Wrapper(impl)
}
