package zio.aws.iot
import zio.aws.iot.model.PutVerificationStateOnViolationResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.iot.paginators.{
  ListDetectMitigationActionsTasksPublisher,
  ListCertificatesPublisher,
  ListThingRegistrationTaskReportsPublisher,
  ListBillingGroupsPublisher,
  ListAuditFindingsPublisher,
  ListProvisioningTemplatesPublisher,
  ListActiveViolationsPublisher,
  ListScheduledAuditsPublisher,
  ListJobExecutionsForThingPublisher,
  ListThingGroupsPublisher,
  ListTopicRuleDestinationsPublisher,
  ListThingsInBillingGroupPublisher,
  ListDimensionsPublisher,
  ListTopicRulesPublisher,
  ListCACertificatesPublisher,
  GetBehaviorModelTrainingSummariesPublisher,
  ListAuditTasksPublisher,
  ListOTAUpdatesPublisher,
  ListAttachedPoliciesPublisher,
  ListAuditMitigationActionsExecutionsPublisher,
  ListDetectMitigationActionsExecutionsPublisher,
  ListFleetMetricsPublisher,
  ListStreamsPublisher,
  ListProvisioningTemplateVersionsPublisher,
  ListTargetsForPolicyPublisher,
  ListAuthorizersPublisher,
  ListThingTypesPublisher,
  ListSecurityProfilesForTargetPublisher,
  ListTagsForResourcePublisher,
  ListViolationEventsPublisher,
  ListThingRegistrationTasksPublisher,
  ListSecurityProfilesPublisher,
  ListMitigationActionsPublisher,
  ListTargetsForSecurityProfilePublisher,
  ListDomainConfigurationsPublisher,
  ListThingsInThingGroupPublisher,
  ListAuditSuppressionsPublisher,
  ListJobExecutionsForJobPublisher,
  ListOutgoingCertificatesPublisher,
  ListAuditMitigationActionsTasksPublisher,
  ListThingPrincipalsPublisher,
  ListJobsPublisher,
  ListThingGroupsForThingPublisher,
  ListCertificatesByCAPublisher,
  ListJobTemplatesPublisher,
  ListCustomMetricsPublisher,
  ListIndicesPublisher,
  ListPoliciesPublisher,
  ListRoleAliasesPublisher,
  ListV2LoggingLevelsPublisher,
  ListThingsPublisher,
  ListPrincipalThingsPublisher
}
import zio.aws.iot.model.{
  ListJobTemplatesRequest,
  GetBehaviorModelTrainingSummariesRequest,
  GetPolicyVersionRequest,
  SearchIndexRequest,
  CreateJobTemplateRequest,
  DescribeRoleAliasRequest,
  DeleteJobExecutionRequest,
  DeleteAuditSuppressionRequest,
  DescribeStreamRequest,
  AttachSecurityProfileRequest,
  GetOtaUpdateRequest,
  CreateThingTypeRequest,
  ListScheduledAuditsRequest,
  UpdateTopicRuleDestinationRequest,
  UpdateDimensionRequest,
  DeleteRegistrationCodeRequest,
  ListStreamsRequest,
  DescribeAuditFindingRequest,
  GetLoggingOptionsRequest,
  UpdateRoleAliasRequest,
  ListAuditMitigationActionsTasksRequest,
  RemoveThingFromBillingGroupRequest,
  DeleteV2LoggingLevelRequest,
  CancelDetectMitigationActionsTaskRequest,
  CreateProvisioningTemplateRequest,
  CreateMitigationActionRequest,
  DeleteMitigationActionRequest,
  StartThingRegistrationTaskRequest,
  DescribeManagedJobTemplateRequest,
  DeleteAccountAuditConfigurationRequest,
  CreateDimensionRequest,
  ListIndicesRequest,
  DescribeEventConfigurationsRequest,
  DeleteDimensionRequest,
  AddThingToThingGroupRequest,
  ListPrincipalThingsRequest,
  DeleteDynamicThingGroupRequest,
  SetLoggingOptionsRequest,
  UpdateMitigationActionRequest,
  ListBillingGroupsRequest,
  DescribeThingTypeRequest,
  DescribeThingRequest,
  CancelCertificateTransferRequest,
  CancelJobRequest,
  ListCertificatesByCaRequest,
  ListPoliciesRequest,
  DescribeDefaultAuthorizerRequest,
  RejectCertificateTransferRequest,
  DescribeJobTemplateRequest,
  DescribeDetectMitigationActionsTaskRequest,
  ListJobExecutionsForJobRequest,
  GetTopicRuleRequest,
  AttachThingPrincipalRequest,
  CreateAuthorizerRequest,
  ClearDefaultAuthorizerRequest,
  DeleteProvisioningTemplateVersionRequest,
  ListJobsRequest,
  ListOtaUpdatesRequest,
  DeleteFleetMetricRequest,
  DescribeProvisioningTemplateVersionRequest,
  ListAuditMitigationActionsExecutionsRequest,
  RegisterCertificateRequest,
  GetV2LoggingOptionsRequest,
  UpdateScheduledAuditRequest,
  ListAuditSuppressionsRequest,
  DescribeJobRequest,
  UpdateIndexingConfigurationRequest,
  CreateScheduledAuditRequest,
  ListTargetsForSecurityProfileRequest,
  DeleteThingGroupRequest,
  CreateCertificateFromCsrRequest,
  GetTopicRuleDestinationRequest,
  DeleteTopicRuleDestinationRequest,
  DescribeMitigationActionRequest,
  DescribeCustomMetricRequest,
  ListSecurityProfilesForTargetRequest,
  ListProvisioningTemplatesRequest,
  DeleteTopicRuleRequest,
  ListTagsForResourceRequest,
  DescribeAuditMitigationActionsTaskRequest,
  GetCardinalityRequest,
  CreateKeysAndCertificateRequest,
  CreateBillingGroupRequest,
  ListCustomMetricsRequest,
  ListFleetMetricsRequest,
  CreateDomainConfigurationRequest,
  ListTargetsForPolicyRequest,
  ReplaceTopicRuleRequest,
  AssociateTargetsWithJobRequest,
  DescribeAuditSuppressionRequest,
  UpdateStreamRequest,
  CreateProvisioningClaimRequest,
  SetV2LoggingOptionsRequest,
  UpdateCaCertificateRequest,
  StopThingRegistrationTaskRequest,
  ListThingRegistrationTaskReportsRequest,
  UpdateAuditSuppressionRequest,
  DeleteDomainConfigurationRequest,
  ValidateSecurityProfileBehaviorsRequest,
  UpdateAccountAuditConfigurationRequest,
  CreateStreamRequest,
  StartDetectMitigationActionsTaskRequest,
  DisableTopicRuleRequest,
  DeleteAuthorizerRequest,
  RegisterCaCertificateRequest,
  DeletePolicyVersionRequest,
  DescribeDimensionRequest,
  DeleteJobRequest,
  StartOnDemandAuditTaskRequest,
  UpdateBillingGroupRequest,
  DeleteProvisioningTemplateRequest,
  DeleteThingTypeRequest,
  ListMitigationActionsRequest,
  ListThingRegistrationTasksRequest,
  GetEffectivePoliciesRequest,
  CreateCustomMetricRequest,
  DescribeProvisioningTemplateRequest,
  ListRoleAliasesRequest,
  ListActiveViolationsRequest,
  DeleteCustomMetricRequest,
  RemoveThingFromThingGroupRequest,
  DeleteBillingGroupRequest,
  ListThingsRequest,
  DeleteJobTemplateRequest,
  CreateTopicRuleRequest,
  GetIndexingConfigurationRequest,
  SetDefaultPolicyVersionRequest,
  ListV2LoggingLevelsRequest,
  UpdateDomainConfigurationRequest,
  DeleteCaCertificateRequest,
  ListViolationEventsRequest,
  ListThingPrincipalsRequest,
  ListAuditTasksRequest,
  DescribeSecurityProfileRequest,
  DescribeCaCertificateRequest,
  GetJobDocumentRequest,
  DetachThingPrincipalRequest,
  CreateDynamicThingGroupRequest,
  DescribeFleetMetricRequest,
  ListDetectMitigationActionsExecutionsRequest,
  UpdateCertificateRequest,
  ListThingsInThingGroupRequest,
  DescribeAuthorizerRequest,
  RegisterCertificateWithoutCaRequest,
  UpdateCustomMetricRequest,
  DeleteStreamRequest,
  ListJobExecutionsForThingRequest,
  UpdateDynamicThingGroupRequest,
  DeleteThingRequest,
  EnableTopicRuleRequest,
  ListPolicyVersionsRequest,
  CreateTopicRuleDestinationRequest,
  CreateOtaUpdateRequest,
  RegisterThingRequest,
  GetPolicyRequest,
  ListDomainConfigurationsRequest,
  DeleteOtaUpdateRequest,
  ConfirmTopicRuleDestinationRequest,
  ListCaCertificatesRequest,
  UpdateSecurityProfileRequest,
  DetachPolicyRequest,
  CreateThingRequest,
  UntagResourceRequest,
  DescribeScheduledAuditRequest,
  CreatePolicyVersionRequest,
  AcceptCertificateTransferRequest,
  DetachSecurityProfileRequest,
  ListCertificatesRequest,
  ListTopicRuleDestinationsRequest,
  ListOutgoingCertificatesRequest,
  CreateJobRequest,
  DescribeJobExecutionRequest,
  ListThingGroupsRequest,
  DescribeEndpointRequest,
  ListProvisioningTemplateVersionsRequest,
  CreateRoleAliasRequest,
  GetPercentilesRequest,
  SetV2LoggingLevelRequest,
  UpdateJobRequest,
  DescribeBillingGroupRequest,
  DescribeAccountAuditConfigurationRequest,
  GetRegistrationCodeRequest,
  CancelJobExecutionRequest,
  CreateThingGroupRequest,
  UpdateThingRequest,
  DescribeDomainConfigurationRequest,
  GetStatisticsRequest,
  ListThingsInBillingGroupRequest,
  ListAuthorizersRequest,
  TestInvokeAuthorizerRequest,
  UpdateThingGroupsForThingRequest,
  ListThingGroupsForThingRequest,
  TransferCertificateRequest,
  ListSecurityProfilesRequest,
  AddThingToBillingGroupRequest,
  CreateSecurityProfileRequest,
  CancelAuditMitigationActionsTaskRequest,
  UpdateFleetMetricRequest,
  DescribeAuditTaskRequest,
  ListManagedJobTemplatesRequest,
  DeletePolicyRequest,
  StartAuditMitigationActionsTaskRequest,
  CreateProvisioningTemplateVersionRequest,
  DeleteScheduledAuditRequest,
  DeleteRoleAliasRequest,
  ListAttachedPoliciesRequest,
  DescribeCertificateRequest,
  UpdateThingGroupRequest,
  UpdateProvisioningTemplateRequest,
  ListAuditFindingsRequest,
  ListThingTypesRequest,
  UpdateEventConfigurationsRequest,
  DeleteSecurityProfileRequest,
  DeleteCertificateRequest,
  TagResourceRequest,
  CancelAuditTaskRequest,
  UpdateAuthorizerRequest,
  AttachPolicyRequest,
  DescribeThingGroupRequest,
  TestAuthorizationRequest,
  CreateAuditSuppressionRequest,
  CreatePolicyRequest,
  PutVerificationStateOnViolationRequest,
  ListDetectMitigationActionsTasksRequest,
  ListDimensionsRequest,
  GetBucketsAggregationRequest,
  ListTopicRulesRequest,
  DescribeIndexRequest,
  DescribeThingRegistrationTaskRequest,
  SetDefaultAuthorizerRequest,
  DeprecateThingTypeRequest,
  CreateFleetMetricRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.iot.{
  IotAsyncClientBuilder,
  IotAsyncClient
}
import zio.aws.iot.model.primitives.{
  MetricName,
  IndexName,
  RoleAlias,
  ThingName,
  PrincipalArn,
  S3FileUrl,
  DimensionName,
  PolicyTarget,
  TaskId
}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.iot.model.{
  AuditMitigationActionsTaskMetadata,
  DeleteThingGroupResponse,
  CreateDynamicThingGroupResponse,
  DescribeManagedJobTemplateResponse,
  DeleteCaCertificateResponse,
  CancelCertificateTransferResponse,
  CancelAuditMitigationActionsTaskResponse,
  DomainConfigurationSummary,
  DeletePolicyVersionResponse,
  DescribeRoleAliasResponse,
  GetLoggingOptionsResponse,
  GetCardinalityResponse,
  DeleteRegistrationCodeResponse,
  AddThingToBillingGroupResponse,
  ListJobTemplatesResponse,
  ListJobExecutionsForThingResponse,
  ListV2LoggingLevelsResponse,
  DeleteMitigationActionResponse,
  SetLoggingOptionsResponse,
  DeleteAuthorizerResponse,
  Certificate,
  UpdateIndexingConfigurationResponse,
  DescribeAuditMitigationActionsTaskResponse,
  CreateTopicRuleResponse,
  CreateBillingGroupResponse,
  ListThingGroupsResponse,
  StartThingRegistrationTaskResponse,
  SetDefaultPolicyVersionResponse,
  UpdateStreamResponse,
  ListSecurityProfilesResponse,
  ListAuditMitigationActionsTasksResponse,
  GetJobDocumentResponse,
  SecurityProfileIdentifier,
  CreatePolicyResponse,
  ListAuditFindingsResponse,
  DetectMitigationActionExecution,
  SearchIndexResponse,
  ListPrincipalThingsResponse,
  ListProvisioningTemplatesResponse,
  DeleteJobExecutionResponse,
  DescribeProvisioningTemplateResponse,
  ListDimensionsResponse,
  CreateAuditSuppressionResponse,
  DescribeEventConfigurationsResponse,
  ListCaCertificatesResponse,
  AcceptCertificateTransferResponse,
  CreateFleetMetricResponse,
  DescribeThingTypeResponse,
  UpdateSecurityProfileResponse,
  UpdateAccountAuditConfigurationResponse,
  GetPolicyVersionResponse,
  CreateStreamResponse,
  CancelJobResponse,
  LogTargetConfiguration,
  DescribeSecurityProfileResponse,
  SetDefaultAuthorizerResponse,
  ListBillingGroupsResponse,
  CreateJobTemplateResponse,
  SetV2LoggingOptionsResponse,
  ListPoliciesResponse,
  AuthorizerSummary,
  DeleteProvisioningTemplateResponse,
  ActiveViolation,
  BehaviorModelTrainingSummary,
  ListScheduledAuditsResponse,
  DeleteAuditSuppressionResponse,
  ListManagedJobTemplatesResponse,
  ListFleetMetricsResponse,
  DescribeThingGroupResponse,
  RegisterThingResponse,
  GetTopicRuleResponse,
  DisableTopicRuleResponse,
  DescribeCustomMetricResponse,
  DeprecateThingTypeResponse,
  GetOtaUpdateResponse,
  AuditSuppression,
  ThingAttribute,
  ListViolationEventsResponse,
  DeleteCertificateResponse,
  DescribeJobResponse,
  ListPolicyVersionsResponse,
  UpdateCustomMetricResponse,
  ListAuditTasksResponse,
  Tag,
  ProvisioningTemplateSummary,
  DescribeBillingGroupResponse,
  DescribeThingResponse,
  ListDetectMitigationActionsTasksResponse,
  ListAuditMitigationActionsExecutionsResponse,
  CreateCertificateFromCsrResponse,
  ConfirmTopicRuleDestinationResponse,
  DeleteStreamResponse,
  CancelJobExecutionResponse,
  UpdateMitigationActionResponse,
  DetachSecurityProfileResponse,
  CreateKeysAndCertificateResponse,
  CreateProvisioningTemplateResponse,
  GetRegistrationCodeResponse,
  ViolationEvent,
  DescribeDefaultAuthorizerResponse,
  UpdateThingGroupResponse,
  ListThingsInBillingGroupResponse,
  DeleteRoleAliasResponse,
  GetStatisticsResponse,
  UpdateRoleAliasResponse,
  GetBucketsAggregationResponse,
  DetachThingPrincipalResponse,
  MitigationActionIdentifier,
  DeleteDimensionResponse,
  DescribeJobTemplateResponse,
  JobExecutionSummaryForJob,
  DeleteJobResponse,
  ListAuditSuppressionsResponse,
  CreateDimensionResponse,
  UpdateBillingGroupResponse,
  ListProvisioningTemplateVersionsResponse,
  DeleteTopicRuleResponse,
  DescribeEndpointResponse,
  TransferCertificateResponse,
  ListOutgoingCertificatesResponse,
  OTAUpdateSummary,
  DeleteFleetMetricResponse,
  GetIndexingConfigurationResponse,
  ListTagsForResourceResponse,
  DescribeDomainConfigurationResponse,
  UpdateJobResponse,
  UpdateCertificateResponse,
  UntagResourceResponse,
  ListThingRegistrationTasksResponse,
  CancelDetectMitigationActionsTaskResponse,
  ThingTypeDefinition,
  CreateOtaUpdateResponse,
  CancelAuditTaskResponse,
  DetachPolicyResponse,
  JobExecutionSummaryForThing,
  AssociateTargetsWithJobResponse,
  AttachPolicyResponse,
  CreateDomainConfigurationResponse,
  GetPolicyResponse,
  SetV2LoggingLevelResponse,
  ListTopicRulesResponse,
  DescribeAuditSuppressionResponse,
  DescribeAuditTaskResponse,
  StartOnDemandAuditTaskResponse,
  ListCertificatesResponse,
  TestInvokeAuthorizerResponse,
  ListAttachedPoliciesResponse,
  StartAuditMitigationActionsTaskResponse,
  DescribeDetectMitigationActionsTaskResponse,
  ScheduledAuditMetadata,
  ListDetectMitigationActionsExecutionsResponse,
  OutgoingCertificate,
  DeleteJobTemplateResponse,
  GetEffectivePoliciesResponse,
  UpdateDomainConfigurationResponse,
  UpdateAuthorizerResponse,
  ListDomainConfigurationsResponse,
  DeletePolicyResponse,
  DescribeAuditFindingResponse,
  RemoveThingFromBillingGroupResponse,
  UpdateFleetMetricResponse,
  DescribeCaCertificateResponse,
  Policy,
  ListCustomMetricsResponse,
  RegisterCertificateWithoutCaResponse,
  ListThingRegistrationTaskReportsResponse,
  CreateTopicRuleDestinationResponse,
  ListThingTypesResponse,
  JobTemplateSummary,
  CreateProvisioningTemplateVersionResponse,
  DescribeScheduledAuditResponse,
  TestAuthorizationResponse,
  DeleteProvisioningTemplateVersionResponse,
  DeleteAccountAuditConfigurationResponse,
  DeleteBillingGroupResponse,
  ProvisioningTemplateVersionSummary,
  DescribeThingRegistrationTaskResponse,
  SecurityProfileTargetMapping,
  DeleteThingTypeResponse,
  CreateAuthorizerResponse,
  AuditTaskMetadata,
  DescribeFleetMetricResponse,
  DeleteSecurityProfileResponse,
  GetV2LoggingOptionsResponse,
  TopicRuleListItem,
  DescribeDimensionResponse,
  CreateThingGroupResponse,
  GetBehaviorModelTrainingSummariesResponse,
  CreateProvisioningClaimResponse,
  ListOtaUpdatesResponse,
  ListStreamsResponse,
  ListTargetsForPolicyResponse,
  AuditFinding,
  AuditMitigationActionExecutionMetadata,
  CreateCustomMetricResponse,
  DeleteThingResponse,
  ListTopicRuleDestinationsResponse,
  RejectCertificateTransferResponse,
  AttachThingPrincipalResponse,
  TopicRuleDestinationSummary,
  ListThingsResponse,
  DescribeAccountAuditConfigurationResponse,
  AddThingToThingGroupResponse,
  ListJobExecutionsForJobResponse,
  DeleteScheduledAuditResponse,
  RegisterCertificateResponse,
  CreateThingTypeResponse,
  GroupNameAndArn,
  DescribeAuthorizerResponse,
  UpdateTopicRuleDestinationResponse,
  AttachSecurityProfileResponse,
  ReplaceTopicRuleResponse,
  CreateScheduledAuditResponse,
  ListJobsResponse,
  RegisterCaCertificateResponse,
  ListActiveViolationsResponse,
  DeleteV2LoggingLevelResponse,
  GetPercentilesResponse,
  DeleteDomainConfigurationResponse,
  DescribeCertificateResponse,
  RemoveThingFromThingGroupResponse,
  DeleteDynamicThingGroupResponse,
  EnableTopicRuleResponse,
  ListSecurityProfilesForTargetResponse,
  UpdateDimensionResponse,
  DescribeMitigationActionResponse,
  ListRoleAliasesResponse,
  ListThingGroupsForThingResponse,
  TagResourceResponse,
  UpdateAuditSuppressionResponse,
  ListMitigationActionsResponse,
  DescribeIndexResponse,
  ListAuthorizersResponse,
  FleetMetricNameAndArn,
  GetTopicRuleDestinationResponse,
  UpdateDynamicThingGroupResponse,
  StartDetectMitigationActionsTaskResponse,
  UpdateProvisioningTemplateResponse,
  DetectMitigationActionsTaskSummary,
  ListTargetsForSecurityProfileResponse,
  ListCertificatesByCaResponse,
  DeleteTopicRuleDestinationResponse,
  CreatePolicyVersionResponse,
  ListThingPrincipalsResponse,
  StreamSummary,
  SecurityProfileTarget,
  PutVerificationStateOnViolationResponse,
  JobSummary,
  DescribeStreamResponse,
  StopThingRegistrationTaskResponse,
  DeleteCustomMetricResponse,
  DescribeProvisioningTemplateVersionResponse,
  CreateMitigationActionResponse,
  ClearDefaultAuthorizerResponse,
  UpdateCaCertificateResponse,
  CreateRoleAliasResponse,
  UpdateThingGroupsForThingResponse,
  ValidateSecurityProfileBehaviorsResponse,
  UpdateThingResponse,
  ListIndicesResponse,
  CACertificate,
  ListThingsInThingGroupResponse,
  DescribeJobExecutionResponse,
  CreateThingResponse,
  CreateJobResponse,
  UpdateEventConfigurationsResponse,
  CreateSecurityProfileResponse,
  UpdateScheduledAuditResponse,
  DeleteOtaUpdateResponse
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Iot extends AspectSupport[Iot] {
  val api: IotAsyncClient
  def deleteCustomMetric(
      request: DeleteCustomMetricRequest
  ): IO[AwsError, zio.aws.iot.model.DeleteCustomMetricResponse.ReadOnly]
  def createProvisioningTemplateVersion(
      request: CreateProvisioningTemplateVersionRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.CreateProvisioningTemplateVersionResponse.ReadOnly
  ]
  def registerThing(
      request: RegisterThingRequest
  ): IO[AwsError, zio.aws.iot.model.RegisterThingResponse.ReadOnly]
  def listProvisioningTemplateVersions(
      request: ListProvisioningTemplateVersionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iot.model.ProvisioningTemplateVersionSummary.ReadOnly
  ]
  def listProvisioningTemplateVersionsPaginated(
      request: ListProvisioningTemplateVersionsRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.ListProvisioningTemplateVersionsResponse.ReadOnly
  ]
  def updateAuditSuppression(
      request: UpdateAuditSuppressionRequest
  ): IO[AwsError, zio.aws.iot.model.UpdateAuditSuppressionResponse.ReadOnly]
  def listTargetsForSecurityProfile(
      request: ListTargetsForSecurityProfileRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.SecurityProfileTarget.ReadOnly]
  def listTargetsForSecurityProfilePaginated(
      request: ListTargetsForSecurityProfileRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.ListTargetsForSecurityProfileResponse.ReadOnly
  ]
  def createDynamicThingGroup(
      request: CreateDynamicThingGroupRequest
  ): IO[AwsError, zio.aws.iot.model.CreateDynamicThingGroupResponse.ReadOnly]
  def listStreams(
      request: ListStreamsRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.StreamSummary.ReadOnly]
  def listStreamsPaginated(
      request: ListStreamsRequest
  ): IO[AwsError, zio.aws.iot.model.ListStreamsResponse.ReadOnly]
  def createTopicRuleDestination(
      request: CreateTopicRuleDestinationRequest
  ): IO[AwsError, zio.aws.iot.model.CreateTopicRuleDestinationResponse.ReadOnly]
  def createScheduledAudit(
      request: CreateScheduledAuditRequest
  ): IO[AwsError, zio.aws.iot.model.CreateScheduledAuditResponse.ReadOnly]
  def describeJob(
      request: DescribeJobRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeJobResponse.ReadOnly]
  def createOTAUpdate(
      request: CreateOtaUpdateRequest
  ): IO[AwsError, zio.aws.iot.model.CreateOtaUpdateResponse.ReadOnly]
  def deleteDomainConfiguration(
      request: DeleteDomainConfigurationRequest
  ): IO[AwsError, zio.aws.iot.model.DeleteDomainConfigurationResponse.ReadOnly]
  def setV2LoggingLevel(request: SetV2LoggingLevelRequest): IO[AwsError, Unit]
  def deleteJobExecution(request: DeleteJobExecutionRequest): IO[AwsError, Unit]
  def testInvokeAuthorizer(
      request: TestInvokeAuthorizerRequest
  ): IO[AwsError, zio.aws.iot.model.TestInvokeAuthorizerResponse.ReadOnly]
  def updateCACertificate(
      request: UpdateCaCertificateRequest
  ): IO[AwsError, Unit]
  def deleteDimension(
      request: DeleteDimensionRequest
  ): IO[AwsError, zio.aws.iot.model.DeleteDimensionResponse.ReadOnly]
  def listIndices(
      request: ListIndicesRequest
  ): ZStream[Any, AwsError, IndexName]
  def listIndicesPaginated(
      request: ListIndicesRequest
  ): IO[AwsError, zio.aws.iot.model.ListIndicesResponse.ReadOnly]
  def removeThingFromThingGroup(
      request: RemoveThingFromThingGroupRequest
  ): IO[AwsError, zio.aws.iot.model.RemoveThingFromThingGroupResponse.ReadOnly]
  def describeAuthorizer(
      request: DescribeAuthorizerRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeAuthorizerResponse.ReadOnly]
  def updateIndexingConfiguration(
      request: UpdateIndexingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.UpdateIndexingConfigurationResponse.ReadOnly
  ]
  def cancelJobExecution(request: CancelJobExecutionRequest): IO[AwsError, Unit]
  def detachThingPrincipal(
      request: DetachThingPrincipalRequest
  ): IO[AwsError, zio.aws.iot.model.DetachThingPrincipalResponse.ReadOnly]
  def deleteBillingGroup(
      request: DeleteBillingGroupRequest
  ): IO[AwsError, zio.aws.iot.model.DeleteBillingGroupResponse.ReadOnly]
  def createKeysAndCertificate(
      request: CreateKeysAndCertificateRequest
  ): IO[AwsError, zio.aws.iot.model.CreateKeysAndCertificateResponse.ReadOnly]
  def updateScheduledAudit(
      request: UpdateScheduledAuditRequest
  ): IO[AwsError, zio.aws.iot.model.UpdateScheduledAuditResponse.ReadOnly]
  def deleteThingGroup(
      request: DeleteThingGroupRequest
  ): IO[AwsError, zio.aws.iot.model.DeleteThingGroupResponse.ReadOnly]
  def listJobTemplates(
      request: ListJobTemplatesRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.JobTemplateSummary.ReadOnly]
  def listJobTemplatesPaginated(
      request: ListJobTemplatesRequest
  ): IO[AwsError, zio.aws.iot.model.ListJobTemplatesResponse.ReadOnly]
  def describeProvisioningTemplate(
      request: DescribeProvisioningTemplateRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.DescribeProvisioningTemplateResponse.ReadOnly
  ]
  def listSecurityProfilesForTarget(
      request: ListSecurityProfilesForTargetRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iot.model.SecurityProfileTargetMapping.ReadOnly
  ]
  def listSecurityProfilesForTargetPaginated(
      request: ListSecurityProfilesForTargetRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.ListSecurityProfilesForTargetResponse.ReadOnly
  ]
  def cancelDetectMitigationActionsTask(
      request: CancelDetectMitigationActionsTaskRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.CancelDetectMitigationActionsTaskResponse.ReadOnly
  ]
  def getIndexingConfiguration(
      request: GetIndexingConfigurationRequest
  ): IO[AwsError, zio.aws.iot.model.GetIndexingConfigurationResponse.ReadOnly]
  def stopThingRegistrationTask(
      request: StopThingRegistrationTaskRequest
  ): IO[AwsError, zio.aws.iot.model.StopThingRegistrationTaskResponse.ReadOnly]
  def createSecurityProfile(
      request: CreateSecurityProfileRequest
  ): IO[AwsError, zio.aws.iot.model.CreateSecurityProfileResponse.ReadOnly]
  def updateDimension(
      request: UpdateDimensionRequest
  ): IO[AwsError, zio.aws.iot.model.UpdateDimensionResponse.ReadOnly]
  def updateCustomMetric(
      request: UpdateCustomMetricRequest
  ): IO[AwsError, zio.aws.iot.model.UpdateCustomMetricResponse.ReadOnly]
  def describeThingRegistrationTask(
      request: DescribeThingRegistrationTaskRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.DescribeThingRegistrationTaskResponse.ReadOnly
  ]
  def listCACertificates(
      request: ListCaCertificatesRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.CACertificate.ReadOnly]
  def listCACertificatesPaginated(
      request: ListCaCertificatesRequest
  ): IO[AwsError, zio.aws.iot.model.ListCaCertificatesResponse.ReadOnly]
  def deleteProvisioningTemplateVersion(
      request: DeleteProvisioningTemplateVersionRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.DeleteProvisioningTemplateVersionResponse.ReadOnly
  ]
  def getCardinality(
      request: GetCardinalityRequest
  ): IO[AwsError, zio.aws.iot.model.GetCardinalityResponse.ReadOnly]
  def listDomainConfigurations(
      request: ListDomainConfigurationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iot.model.DomainConfigurationSummary.ReadOnly
  ]
  def listDomainConfigurationsPaginated(
      request: ListDomainConfigurationsRequest
  ): IO[AwsError, zio.aws.iot.model.ListDomainConfigurationsResponse.ReadOnly]
  def describeAccountAuditConfiguration(
      request: DescribeAccountAuditConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.DescribeAccountAuditConfigurationResponse.ReadOnly
  ]
  def putVerificationStateOnViolation(
      request: PutVerificationStateOnViolationRequest
  ): IO[AwsError, ReadOnly]
  def listPrincipalThings(
      request: ListPrincipalThingsRequest
  ): ZStream[Any, AwsError, ThingName]
  def listPrincipalThingsPaginated(
      request: ListPrincipalThingsRequest
  ): IO[AwsError, zio.aws.iot.model.ListPrincipalThingsResponse.ReadOnly]
  def getBehaviorModelTrainingSummaries(
      request: GetBehaviorModelTrainingSummariesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iot.model.BehaviorModelTrainingSummary.ReadOnly
  ]
  def getBehaviorModelTrainingSummariesPaginated(
      request: GetBehaviorModelTrainingSummariesRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.GetBehaviorModelTrainingSummariesResponse.ReadOnly
  ]
  def describeScheduledAudit(
      request: DescribeScheduledAuditRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeScheduledAuditResponse.ReadOnly]
  def updateThingGroupsForThing(
      request: UpdateThingGroupsForThingRequest
  ): IO[AwsError, zio.aws.iot.model.UpdateThingGroupsForThingResponse.ReadOnly]
  def updateThing(
      request: UpdateThingRequest
  ): IO[AwsError, zio.aws.iot.model.UpdateThingResponse.ReadOnly]
  def describeThing(
      request: DescribeThingRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeThingResponse.ReadOnly]
  def createProvisioningClaim(
      request: CreateProvisioningClaimRequest
  ): IO[AwsError, zio.aws.iot.model.CreateProvisioningClaimResponse.ReadOnly]
  def getPercentiles(
      request: GetPercentilesRequest
  ): IO[AwsError, zio.aws.iot.model.GetPercentilesResponse.ReadOnly]
  def deleteMitigationAction(
      request: DeleteMitigationActionRequest
  ): IO[AwsError, zio.aws.iot.model.DeleteMitigationActionResponse.ReadOnly]
  def describeJobExecution(
      request: DescribeJobExecutionRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeJobExecutionResponse.ReadOnly]
  def updateStream(
      request: UpdateStreamRequest
  ): IO[AwsError, zio.aws.iot.model.UpdateStreamResponse.ReadOnly]
  def deleteAuditSuppression(
      request: DeleteAuditSuppressionRequest
  ): IO[AwsError, zio.aws.iot.model.DeleteAuditSuppressionResponse.ReadOnly]
  def deleteJobTemplate(request: DeleteJobTemplateRequest): IO[AwsError, Unit]
  def getJobDocument(
      request: GetJobDocumentRequest
  ): IO[AwsError, zio.aws.iot.model.GetJobDocumentResponse.ReadOnly]
  def getRegistrationCode(
      request: GetRegistrationCodeRequest
  ): IO[AwsError, zio.aws.iot.model.GetRegistrationCodeResponse.ReadOnly]
  def updateThingGroup(
      request: UpdateThingGroupRequest
  ): IO[AwsError, zio.aws.iot.model.UpdateThingGroupResponse.ReadOnly]
  def listJobExecutionsForJob(request: ListJobExecutionsForJobRequest): ZStream[
    Any,
    AwsError,
    zio.aws.iot.model.JobExecutionSummaryForJob.ReadOnly
  ]
  def listJobExecutionsForJobPaginated(
      request: ListJobExecutionsForJobRequest
  ): IO[AwsError, zio.aws.iot.model.ListJobExecutionsForJobResponse.ReadOnly]
  def listAuditSuppressions(
      request: ListAuditSuppressionsRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.AuditSuppression.ReadOnly]
  def listAuditSuppressionsPaginated(
      request: ListAuditSuppressionsRequest
  ): IO[AwsError, zio.aws.iot.model.ListAuditSuppressionsResponse.ReadOnly]
  def describeManagedJobTemplate(
      request: DescribeManagedJobTemplateRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeManagedJobTemplateResponse.ReadOnly]
  def createBillingGroup(
      request: CreateBillingGroupRequest
  ): IO[AwsError, zio.aws.iot.model.CreateBillingGroupResponse.ReadOnly]
  def listTargetsForPolicy(
      request: ListTargetsForPolicyRequest
  ): ZStream[Any, AwsError, PolicyTarget]
  def listTargetsForPolicyPaginated(
      request: ListTargetsForPolicyRequest
  ): IO[AwsError, zio.aws.iot.model.ListTargetsForPolicyResponse.ReadOnly]
  def describeDomainConfiguration(
      request: DescribeDomainConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.DescribeDomainConfigurationResponse.ReadOnly
  ]
  def describeCACertificate(
      request: DescribeCaCertificateRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeCaCertificateResponse.ReadOnly]
  def updateDomainConfiguration(
      request: UpdateDomainConfigurationRequest
  ): IO[AwsError, zio.aws.iot.model.UpdateDomainConfigurationResponse.ReadOnly]
  def createJob(
      request: CreateJobRequest
  ): IO[AwsError, zio.aws.iot.model.CreateJobResponse.ReadOnly]
  def setLoggingOptions(request: SetLoggingOptionsRequest): IO[AwsError, Unit]
  def listAttachedPolicies(
      request: ListAttachedPoliciesRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.Policy.ReadOnly]
  def listAttachedPoliciesPaginated(
      request: ListAttachedPoliciesRequest
  ): IO[AwsError, zio.aws.iot.model.ListAttachedPoliciesResponse.ReadOnly]
  def detachPolicy(request: DetachPolicyRequest): IO[AwsError, Unit]
  def describeIndex(
      request: DescribeIndexRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeIndexResponse.ReadOnly]
  def cancelAuditMitigationActionsTask(
      request: CancelAuditMitigationActionsTaskRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.CancelAuditMitigationActionsTaskResponse.ReadOnly
  ]
  def attachThingPrincipal(
      request: AttachThingPrincipalRequest
  ): IO[AwsError, zio.aws.iot.model.AttachThingPrincipalResponse.ReadOnly]
  def describeMitigationAction(
      request: DescribeMitigationActionRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeMitigationActionResponse.ReadOnly]
  def createProvisioningTemplate(
      request: CreateProvisioningTemplateRequest
  ): IO[AwsError, zio.aws.iot.model.CreateProvisioningTemplateResponse.ReadOnly]
  def listThingsInBillingGroup(
      request: ListThingsInBillingGroupRequest
  ): ZStream[Any, AwsError, ThingName]
  def listThingsInBillingGroupPaginated(
      request: ListThingsInBillingGroupRequest
  ): IO[AwsError, zio.aws.iot.model.ListThingsInBillingGroupResponse.ReadOnly]
  def cancelJob(
      request: CancelJobRequest
  ): IO[AwsError, zio.aws.iot.model.CancelJobResponse.ReadOnly]
  def listViolationEvents(
      request: ListViolationEventsRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.ViolationEvent.ReadOnly]
  def listViolationEventsPaginated(
      request: ListViolationEventsRequest
  ): IO[AwsError, zio.aws.iot.model.ListViolationEventsResponse.ReadOnly]
  def describeThingGroup(
      request: DescribeThingGroupRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeThingGroupResponse.ReadOnly]
  def listTopicRules(
      request: ListTopicRulesRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.TopicRuleListItem.ReadOnly]
  def listTopicRulesPaginated(
      request: ListTopicRulesRequest
  ): IO[AwsError, zio.aws.iot.model.ListTopicRulesResponse.ReadOnly]
  def listPolicyVersions(
      request: ListPolicyVersionsRequest
  ): IO[AwsError, zio.aws.iot.model.ListPolicyVersionsResponse.ReadOnly]
  def updateAuthorizer(
      request: UpdateAuthorizerRequest
  ): IO[AwsError, zio.aws.iot.model.UpdateAuthorizerResponse.ReadOnly]
  def createDomainConfiguration(
      request: CreateDomainConfigurationRequest
  ): IO[AwsError, zio.aws.iot.model.CreateDomainConfigurationResponse.ReadOnly]
  def getOTAUpdate(
      request: GetOtaUpdateRequest
  ): IO[AwsError, zio.aws.iot.model.GetOtaUpdateResponse.ReadOnly]
  def registerCertificateWithoutCA(
      request: RegisterCertificateWithoutCaRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.RegisterCertificateWithoutCaResponse.ReadOnly
  ]
  def rejectCertificateTransfer(
      request: RejectCertificateTransferRequest
  ): IO[AwsError, Unit]
  def describeAuditFinding(
      request: DescribeAuditFindingRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeAuditFindingResponse.ReadOnly]
  def startOnDemandAuditTask(
      request: StartOnDemandAuditTaskRequest
  ): IO[AwsError, zio.aws.iot.model.StartOnDemandAuditTaskResponse.ReadOnly]
  def deleteSecurityProfile(
      request: DeleteSecurityProfileRequest
  ): IO[AwsError, zio.aws.iot.model.DeleteSecurityProfileResponse.ReadOnly]
  def listAuditMitigationActionsExecutions(
      request: ListAuditMitigationActionsExecutionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iot.model.AuditMitigationActionExecutionMetadata.ReadOnly
  ]
  def listAuditMitigationActionsExecutionsPaginated(
      request: ListAuditMitigationActionsExecutionsRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.ListAuditMitigationActionsExecutionsResponse.ReadOnly
  ]
  def getTopicRuleDestination(
      request: GetTopicRuleDestinationRequest
  ): IO[AwsError, zio.aws.iot.model.GetTopicRuleDestinationResponse.ReadOnly]
  def listThingGroups(
      request: ListThingGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.GroupNameAndArn.ReadOnly]
  def listThingGroupsPaginated(
      request: ListThingGroupsRequest
  ): IO[AwsError, zio.aws.iot.model.ListThingGroupsResponse.ReadOnly]
  def deleteCertificate(request: DeleteCertificateRequest): IO[AwsError, Unit]
  def describeJobTemplate(
      request: DescribeJobTemplateRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeJobTemplateResponse.ReadOnly]
  def deleteFleetMetric(request: DeleteFleetMetricRequest): IO[AwsError, Unit]
  def setDefaultPolicyVersion(
      request: SetDefaultPolicyVersionRequest
  ): IO[AwsError, Unit]
  def deleteCACertificate(
      request: DeleteCaCertificateRequest
  ): IO[AwsError, zio.aws.iot.model.DeleteCaCertificateResponse.ReadOnly]
  def deleteV2LoggingLevel(
      request: DeleteV2LoggingLevelRequest
  ): IO[AwsError, Unit]
  def listAuditFindings(
      request: ListAuditFindingsRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.AuditFinding.ReadOnly]
  def listAuditFindingsPaginated(
      request: ListAuditFindingsRequest
  ): IO[AwsError, zio.aws.iot.model.ListAuditFindingsResponse.ReadOnly]
  def validateSecurityProfileBehaviors(
      request: ValidateSecurityProfileBehaviorsRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.ValidateSecurityProfileBehaviorsResponse.ReadOnly
  ]
  def listRoleAliases(
      request: ListRoleAliasesRequest
  ): ZStream[Any, AwsError, RoleAlias]
  def listRoleAliasesPaginated(
      request: ListRoleAliasesRequest
  ): IO[AwsError, zio.aws.iot.model.ListRoleAliasesResponse.ReadOnly]
  def listCertificatesByCA(
      request: ListCertificatesByCaRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.Certificate.ReadOnly]
  def listCertificatesByCAPaginated(
      request: ListCertificatesByCaRequest
  ): IO[AwsError, zio.aws.iot.model.ListCertificatesByCaResponse.ReadOnly]
  def updateAccountAuditConfiguration(
      request: UpdateAccountAuditConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.UpdateAccountAuditConfigurationResponse.ReadOnly
  ]
  def describeSecurityProfile(
      request: DescribeSecurityProfileRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeSecurityProfileResponse.ReadOnly]
  def listAuthorizers(
      request: ListAuthorizersRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.AuthorizerSummary.ReadOnly]
  def listAuthorizersPaginated(
      request: ListAuthorizersRequest
  ): IO[AwsError, zio.aws.iot.model.ListAuthorizersResponse.ReadOnly]
  def deleteStream(
      request: DeleteStreamRequest
  ): IO[AwsError, zio.aws.iot.model.DeleteStreamResponse.ReadOnly]
  def deleteOTAUpdate(
      request: DeleteOtaUpdateRequest
  ): IO[AwsError, zio.aws.iot.model.DeleteOtaUpdateResponse.ReadOnly]
  def updateMitigationAction(
      request: UpdateMitigationActionRequest
  ): IO[AwsError, zio.aws.iot.model.UpdateMitigationActionResponse.ReadOnly]
  def clearDefaultAuthorizer(
      request: ClearDefaultAuthorizerRequest
  ): IO[AwsError, zio.aws.iot.model.ClearDefaultAuthorizerResponse.ReadOnly]
  def deleteScheduledAudit(
      request: DeleteScheduledAuditRequest
  ): IO[AwsError, zio.aws.iot.model.DeleteScheduledAuditResponse.ReadOnly]
  def listPolicies(
      request: ListPoliciesRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.Policy.ReadOnly]
  def listPoliciesPaginated(
      request: ListPoliciesRequest
  ): IO[AwsError, zio.aws.iot.model.ListPoliciesResponse.ReadOnly]
  def describeProvisioningTemplateVersion(
      request: DescribeProvisioningTemplateVersionRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.DescribeProvisioningTemplateVersionResponse.ReadOnly
  ]
  def listCustomMetrics(
      request: ListCustomMetricsRequest
  ): ZStream[Any, AwsError, MetricName]
  def listCustomMetricsPaginated(
      request: ListCustomMetricsRequest
  ): IO[AwsError, zio.aws.iot.model.ListCustomMetricsResponse.ReadOnly]
  def listOTAUpdates(
      request: ListOtaUpdatesRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.OTAUpdateSummary.ReadOnly]
  def listOTAUpdatesPaginated(
      request: ListOtaUpdatesRequest
  ): IO[AwsError, zio.aws.iot.model.ListOtaUpdatesResponse.ReadOnly]
  def replaceTopicRule(request: ReplaceTopicRuleRequest): IO[AwsError, Unit]
  def getV2LoggingOptions(
      request: GetV2LoggingOptionsRequest
  ): IO[AwsError, zio.aws.iot.model.GetV2LoggingOptionsResponse.ReadOnly]
  def describeStream(
      request: DescribeStreamRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeStreamResponse.ReadOnly]
  def listMitigationActions(request: ListMitigationActionsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.iot.model.MitigationActionIdentifier.ReadOnly
  ]
  def listMitigationActionsPaginated(
      request: ListMitigationActionsRequest
  ): IO[AwsError, zio.aws.iot.model.ListMitigationActionsResponse.ReadOnly]
  def cancelCertificateTransfer(
      request: CancelCertificateTransferRequest
  ): IO[AwsError, Unit]
  def createStream(
      request: CreateStreamRequest
  ): IO[AwsError, zio.aws.iot.model.CreateStreamResponse.ReadOnly]
  def acceptCertificateTransfer(
      request: AcceptCertificateTransferRequest
  ): IO[AwsError, Unit]
  def listDetectMitigationActionsExecutions(
      request: ListDetectMitigationActionsExecutionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iot.model.DetectMitigationActionExecution.ReadOnly
  ]
  def listDetectMitigationActionsExecutionsPaginated(
      request: ListDetectMitigationActionsExecutionsRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.ListDetectMitigationActionsExecutionsResponse.ReadOnly
  ]
  def createTopicRule(request: CreateTopicRuleRequest): IO[AwsError, Unit]
  def deletePolicyVersion(
      request: DeletePolicyVersionRequest
  ): IO[AwsError, Unit]
  def listTopicRuleDestinations(
      request: ListTopicRuleDestinationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iot.model.TopicRuleDestinationSummary.ReadOnly
  ]
  def listTopicRuleDestinationsPaginated(
      request: ListTopicRuleDestinationsRequest
  ): IO[AwsError, zio.aws.iot.model.ListTopicRuleDestinationsResponse.ReadOnly]
  def searchIndex(
      request: SearchIndexRequest
  ): IO[AwsError, zio.aws.iot.model.SearchIndexResponse.ReadOnly]
  def attachSecurityProfile(
      request: AttachSecurityProfileRequest
  ): IO[AwsError, zio.aws.iot.model.AttachSecurityProfileResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.iot.model.UntagResourceResponse.ReadOnly]
  def updateCertificate(request: UpdateCertificateRequest): IO[AwsError, Unit]
  def createFleetMetric(
      request: CreateFleetMetricRequest
  ): IO[AwsError, zio.aws.iot.model.CreateFleetMetricResponse.ReadOnly]
  def describeEndpoint(
      request: DescribeEndpointRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeEndpointResponse.ReadOnly]
  def updateProvisioningTemplate(
      request: UpdateProvisioningTemplateRequest
  ): IO[AwsError, zio.aws.iot.model.UpdateProvisioningTemplateResponse.ReadOnly]
  def listSecurityProfiles(request: ListSecurityProfilesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.iot.model.SecurityProfileIdentifier.ReadOnly
  ]
  def listSecurityProfilesPaginated(
      request: ListSecurityProfilesRequest
  ): IO[AwsError, zio.aws.iot.model.ListSecurityProfilesResponse.ReadOnly]
  def deleteTopicRuleDestination(
      request: DeleteTopicRuleDestinationRequest
  ): IO[AwsError, zio.aws.iot.model.DeleteTopicRuleDestinationResponse.ReadOnly]
  def createCertificateFromCsr(
      request: CreateCertificateFromCsrRequest
  ): IO[AwsError, zio.aws.iot.model.CreateCertificateFromCsrResponse.ReadOnly]
  def createRoleAlias(
      request: CreateRoleAliasRequest
  ): IO[AwsError, zio.aws.iot.model.CreateRoleAliasResponse.ReadOnly]
  def registerCACertificate(
      request: RegisterCaCertificateRequest
  ): IO[AwsError, zio.aws.iot.model.RegisterCaCertificateResponse.ReadOnly]
  def setV2LoggingOptions(
      request: SetV2LoggingOptionsRequest
  ): IO[AwsError, Unit]
  def getStatistics(
      request: GetStatisticsRequest
  ): IO[AwsError, zio.aws.iot.model.GetStatisticsResponse.ReadOnly]
  def listDimensions(
      request: ListDimensionsRequest
  ): ZStream[Any, AwsError, DimensionName]
  def listDimensionsPaginated(
      request: ListDimensionsRequest
  ): IO[AwsError, zio.aws.iot.model.ListDimensionsResponse.ReadOnly]
  def createThingGroup(
      request: CreateThingGroupRequest
  ): IO[AwsError, zio.aws.iot.model.CreateThingGroupResponse.ReadOnly]
  def listDetectMitigationActionsTasks(
      request: ListDetectMitigationActionsTasksRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iot.model.DetectMitigationActionsTaskSummary.ReadOnly
  ]
  def listDetectMitigationActionsTasksPaginated(
      request: ListDetectMitigationActionsTasksRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.ListDetectMitigationActionsTasksResponse.ReadOnly
  ]
  def updateFleetMetric(request: UpdateFleetMetricRequest): IO[AwsError, Unit]
  def deleteTopicRule(request: DeleteTopicRuleRequest): IO[AwsError, Unit]
  def createMitigationAction(
      request: CreateMitigationActionRequest
  ): IO[AwsError, zio.aws.iot.model.CreateMitigationActionResponse.ReadOnly]
  def describeCustomMetric(
      request: DescribeCustomMetricRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeCustomMetricResponse.ReadOnly]
  def describeDetectMitigationActionsTask(
      request: DescribeDetectMitigationActionsTaskRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.DescribeDetectMitigationActionsTaskResponse.ReadOnly
  ]
  def listBillingGroups(
      request: ListBillingGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.GroupNameAndArn.ReadOnly]
  def listBillingGroupsPaginated(
      request: ListBillingGroupsRequest
  ): IO[AwsError, zio.aws.iot.model.ListBillingGroupsResponse.ReadOnly]
  def updateJob(request: UpdateJobRequest): IO[AwsError, Unit]
  def createAuthorizer(
      request: CreateAuthorizerRequest
  ): IO[AwsError, zio.aws.iot.model.CreateAuthorizerResponse.ReadOnly]
  def setDefaultAuthorizer(
      request: SetDefaultAuthorizerRequest
  ): IO[AwsError, zio.aws.iot.model.SetDefaultAuthorizerResponse.ReadOnly]
  def deleteRoleAlias(
      request: DeleteRoleAliasRequest
  ): IO[AwsError, zio.aws.iot.model.DeleteRoleAliasResponse.ReadOnly]
  def attachPolicy(request: AttachPolicyRequest): IO[AwsError, Unit]
  def listThingRegistrationTasks(
      request: ListThingRegistrationTasksRequest
  ): ZStream[Any, AwsError, TaskId]
  def listThingRegistrationTasksPaginated(
      request: ListThingRegistrationTasksRequest
  ): IO[AwsError, zio.aws.iot.model.ListThingRegistrationTasksResponse.ReadOnly]
  def describeAuditSuppression(
      request: DescribeAuditSuppressionRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeAuditSuppressionResponse.ReadOnly]
  def listThingPrincipals(
      request: ListThingPrincipalsRequest
  ): ZStream[Any, AwsError, PrincipalArn]
  def listThingPrincipalsPaginated(
      request: ListThingPrincipalsRequest
  ): IO[AwsError, zio.aws.iot.model.ListThingPrincipalsResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.Tag.ReadOnly]
  def listTagsForResourcePaginated(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.iot.model.ListTagsForResourceResponse.ReadOnly]
  def deleteThing(
      request: DeleteThingRequest
  ): IO[AwsError, zio.aws.iot.model.DeleteThingResponse.ReadOnly]
  def listAuditMitigationActionsTasks(
      request: ListAuditMitigationActionsTasksRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iot.model.AuditMitigationActionsTaskMetadata.ReadOnly
  ]
  def listAuditMitigationActionsTasksPaginated(
      request: ListAuditMitigationActionsTasksRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.ListAuditMitigationActionsTasksResponse.ReadOnly
  ]
  def listJobs(
      request: ListJobsRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.JobSummary.ReadOnly]
  def listJobsPaginated(
      request: ListJobsRequest
  ): IO[AwsError, zio.aws.iot.model.ListJobsResponse.ReadOnly]
  def createCustomMetric(
      request: CreateCustomMetricRequest
  ): IO[AwsError, zio.aws.iot.model.CreateCustomMetricResponse.ReadOnly]
  def createPolicy(
      request: CreatePolicyRequest
  ): IO[AwsError, zio.aws.iot.model.CreatePolicyResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.iot.model.TagResourceResponse.ReadOnly]
  def enableTopicRule(request: EnableTopicRuleRequest): IO[AwsError, Unit]
  def deleteThingType(
      request: DeleteThingTypeRequest
  ): IO[AwsError, zio.aws.iot.model.DeleteThingTypeResponse.ReadOnly]
  def listManagedJobTemplates(
      request: ListManagedJobTemplatesRequest
  ): IO[AwsError, zio.aws.iot.model.ListManagedJobTemplatesResponse.ReadOnly]
  def listThingsInThingGroup(
      request: ListThingsInThingGroupRequest
  ): ZStream[Any, AwsError, ThingName]
  def listThingsInThingGroupPaginated(
      request: ListThingsInThingGroupRequest
  ): IO[AwsError, zio.aws.iot.model.ListThingsInThingGroupResponse.ReadOnly]
  def getTopicRule(
      request: GetTopicRuleRequest
  ): IO[AwsError, zio.aws.iot.model.GetTopicRuleResponse.ReadOnly]
  def listScheduledAudits(
      request: ListScheduledAuditsRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.ScheduledAuditMetadata.ReadOnly]
  def listScheduledAuditsPaginated(
      request: ListScheduledAuditsRequest
  ): IO[AwsError, zio.aws.iot.model.ListScheduledAuditsResponse.ReadOnly]
  def startThingRegistrationTask(
      request: StartThingRegistrationTaskRequest
  ): IO[AwsError, zio.aws.iot.model.StartThingRegistrationTaskResponse.ReadOnly]
  def listV2LoggingLevels(
      request: ListV2LoggingLevelsRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.LogTargetConfiguration.ReadOnly]
  def listV2LoggingLevelsPaginated(
      request: ListV2LoggingLevelsRequest
  ): IO[AwsError, zio.aws.iot.model.ListV2LoggingLevelsResponse.ReadOnly]
  def deletePolicy(request: DeletePolicyRequest): IO[AwsError, Unit]
  def deleteAuthorizer(
      request: DeleteAuthorizerRequest
  ): IO[AwsError, zio.aws.iot.model.DeleteAuthorizerResponse.ReadOnly]
  def getPolicy(
      request: GetPolicyRequest
  ): IO[AwsError, zio.aws.iot.model.GetPolicyResponse.ReadOnly]
  def startAuditMitigationActionsTask(
      request: StartAuditMitigationActionsTaskRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.StartAuditMitigationActionsTaskResponse.ReadOnly
  ]
  def transferCertificate(
      request: TransferCertificateRequest
  ): IO[AwsError, zio.aws.iot.model.TransferCertificateResponse.ReadOnly]
  def addThingToThingGroup(
      request: AddThingToThingGroupRequest
  ): IO[AwsError, zio.aws.iot.model.AddThingToThingGroupResponse.ReadOnly]
  def startDetectMitigationActionsTask(
      request: StartDetectMitigationActionsTaskRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.StartDetectMitigationActionsTaskResponse.ReadOnly
  ]
  def associateTargetsWithJob(
      request: AssociateTargetsWithJobRequest
  ): IO[AwsError, zio.aws.iot.model.AssociateTargetsWithJobResponse.ReadOnly]
  def describeEventConfigurations(
      request: DescribeEventConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.DescribeEventConfigurationsResponse.ReadOnly
  ]
  def describeThingType(
      request: DescribeThingTypeRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeThingTypeResponse.ReadOnly]
  def listJobExecutionsForThing(
      request: ListJobExecutionsForThingRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iot.model.JobExecutionSummaryForThing.ReadOnly
  ]
  def listJobExecutionsForThingPaginated(
      request: ListJobExecutionsForThingRequest
  ): IO[AwsError, zio.aws.iot.model.ListJobExecutionsForThingResponse.ReadOnly]
  def updateRoleAlias(
      request: UpdateRoleAliasRequest
  ): IO[AwsError, zio.aws.iot.model.UpdateRoleAliasResponse.ReadOnly]
  def listProvisioningTemplates(
      request: ListProvisioningTemplatesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iot.model.ProvisioningTemplateSummary.ReadOnly
  ]
  def listProvisioningTemplatesPaginated(
      request: ListProvisioningTemplatesRequest
  ): IO[AwsError, zio.aws.iot.model.ListProvisioningTemplatesResponse.ReadOnly]
  def listThingTypes(
      request: ListThingTypesRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.ThingTypeDefinition.ReadOnly]
  def listThingTypesPaginated(
      request: ListThingTypesRequest
  ): IO[AwsError, zio.aws.iot.model.ListThingTypesResponse.ReadOnly]
  def disableTopicRule(request: DisableTopicRuleRequest): IO[AwsError, Unit]
  def registerCertificate(
      request: RegisterCertificateRequest
  ): IO[AwsError, zio.aws.iot.model.RegisterCertificateResponse.ReadOnly]
  def describeDimension(
      request: DescribeDimensionRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeDimensionResponse.ReadOnly]
  def createPolicyVersion(
      request: CreatePolicyVersionRequest
  ): IO[AwsError, zio.aws.iot.model.CreatePolicyVersionResponse.ReadOnly]
  def deleteRegistrationCode(
      request: DeleteRegistrationCodeRequest
  ): IO[AwsError, zio.aws.iot.model.DeleteRegistrationCodeResponse.ReadOnly]
  def describeBillingGroup(
      request: DescribeBillingGroupRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeBillingGroupResponse.ReadOnly]
  def updateSecurityProfile(
      request: UpdateSecurityProfileRequest
  ): IO[AwsError, zio.aws.iot.model.UpdateSecurityProfileResponse.ReadOnly]
  def updateTopicRuleDestination(
      request: UpdateTopicRuleDestinationRequest
  ): IO[AwsError, zio.aws.iot.model.UpdateTopicRuleDestinationResponse.ReadOnly]
  def updateBillingGroup(
      request: UpdateBillingGroupRequest
  ): IO[AwsError, zio.aws.iot.model.UpdateBillingGroupResponse.ReadOnly]
  def getEffectivePolicies(
      request: GetEffectivePoliciesRequest
  ): IO[AwsError, zio.aws.iot.model.GetEffectivePoliciesResponse.ReadOnly]
  def listAuditTasks(
      request: ListAuditTasksRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.AuditTaskMetadata.ReadOnly]
  def listAuditTasksPaginated(
      request: ListAuditTasksRequest
  ): IO[AwsError, zio.aws.iot.model.ListAuditTasksResponse.ReadOnly]
  def describeCertificate(
      request: DescribeCertificateRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeCertificateResponse.ReadOnly]
  def describeAuditMitigationActionsTask(
      request: DescribeAuditMitigationActionsTaskRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.DescribeAuditMitigationActionsTaskResponse.ReadOnly
  ]
  def createThingType(
      request: CreateThingTypeRequest
  ): IO[AwsError, zio.aws.iot.model.CreateThingTypeResponse.ReadOnly]
  def createAuditSuppression(
      request: CreateAuditSuppressionRequest
  ): IO[AwsError, zio.aws.iot.model.CreateAuditSuppressionResponse.ReadOnly]
  def getLoggingOptions(
      request: GetLoggingOptionsRequest
  ): IO[AwsError, zio.aws.iot.model.GetLoggingOptionsResponse.ReadOnly]
  def listThingGroupsForThing(
      request: ListThingGroupsForThingRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.GroupNameAndArn.ReadOnly]
  def listThingGroupsForThingPaginated(
      request: ListThingGroupsForThingRequest
  ): IO[AwsError, zio.aws.iot.model.ListThingGroupsForThingResponse.ReadOnly]
  def getBucketsAggregation(
      request: GetBucketsAggregationRequest
  ): IO[AwsError, zio.aws.iot.model.GetBucketsAggregationResponse.ReadOnly]
  def removeThingFromBillingGroup(
      request: RemoveThingFromBillingGroupRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.RemoveThingFromBillingGroupResponse.ReadOnly
  ]
  def listCertificates(
      request: ListCertificatesRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.Certificate.ReadOnly]
  def listCertificatesPaginated(
      request: ListCertificatesRequest
  ): IO[AwsError, zio.aws.iot.model.ListCertificatesResponse.ReadOnly]
  def getPolicyVersion(
      request: GetPolicyVersionRequest
  ): IO[AwsError, zio.aws.iot.model.GetPolicyVersionResponse.ReadOnly]
  def describeRoleAlias(
      request: DescribeRoleAliasRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeRoleAliasResponse.ReadOnly]
  def deleteProvisioningTemplate(
      request: DeleteProvisioningTemplateRequest
  ): IO[AwsError, zio.aws.iot.model.DeleteProvisioningTemplateResponse.ReadOnly]
  def updateDynamicThingGroup(
      request: UpdateDynamicThingGroupRequest
  ): IO[AwsError, zio.aws.iot.model.UpdateDynamicThingGroupResponse.ReadOnly]
  def createDimension(
      request: CreateDimensionRequest
  ): IO[AwsError, zio.aws.iot.model.CreateDimensionResponse.ReadOnly]
  def deprecateThingType(
      request: DeprecateThingTypeRequest
  ): IO[AwsError, zio.aws.iot.model.DeprecateThingTypeResponse.ReadOnly]
  def addThingToBillingGroup(
      request: AddThingToBillingGroupRequest
  ): IO[AwsError, zio.aws.iot.model.AddThingToBillingGroupResponse.ReadOnly]
  def describeDefaultAuthorizer(
      request: DescribeDefaultAuthorizerRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeDefaultAuthorizerResponse.ReadOnly]
  def testAuthorization(
      request: TestAuthorizationRequest
  ): IO[AwsError, zio.aws.iot.model.TestAuthorizationResponse.ReadOnly]
  def listOutgoingCertificates(
      request: ListOutgoingCertificatesRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.OutgoingCertificate.ReadOnly]
  def listOutgoingCertificatesPaginated(
      request: ListOutgoingCertificatesRequest
  ): IO[AwsError, zio.aws.iot.model.ListOutgoingCertificatesResponse.ReadOnly]
  def confirmTopicRuleDestination(
      request: ConfirmTopicRuleDestinationRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.ConfirmTopicRuleDestinationResponse.ReadOnly
  ]
  def deleteAccountAuditConfiguration(
      request: DeleteAccountAuditConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.DeleteAccountAuditConfigurationResponse.ReadOnly
  ]
  def describeFleetMetric(
      request: DescribeFleetMetricRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeFleetMetricResponse.ReadOnly]
  def listThings(
      request: ListThingsRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.ThingAttribute.ReadOnly]
  def listThingsPaginated(
      request: ListThingsRequest
  ): IO[AwsError, zio.aws.iot.model.ListThingsResponse.ReadOnly]
  def describeAuditTask(
      request: DescribeAuditTaskRequest
  ): IO[AwsError, zio.aws.iot.model.DescribeAuditTaskResponse.ReadOnly]
  def updateEventConfigurations(
      request: UpdateEventConfigurationsRequest
  ): IO[AwsError, zio.aws.iot.model.UpdateEventConfigurationsResponse.ReadOnly]
  def deleteJob(request: DeleteJobRequest): IO[AwsError, Unit]
  def listThingRegistrationTaskReports(
      request: ListThingRegistrationTaskReportsRequest
  ): ZStream[Any, AwsError, S3FileUrl]
  def listThingRegistrationTaskReportsPaginated(
      request: ListThingRegistrationTaskReportsRequest
  ): IO[
    AwsError,
    zio.aws.iot.model.ListThingRegistrationTaskReportsResponse.ReadOnly
  ]
  def createJobTemplate(
      request: CreateJobTemplateRequest
  ): IO[AwsError, zio.aws.iot.model.CreateJobTemplateResponse.ReadOnly]
  def listFleetMetrics(
      request: ListFleetMetricsRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.FleetMetricNameAndArn.ReadOnly]
  def listFleetMetricsPaginated(
      request: ListFleetMetricsRequest
  ): IO[AwsError, zio.aws.iot.model.ListFleetMetricsResponse.ReadOnly]
  def listActiveViolations(
      request: ListActiveViolationsRequest
  ): ZStream[Any, AwsError, zio.aws.iot.model.ActiveViolation.ReadOnly]
  def listActiveViolationsPaginated(
      request: ListActiveViolationsRequest
  ): IO[AwsError, zio.aws.iot.model.ListActiveViolationsResponse.ReadOnly]
  def cancelAuditTask(
      request: CancelAuditTaskRequest
  ): IO[AwsError, zio.aws.iot.model.CancelAuditTaskResponse.ReadOnly]
  def deleteDynamicThingGroup(
      request: DeleteDynamicThingGroupRequest
  ): IO[AwsError, zio.aws.iot.model.DeleteDynamicThingGroupResponse.ReadOnly]
  def detachSecurityProfile(
      request: DetachSecurityProfileRequest
  ): IO[AwsError, zio.aws.iot.model.DetachSecurityProfileResponse.ReadOnly]
  def createThing(
      request: CreateThingRequest
  ): IO[AwsError, zio.aws.iot.model.CreateThingResponse.ReadOnly]
}
object Iot {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Iot] = customized(identity)
  def customized(
      customization: IotAsyncClientBuilder => IotAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Iot] = managed(
    customization
  ).toLayer
  def managed(
      customization: IotAsyncClientBuilder => IotAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Iot] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = IotAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[IotAsyncClient, IotAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[IotAsyncClient, IotAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new IotImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class IotImpl[R](
      override val api: IotAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Iot
      with AwsServiceBase[R] {
    override val serviceName: String = "Iot"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): IotImpl[R1] = new IotImpl(api, newAspect, r)
    def deleteCustomMetric(
        request: DeleteCustomMetricRequest
    ): IO[AwsError, zio.aws.iot.model.DeleteCustomMetricResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DeleteCustomMetricRequest,
        DeleteCustomMetricResponse
      ]("deleteCustomMetric", api.deleteCustomMetric)(request.buildAwsValue())
        .map(zio.aws.iot.model.DeleteCustomMetricResponse.wrap)
        .provideEnvironment(r)
    def createProvisioningTemplateVersion(
        request: CreateProvisioningTemplateVersionRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.CreateProvisioningTemplateVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionRequest,
      CreateProvisioningTemplateVersionResponse
    ](
      "createProvisioningTemplateVersion",
      api.createProvisioningTemplateVersion
    )(request.buildAwsValue())
      .map(zio.aws.iot.model.CreateProvisioningTemplateVersionResponse.wrap)
      .provideEnvironment(r)
    def registerThing(
        request: RegisterThingRequest
    ): IO[AwsError, zio.aws.iot.model.RegisterThingResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.RegisterThingRequest,
        RegisterThingResponse
      ]("registerThing", api.registerThing)(request.buildAwsValue())
        .map(zio.aws.iot.model.RegisterThingResponse.wrap)
        .provideEnvironment(r)
    def listProvisioningTemplateVersions(
        request: ListProvisioningTemplateVersionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iot.model.ProvisioningTemplateVersionSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsRequest,
      ProvisioningTemplateVersionSummary,
      ListProvisioningTemplateVersionsPublisher
    ](
      "listProvisioningTemplateVersions",
      api.listProvisioningTemplateVersionsPaginator,
      _.versions()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.iot.model.ProvisioningTemplateVersionSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listProvisioningTemplateVersionsPaginated(
        request: ListProvisioningTemplateVersionsRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.ListProvisioningTemplateVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsRequest,
      ListProvisioningTemplateVersionsResponse
    ]("listProvisioningTemplateVersions", api.listProvisioningTemplateVersions)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.ListProvisioningTemplateVersionsResponse.wrap)
      .provideEnvironment(r)
    def updateAuditSuppression(
        request: UpdateAuditSuppressionRequest
    ): IO[AwsError, zio.aws.iot.model.UpdateAuditSuppressionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.UpdateAuditSuppressionRequest,
        UpdateAuditSuppressionResponse
      ]("updateAuditSuppression", api.updateAuditSuppression)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.UpdateAuditSuppressionResponse.wrap)
        .provideEnvironment(r)
    def listTargetsForSecurityProfile(
        request: ListTargetsForSecurityProfileRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iot.model.SecurityProfileTarget.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileRequest,
      SecurityProfileTarget,
      ListTargetsForSecurityProfilePublisher
    ](
      "listTargetsForSecurityProfile",
      api.listTargetsForSecurityProfilePaginator,
      _.securityProfileTargets()
    )(request.buildAwsValue())
      .map(item => zio.aws.iot.model.SecurityProfileTarget.wrap(item))
      .provideEnvironment(r)
    def listTargetsForSecurityProfilePaginated(
        request: ListTargetsForSecurityProfileRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.ListTargetsForSecurityProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileRequest,
      ListTargetsForSecurityProfileResponse
    ]("listTargetsForSecurityProfile", api.listTargetsForSecurityProfile)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.ListTargetsForSecurityProfileResponse.wrap)
      .provideEnvironment(r)
    def createDynamicThingGroup(request: CreateDynamicThingGroupRequest): IO[
      AwsError,
      zio.aws.iot.model.CreateDynamicThingGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupRequest,
      CreateDynamicThingGroupResponse
    ]("createDynamicThingGroup", api.createDynamicThingGroup)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.CreateDynamicThingGroupResponse.wrap)
      .provideEnvironment(r)
    def listStreams(
        request: ListStreamsRequest
    ): ZStream[Any, AwsError, zio.aws.iot.model.StreamSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iot.model.ListStreamsRequest,
        StreamSummary,
        ListStreamsPublisher
      ]("listStreams", api.listStreamsPaginator, _.streams())(
        request.buildAwsValue()
      ).map(item => zio.aws.iot.model.StreamSummary.wrap(item))
        .provideEnvironment(r)
    def listStreamsPaginated(
        request: ListStreamsRequest
    ): IO[AwsError, zio.aws.iot.model.ListStreamsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListStreamsRequest,
        ListStreamsResponse
      ]("listStreams", api.listStreams)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListStreamsResponse.wrap)
        .provideEnvironment(r)
    def createTopicRuleDestination(
        request: CreateTopicRuleDestinationRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.CreateTopicRuleDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationRequest,
      CreateTopicRuleDestinationResponse
    ]("createTopicRuleDestination", api.createTopicRuleDestination)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.CreateTopicRuleDestinationResponse.wrap)
      .provideEnvironment(r)
    def createScheduledAudit(
        request: CreateScheduledAuditRequest
    ): IO[AwsError, zio.aws.iot.model.CreateScheduledAuditResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.CreateScheduledAuditRequest,
        CreateScheduledAuditResponse
      ]("createScheduledAudit", api.createScheduledAudit)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.CreateScheduledAuditResponse.wrap)
        .provideEnvironment(r)
    def describeJob(
        request: DescribeJobRequest
    ): IO[AwsError, zio.aws.iot.model.DescribeJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DescribeJobRequest,
        DescribeJobResponse
      ]("describeJob", api.describeJob)(request.buildAwsValue())
        .map(zio.aws.iot.model.DescribeJobResponse.wrap)
        .provideEnvironment(r)
    def createOTAUpdate(
        request: CreateOtaUpdateRequest
    ): IO[AwsError, zio.aws.iot.model.CreateOtaUpdateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.CreateOtaUpdateRequest,
        CreateOtaUpdateResponse
      ]("createOTAUpdate", api.createOTAUpdate)(request.buildAwsValue())
        .map(zio.aws.iot.model.CreateOtaUpdateResponse.wrap)
        .provideEnvironment(r)
    def deleteDomainConfiguration(
        request: DeleteDomainConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.DeleteDomainConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DeleteDomainConfigurationRequest,
      DeleteDomainConfigurationResponse
    ]("deleteDomainConfiguration", api.deleteDomainConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.DeleteDomainConfigurationResponse.wrap)
      .provideEnvironment(r)
    def setV2LoggingLevel(
        request: SetV2LoggingLevelRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.SetV2LoggingLevelRequest,
      SetV2LoggingLevelResponse
    ]("setV2LoggingLevel", api.setV2LoggingLevel)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def deleteJobExecution(
        request: DeleteJobExecutionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DeleteJobExecutionRequest,
      DeleteJobExecutionResponse
    ]("deleteJobExecution", api.deleteJobExecution)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def testInvokeAuthorizer(
        request: TestInvokeAuthorizerRequest
    ): IO[AwsError, zio.aws.iot.model.TestInvokeAuthorizerResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerRequest,
        TestInvokeAuthorizerResponse
      ]("testInvokeAuthorizer", api.testInvokeAuthorizer)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.TestInvokeAuthorizerResponse.wrap)
        .provideEnvironment(r)
    def updateCACertificate(
        request: UpdateCaCertificateRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.UpdateCaCertificateRequest,
      UpdateCaCertificateResponse
    ]("updateCACertificate", api.updateCACertificate)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteDimension(
        request: DeleteDimensionRequest
    ): IO[AwsError, zio.aws.iot.model.DeleteDimensionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DeleteDimensionRequest,
        DeleteDimensionResponse
      ]("deleteDimension", api.deleteDimension)(request.buildAwsValue())
        .map(zio.aws.iot.model.DeleteDimensionResponse.wrap)
        .provideEnvironment(r)
    def listIndices(
        request: ListIndicesRequest
    ): ZStream[Any, AwsError, IndexName] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListIndicesRequest,
      java.lang.String,
      ListIndicesPublisher
    ]("listIndices", api.listIndicesPaginator, _.indexNames())(
      request.buildAwsValue()
    ).map(item => zio.aws.iot.model.primitives.IndexName(item))
      .provideEnvironment(r)
    def listIndicesPaginated(
        request: ListIndicesRequest
    ): IO[AwsError, zio.aws.iot.model.ListIndicesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListIndicesRequest,
        ListIndicesResponse
      ]("listIndices", api.listIndices)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListIndicesResponse.wrap)
        .provideEnvironment(r)
    def removeThingFromThingGroup(
        request: RemoveThingFromThingGroupRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.RemoveThingFromThingGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.RemoveThingFromThingGroupRequest,
      RemoveThingFromThingGroupResponse
    ]("removeThingFromThingGroup", api.removeThingFromThingGroup)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.RemoveThingFromThingGroupResponse.wrap)
      .provideEnvironment(r)
    def describeAuthorizer(
        request: DescribeAuthorizerRequest
    ): IO[AwsError, zio.aws.iot.model.DescribeAuthorizerResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DescribeAuthorizerRequest,
        DescribeAuthorizerResponse
      ]("describeAuthorizer", api.describeAuthorizer)(request.buildAwsValue())
        .map(zio.aws.iot.model.DescribeAuthorizerResponse.wrap)
        .provideEnvironment(r)
    def updateIndexingConfiguration(
        request: UpdateIndexingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.UpdateIndexingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.UpdateIndexingConfigurationRequest,
      UpdateIndexingConfigurationResponse
    ]("updateIndexingConfiguration", api.updateIndexingConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.UpdateIndexingConfigurationResponse.wrap)
      .provideEnvironment(r)
    def cancelJobExecution(
        request: CancelJobExecutionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.CancelJobExecutionRequest,
      CancelJobExecutionResponse
    ]("cancelJobExecution", api.cancelJobExecution)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def detachThingPrincipal(
        request: DetachThingPrincipalRequest
    ): IO[AwsError, zio.aws.iot.model.DetachThingPrincipalResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DetachThingPrincipalRequest,
        DetachThingPrincipalResponse
      ]("detachThingPrincipal", api.detachThingPrincipal)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.DetachThingPrincipalResponse.wrap)
        .provideEnvironment(r)
    def deleteBillingGroup(
        request: DeleteBillingGroupRequest
    ): IO[AwsError, zio.aws.iot.model.DeleteBillingGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DeleteBillingGroupRequest,
        DeleteBillingGroupResponse
      ]("deleteBillingGroup", api.deleteBillingGroup)(request.buildAwsValue())
        .map(zio.aws.iot.model.DeleteBillingGroupResponse.wrap)
        .provideEnvironment(r)
    def createKeysAndCertificate(request: CreateKeysAndCertificateRequest): IO[
      AwsError,
      zio.aws.iot.model.CreateKeysAndCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateRequest,
      CreateKeysAndCertificateResponse
    ]("createKeysAndCertificate", api.createKeysAndCertificate)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.CreateKeysAndCertificateResponse.wrap)
      .provideEnvironment(r)
    def updateScheduledAudit(
        request: UpdateScheduledAuditRequest
    ): IO[AwsError, zio.aws.iot.model.UpdateScheduledAuditResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.UpdateScheduledAuditRequest,
        UpdateScheduledAuditResponse
      ]("updateScheduledAudit", api.updateScheduledAudit)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.UpdateScheduledAuditResponse.wrap)
        .provideEnvironment(r)
    def deleteThingGroup(
        request: DeleteThingGroupRequest
    ): IO[AwsError, zio.aws.iot.model.DeleteThingGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DeleteThingGroupRequest,
        DeleteThingGroupResponse
      ]("deleteThingGroup", api.deleteThingGroup)(request.buildAwsValue())
        .map(zio.aws.iot.model.DeleteThingGroupResponse.wrap)
        .provideEnvironment(r)
    def listJobTemplates(
        request: ListJobTemplatesRequest
    ): ZStream[Any, AwsError, zio.aws.iot.model.JobTemplateSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iot.model.ListJobTemplatesRequest,
        JobTemplateSummary,
        ListJobTemplatesPublisher
      ]("listJobTemplates", api.listJobTemplatesPaginator, _.jobTemplates())(
        request.buildAwsValue()
      ).map(item => zio.aws.iot.model.JobTemplateSummary.wrap(item))
        .provideEnvironment(r)
    def listJobTemplatesPaginated(
        request: ListJobTemplatesRequest
    ): IO[AwsError, zio.aws.iot.model.ListJobTemplatesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListJobTemplatesRequest,
        ListJobTemplatesResponse
      ]("listJobTemplates", api.listJobTemplates)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListJobTemplatesResponse.wrap)
        .provideEnvironment(r)
    def describeProvisioningTemplate(
        request: DescribeProvisioningTemplateRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.DescribeProvisioningTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateRequest,
      DescribeProvisioningTemplateResponse
    ]("describeProvisioningTemplate", api.describeProvisioningTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.DescribeProvisioningTemplateResponse.wrap)
      .provideEnvironment(r)
    def listSecurityProfilesForTarget(
        request: ListSecurityProfilesForTargetRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iot.model.SecurityProfileTargetMapping.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetRequest,
      SecurityProfileTargetMapping,
      ListSecurityProfilesForTargetPublisher
    ](
      "listSecurityProfilesForTarget",
      api.listSecurityProfilesForTargetPaginator,
      _.securityProfileTargetMappings()
    )(request.buildAwsValue())
      .map(item => zio.aws.iot.model.SecurityProfileTargetMapping.wrap(item))
      .provideEnvironment(r)
    def listSecurityProfilesForTargetPaginated(
        request: ListSecurityProfilesForTargetRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.ListSecurityProfilesForTargetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetRequest,
      ListSecurityProfilesForTargetResponse
    ]("listSecurityProfilesForTarget", api.listSecurityProfilesForTarget)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.ListSecurityProfilesForTargetResponse.wrap)
      .provideEnvironment(r)
    def cancelDetectMitigationActionsTask(
        request: CancelDetectMitigationActionsTaskRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.CancelDetectMitigationActionsTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.CancelDetectMitigationActionsTaskRequest,
      CancelDetectMitigationActionsTaskResponse
    ](
      "cancelDetectMitigationActionsTask",
      api.cancelDetectMitigationActionsTask
    )(request.buildAwsValue())
      .map(zio.aws.iot.model.CancelDetectMitigationActionsTaskResponse.wrap)
      .provideEnvironment(r)
    def getIndexingConfiguration(request: GetIndexingConfigurationRequest): IO[
      AwsError,
      zio.aws.iot.model.GetIndexingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.GetIndexingConfigurationRequest,
      GetIndexingConfigurationResponse
    ]("getIndexingConfiguration", api.getIndexingConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.GetIndexingConfigurationResponse.wrap)
      .provideEnvironment(r)
    def stopThingRegistrationTask(
        request: StopThingRegistrationTaskRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.StopThingRegistrationTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.StopThingRegistrationTaskRequest,
      StopThingRegistrationTaskResponse
    ]("stopThingRegistrationTask", api.stopThingRegistrationTask)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.StopThingRegistrationTaskResponse.wrap)
      .provideEnvironment(r)
    def createSecurityProfile(
        request: CreateSecurityProfileRequest
    ): IO[AwsError, zio.aws.iot.model.CreateSecurityProfileResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.CreateSecurityProfileRequest,
        CreateSecurityProfileResponse
      ]("createSecurityProfile", api.createSecurityProfile)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.CreateSecurityProfileResponse.wrap)
        .provideEnvironment(r)
    def updateDimension(
        request: UpdateDimensionRequest
    ): IO[AwsError, zio.aws.iot.model.UpdateDimensionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.UpdateDimensionRequest,
        UpdateDimensionResponse
      ]("updateDimension", api.updateDimension)(request.buildAwsValue())
        .map(zio.aws.iot.model.UpdateDimensionResponse.wrap)
        .provideEnvironment(r)
    def updateCustomMetric(
        request: UpdateCustomMetricRequest
    ): IO[AwsError, zio.aws.iot.model.UpdateCustomMetricResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.UpdateCustomMetricRequest,
        UpdateCustomMetricResponse
      ]("updateCustomMetric", api.updateCustomMetric)(request.buildAwsValue())
        .map(zio.aws.iot.model.UpdateCustomMetricResponse.wrap)
        .provideEnvironment(r)
    def describeThingRegistrationTask(
        request: DescribeThingRegistrationTaskRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.DescribeThingRegistrationTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskRequest,
      DescribeThingRegistrationTaskResponse
    ]("describeThingRegistrationTask", api.describeThingRegistrationTask)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.DescribeThingRegistrationTaskResponse.wrap)
      .provideEnvironment(r)
    def listCACertificates(
        request: ListCaCertificatesRequest
    ): ZStream[Any, AwsError, zio.aws.iot.model.CACertificate.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iot.model.ListCaCertificatesRequest,
        CACertificate,
        ListCACertificatesPublisher
      ](
        "listCACertificates",
        api.listCACertificatesPaginator,
        _.certificates()
      )(request.buildAwsValue())
        .map(item => zio.aws.iot.model.CACertificate.wrap(item))
        .provideEnvironment(r)
    def listCACertificatesPaginated(
        request: ListCaCertificatesRequest
    ): IO[AwsError, zio.aws.iot.model.ListCaCertificatesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListCaCertificatesRequest,
        ListCaCertificatesResponse
      ]("listCACertificates", api.listCACertificates)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListCaCertificatesResponse.wrap)
        .provideEnvironment(r)
    def deleteProvisioningTemplateVersion(
        request: DeleteProvisioningTemplateVersionRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.DeleteProvisioningTemplateVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateVersionRequest,
      DeleteProvisioningTemplateVersionResponse
    ](
      "deleteProvisioningTemplateVersion",
      api.deleteProvisioningTemplateVersion
    )(request.buildAwsValue())
      .map(zio.aws.iot.model.DeleteProvisioningTemplateVersionResponse.wrap)
      .provideEnvironment(r)
    def getCardinality(
        request: GetCardinalityRequest
    ): IO[AwsError, zio.aws.iot.model.GetCardinalityResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.GetCardinalityRequest,
        GetCardinalityResponse
      ]("getCardinality", api.getCardinality)(request.buildAwsValue())
        .map(zio.aws.iot.model.GetCardinalityResponse.wrap)
        .provideEnvironment(r)
    def listDomainConfigurations(
        request: ListDomainConfigurationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iot.model.DomainConfigurationSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest,
      DomainConfigurationSummary,
      ListDomainConfigurationsPublisher
    ](
      "listDomainConfigurations",
      api.listDomainConfigurationsPaginator,
      _.domainConfigurations()
    )(request.buildAwsValue())
      .map(item => zio.aws.iot.model.DomainConfigurationSummary.wrap(item))
      .provideEnvironment(r)
    def listDomainConfigurationsPaginated(
        request: ListDomainConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.ListDomainConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest,
      ListDomainConfigurationsResponse
    ]("listDomainConfigurations", api.listDomainConfigurations)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.ListDomainConfigurationsResponse.wrap)
      .provideEnvironment(r)
    def describeAccountAuditConfiguration(
        request: DescribeAccountAuditConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.DescribeAccountAuditConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DescribeAccountAuditConfigurationRequest,
      DescribeAccountAuditConfigurationResponse
    ](
      "describeAccountAuditConfiguration",
      api.describeAccountAuditConfiguration
    )(request.buildAwsValue())
      .map(zio.aws.iot.model.DescribeAccountAuditConfigurationResponse.wrap)
      .provideEnvironment(r)
    def putVerificationStateOnViolation(
        request: PutVerificationStateOnViolationRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.PutVerificationStateOnViolationRequest,
      PutVerificationStateOnViolationResponse
    ]("putVerificationStateOnViolation", api.putVerificationStateOnViolation)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.PutVerificationStateOnViolationResponse.wrap)
      .provideEnvironment(r)
    def listPrincipalThings(
        request: ListPrincipalThingsRequest
    ): ZStream[Any, AwsError, ThingName] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListPrincipalThingsRequest,
      java.lang.String,
      ListPrincipalThingsPublisher
    ]("listPrincipalThings", api.listPrincipalThingsPaginator, _.things())(
      request.buildAwsValue()
    ).map(item => zio.aws.iot.model.primitives.ThingName(item))
      .provideEnvironment(r)
    def listPrincipalThingsPaginated(
        request: ListPrincipalThingsRequest
    ): IO[AwsError, zio.aws.iot.model.ListPrincipalThingsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListPrincipalThingsRequest,
        ListPrincipalThingsResponse
      ]("listPrincipalThings", api.listPrincipalThings)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListPrincipalThingsResponse.wrap)
        .provideEnvironment(r)
    def getBehaviorModelTrainingSummaries(
        request: GetBehaviorModelTrainingSummariesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iot.model.BehaviorModelTrainingSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesRequest,
      BehaviorModelTrainingSummary,
      GetBehaviorModelTrainingSummariesPublisher
    ](
      "getBehaviorModelTrainingSummaries",
      api.getBehaviorModelTrainingSummariesPaginator,
      _.summaries()
    )(request.buildAwsValue())
      .map(item => zio.aws.iot.model.BehaviorModelTrainingSummary.wrap(item))
      .provideEnvironment(r)
    def getBehaviorModelTrainingSummariesPaginated(
        request: GetBehaviorModelTrainingSummariesRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.GetBehaviorModelTrainingSummariesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesRequest,
      GetBehaviorModelTrainingSummariesResponse
    ](
      "getBehaviorModelTrainingSummaries",
      api.getBehaviorModelTrainingSummaries
    )(request.buildAwsValue())
      .map(zio.aws.iot.model.GetBehaviorModelTrainingSummariesResponse.wrap)
      .provideEnvironment(r)
    def describeScheduledAudit(
        request: DescribeScheduledAuditRequest
    ): IO[AwsError, zio.aws.iot.model.DescribeScheduledAuditResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DescribeScheduledAuditRequest,
        DescribeScheduledAuditResponse
      ]("describeScheduledAudit", api.describeScheduledAudit)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.DescribeScheduledAuditResponse.wrap)
        .provideEnvironment(r)
    def updateThingGroupsForThing(
        request: UpdateThingGroupsForThingRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.UpdateThingGroupsForThingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.UpdateThingGroupsForThingRequest,
      UpdateThingGroupsForThingResponse
    ]("updateThingGroupsForThing", api.updateThingGroupsForThing)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.UpdateThingGroupsForThingResponse.wrap)
      .provideEnvironment(r)
    def updateThing(
        request: UpdateThingRequest
    ): IO[AwsError, zio.aws.iot.model.UpdateThingResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.UpdateThingRequest,
        UpdateThingResponse
      ]("updateThing", api.updateThing)(request.buildAwsValue())
        .map(zio.aws.iot.model.UpdateThingResponse.wrap)
        .provideEnvironment(r)
    def describeThing(
        request: DescribeThingRequest
    ): IO[AwsError, zio.aws.iot.model.DescribeThingResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DescribeThingRequest,
        DescribeThingResponse
      ]("describeThing", api.describeThing)(request.buildAwsValue())
        .map(zio.aws.iot.model.DescribeThingResponse.wrap)
        .provideEnvironment(r)
    def createProvisioningClaim(request: CreateProvisioningClaimRequest): IO[
      AwsError,
      zio.aws.iot.model.CreateProvisioningClaimResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.CreateProvisioningClaimRequest,
      CreateProvisioningClaimResponse
    ]("createProvisioningClaim", api.createProvisioningClaim)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.CreateProvisioningClaimResponse.wrap)
      .provideEnvironment(r)
    def getPercentiles(
        request: GetPercentilesRequest
    ): IO[AwsError, zio.aws.iot.model.GetPercentilesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.GetPercentilesRequest,
        GetPercentilesResponse
      ]("getPercentiles", api.getPercentiles)(request.buildAwsValue())
        .map(zio.aws.iot.model.GetPercentilesResponse.wrap)
        .provideEnvironment(r)
    def deleteMitigationAction(
        request: DeleteMitigationActionRequest
    ): IO[AwsError, zio.aws.iot.model.DeleteMitigationActionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DeleteMitigationActionRequest,
        DeleteMitigationActionResponse
      ]("deleteMitigationAction", api.deleteMitigationAction)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.DeleteMitigationActionResponse.wrap)
        .provideEnvironment(r)
    def describeJobExecution(
        request: DescribeJobExecutionRequest
    ): IO[AwsError, zio.aws.iot.model.DescribeJobExecutionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DescribeJobExecutionRequest,
        DescribeJobExecutionResponse
      ]("describeJobExecution", api.describeJobExecution)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.DescribeJobExecutionResponse.wrap)
        .provideEnvironment(r)
    def updateStream(
        request: UpdateStreamRequest
    ): IO[AwsError, zio.aws.iot.model.UpdateStreamResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.UpdateStreamRequest,
        UpdateStreamResponse
      ]("updateStream", api.updateStream)(request.buildAwsValue())
        .map(zio.aws.iot.model.UpdateStreamResponse.wrap)
        .provideEnvironment(r)
    def deleteAuditSuppression(
        request: DeleteAuditSuppressionRequest
    ): IO[AwsError, zio.aws.iot.model.DeleteAuditSuppressionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DeleteAuditSuppressionRequest,
        DeleteAuditSuppressionResponse
      ]("deleteAuditSuppression", api.deleteAuditSuppression)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.DeleteAuditSuppressionResponse.wrap)
        .provideEnvironment(r)
    def deleteJobTemplate(
        request: DeleteJobTemplateRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DeleteJobTemplateRequest,
      DeleteJobTemplateResponse
    ]("deleteJobTemplate", api.deleteJobTemplate)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def getJobDocument(
        request: GetJobDocumentRequest
    ): IO[AwsError, zio.aws.iot.model.GetJobDocumentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.GetJobDocumentRequest,
        GetJobDocumentResponse
      ]("getJobDocument", api.getJobDocument)(request.buildAwsValue())
        .map(zio.aws.iot.model.GetJobDocumentResponse.wrap)
        .provideEnvironment(r)
    def getRegistrationCode(
        request: GetRegistrationCodeRequest
    ): IO[AwsError, zio.aws.iot.model.GetRegistrationCodeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.GetRegistrationCodeRequest,
        GetRegistrationCodeResponse
      ]("getRegistrationCode", api.getRegistrationCode)(request.buildAwsValue())
        .map(zio.aws.iot.model.GetRegistrationCodeResponse.wrap)
        .provideEnvironment(r)
    def updateThingGroup(
        request: UpdateThingGroupRequest
    ): IO[AwsError, zio.aws.iot.model.UpdateThingGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.UpdateThingGroupRequest,
        UpdateThingGroupResponse
      ]("updateThingGroup", api.updateThingGroup)(request.buildAwsValue())
        .map(zio.aws.iot.model.UpdateThingGroupResponse.wrap)
        .provideEnvironment(r)
    def listJobExecutionsForJob(
        request: ListJobExecutionsForJobRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iot.model.JobExecutionSummaryForJob.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest,
      JobExecutionSummaryForJob,
      ListJobExecutionsForJobPublisher
    ](
      "listJobExecutionsForJob",
      api.listJobExecutionsForJobPaginator,
      _.executionSummaries()
    )(request.buildAwsValue())
      .map(item => zio.aws.iot.model.JobExecutionSummaryForJob.wrap(item))
      .provideEnvironment(r)
    def listJobExecutionsForJobPaginated(
        request: ListJobExecutionsForJobRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.ListJobExecutionsForJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest,
      ListJobExecutionsForJobResponse
    ]("listJobExecutionsForJob", api.listJobExecutionsForJob)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.ListJobExecutionsForJobResponse.wrap)
      .provideEnvironment(r)
    def listAuditSuppressions(
        request: ListAuditSuppressionsRequest
    ): ZStream[Any, AwsError, zio.aws.iot.model.AuditSuppression.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iot.model.ListAuditSuppressionsRequest,
        AuditSuppression,
        ListAuditSuppressionsPublisher
      ](
        "listAuditSuppressions",
        api.listAuditSuppressionsPaginator,
        _.suppressions()
      )(request.buildAwsValue())
        .map(item => zio.aws.iot.model.AuditSuppression.wrap(item))
        .provideEnvironment(r)
    def listAuditSuppressionsPaginated(
        request: ListAuditSuppressionsRequest
    ): IO[AwsError, zio.aws.iot.model.ListAuditSuppressionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListAuditSuppressionsRequest,
        ListAuditSuppressionsResponse
      ]("listAuditSuppressions", api.listAuditSuppressions)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.ListAuditSuppressionsResponse.wrap)
        .provideEnvironment(r)
    def describeManagedJobTemplate(
        request: DescribeManagedJobTemplateRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.DescribeManagedJobTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DescribeManagedJobTemplateRequest,
      DescribeManagedJobTemplateResponse
    ]("describeManagedJobTemplate", api.describeManagedJobTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.DescribeManagedJobTemplateResponse.wrap)
      .provideEnvironment(r)
    def createBillingGroup(
        request: CreateBillingGroupRequest
    ): IO[AwsError, zio.aws.iot.model.CreateBillingGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.CreateBillingGroupRequest,
        CreateBillingGroupResponse
      ]("createBillingGroup", api.createBillingGroup)(request.buildAwsValue())
        .map(zio.aws.iot.model.CreateBillingGroupResponse.wrap)
        .provideEnvironment(r)
    def listTargetsForPolicy(
        request: ListTargetsForPolicyRequest
    ): ZStream[Any, AwsError, PolicyTarget] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListTargetsForPolicyRequest,
      java.lang.String,
      ListTargetsForPolicyPublisher
    ]("listTargetsForPolicy", api.listTargetsForPolicyPaginator, _.targets())(
      request.buildAwsValue()
    ).map(item => zio.aws.iot.model.primitives.PolicyTarget(item))
      .provideEnvironment(r)
    def listTargetsForPolicyPaginated(
        request: ListTargetsForPolicyRequest
    ): IO[AwsError, zio.aws.iot.model.ListTargetsForPolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListTargetsForPolicyRequest,
        ListTargetsForPolicyResponse
      ]("listTargetsForPolicy", api.listTargetsForPolicy)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.ListTargetsForPolicyResponse.wrap)
        .provideEnvironment(r)
    def describeDomainConfiguration(
        request: DescribeDomainConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.DescribeDomainConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DescribeDomainConfigurationRequest,
      DescribeDomainConfigurationResponse
    ]("describeDomainConfiguration", api.describeDomainConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.DescribeDomainConfigurationResponse.wrap)
      .provideEnvironment(r)
    def describeCACertificate(
        request: DescribeCaCertificateRequest
    ): IO[AwsError, zio.aws.iot.model.DescribeCaCertificateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DescribeCaCertificateRequest,
        DescribeCaCertificateResponse
      ]("describeCACertificate", api.describeCACertificate)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.DescribeCaCertificateResponse.wrap)
        .provideEnvironment(r)
    def updateDomainConfiguration(
        request: UpdateDomainConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.UpdateDomainConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationRequest,
      UpdateDomainConfigurationResponse
    ]("updateDomainConfiguration", api.updateDomainConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.UpdateDomainConfigurationResponse.wrap)
      .provideEnvironment(r)
    def createJob(
        request: CreateJobRequest
    ): IO[AwsError, zio.aws.iot.model.CreateJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.CreateJobRequest,
        CreateJobResponse
      ]("createJob", api.createJob)(request.buildAwsValue())
        .map(zio.aws.iot.model.CreateJobResponse.wrap)
        .provideEnvironment(r)
    def setLoggingOptions(
        request: SetLoggingOptionsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.SetLoggingOptionsRequest,
      SetLoggingOptionsResponse
    ]("setLoggingOptions", api.setLoggingOptions)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def listAttachedPolicies(
        request: ListAttachedPoliciesRequest
    ): ZStream[Any, AwsError, zio.aws.iot.model.Policy.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iot.model.ListAttachedPoliciesRequest,
        Policy,
        ListAttachedPoliciesPublisher
      ](
        "listAttachedPolicies",
        api.listAttachedPoliciesPaginator,
        _.policies()
      )(request.buildAwsValue())
        .map(item => zio.aws.iot.model.Policy.wrap(item))
        .provideEnvironment(r)
    def listAttachedPoliciesPaginated(
        request: ListAttachedPoliciesRequest
    ): IO[AwsError, zio.aws.iot.model.ListAttachedPoliciesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListAttachedPoliciesRequest,
        ListAttachedPoliciesResponse
      ]("listAttachedPolicies", api.listAttachedPolicies)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.ListAttachedPoliciesResponse.wrap)
        .provideEnvironment(r)
    def detachPolicy(request: DetachPolicyRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DetachPolicyRequest,
        DetachPolicyResponse
      ]("detachPolicy", api.detachPolicy)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def describeIndex(
        request: DescribeIndexRequest
    ): IO[AwsError, zio.aws.iot.model.DescribeIndexResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DescribeIndexRequest,
        DescribeIndexResponse
      ]("describeIndex", api.describeIndex)(request.buildAwsValue())
        .map(zio.aws.iot.model.DescribeIndexResponse.wrap)
        .provideEnvironment(r)
    def cancelAuditMitigationActionsTask(
        request: CancelAuditMitigationActionsTaskRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.CancelAuditMitigationActionsTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.CancelAuditMitigationActionsTaskRequest,
      CancelAuditMitigationActionsTaskResponse
    ]("cancelAuditMitigationActionsTask", api.cancelAuditMitigationActionsTask)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.CancelAuditMitigationActionsTaskResponse.wrap)
      .provideEnvironment(r)
    def attachThingPrincipal(
        request: AttachThingPrincipalRequest
    ): IO[AwsError, zio.aws.iot.model.AttachThingPrincipalResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.AttachThingPrincipalRequest,
        AttachThingPrincipalResponse
      ]("attachThingPrincipal", api.attachThingPrincipal)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.AttachThingPrincipalResponse.wrap)
        .provideEnvironment(r)
    def describeMitigationAction(request: DescribeMitigationActionRequest): IO[
      AwsError,
      zio.aws.iot.model.DescribeMitigationActionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DescribeMitigationActionRequest,
      DescribeMitigationActionResponse
    ]("describeMitigationAction", api.describeMitigationAction)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.DescribeMitigationActionResponse.wrap)
      .provideEnvironment(r)
    def createProvisioningTemplate(
        request: CreateProvisioningTemplateRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.CreateProvisioningTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateRequest,
      CreateProvisioningTemplateResponse
    ]("createProvisioningTemplate", api.createProvisioningTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.CreateProvisioningTemplateResponse.wrap)
      .provideEnvironment(r)
    def listThingsInBillingGroup(
        request: ListThingsInBillingGroupRequest
    ): ZStream[Any, AwsError, ThingName] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListThingsInBillingGroupRequest,
      java.lang.String,
      ListThingsInBillingGroupPublisher
    ](
      "listThingsInBillingGroup",
      api.listThingsInBillingGroupPaginator,
      _.things()
    )(request.buildAwsValue())
      .map(item => zio.aws.iot.model.primitives.ThingName(item))
      .provideEnvironment(r)
    def listThingsInBillingGroupPaginated(
        request: ListThingsInBillingGroupRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.ListThingsInBillingGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.ListThingsInBillingGroupRequest,
      ListThingsInBillingGroupResponse
    ]("listThingsInBillingGroup", api.listThingsInBillingGroup)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.ListThingsInBillingGroupResponse.wrap)
      .provideEnvironment(r)
    def cancelJob(
        request: CancelJobRequest
    ): IO[AwsError, zio.aws.iot.model.CancelJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.CancelJobRequest,
        CancelJobResponse
      ]("cancelJob", api.cancelJob)(request.buildAwsValue())
        .map(zio.aws.iot.model.CancelJobResponse.wrap)
        .provideEnvironment(r)
    def listViolationEvents(
        request: ListViolationEventsRequest
    ): ZStream[Any, AwsError, zio.aws.iot.model.ViolationEvent.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iot.model.ListViolationEventsRequest,
        ViolationEvent,
        ListViolationEventsPublisher
      ](
        "listViolationEvents",
        api.listViolationEventsPaginator,
        _.violationEvents()
      )(request.buildAwsValue())
        .map(item => zio.aws.iot.model.ViolationEvent.wrap(item))
        .provideEnvironment(r)
    def listViolationEventsPaginated(
        request: ListViolationEventsRequest
    ): IO[AwsError, zio.aws.iot.model.ListViolationEventsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListViolationEventsRequest,
        ListViolationEventsResponse
      ]("listViolationEvents", api.listViolationEvents)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListViolationEventsResponse.wrap)
        .provideEnvironment(r)
    def describeThingGroup(
        request: DescribeThingGroupRequest
    ): IO[AwsError, zio.aws.iot.model.DescribeThingGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DescribeThingGroupRequest,
        DescribeThingGroupResponse
      ]("describeThingGroup", api.describeThingGroup)(request.buildAwsValue())
        .map(zio.aws.iot.model.DescribeThingGroupResponse.wrap)
        .provideEnvironment(r)
    def listTopicRules(
        request: ListTopicRulesRequest
    ): ZStream[Any, AwsError, zio.aws.iot.model.TopicRuleListItem.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iot.model.ListTopicRulesRequest,
        TopicRuleListItem,
        ListTopicRulesPublisher
      ]("listTopicRules", api.listTopicRulesPaginator, _.rules())(
        request.buildAwsValue()
      ).map(item => zio.aws.iot.model.TopicRuleListItem.wrap(item))
        .provideEnvironment(r)
    def listTopicRulesPaginated(
        request: ListTopicRulesRequest
    ): IO[AwsError, zio.aws.iot.model.ListTopicRulesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListTopicRulesRequest,
        ListTopicRulesResponse
      ]("listTopicRules", api.listTopicRules)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListTopicRulesResponse.wrap)
        .provideEnvironment(r)
    def listPolicyVersions(
        request: ListPolicyVersionsRequest
    ): IO[AwsError, zio.aws.iot.model.ListPolicyVersionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListPolicyVersionsRequest,
        ListPolicyVersionsResponse
      ]("listPolicyVersions", api.listPolicyVersions)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListPolicyVersionsResponse.wrap)
        .provideEnvironment(r)
    def updateAuthorizer(
        request: UpdateAuthorizerRequest
    ): IO[AwsError, zio.aws.iot.model.UpdateAuthorizerResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.UpdateAuthorizerRequest,
        UpdateAuthorizerResponse
      ]("updateAuthorizer", api.updateAuthorizer)(request.buildAwsValue())
        .map(zio.aws.iot.model.UpdateAuthorizerResponse.wrap)
        .provideEnvironment(r)
    def createDomainConfiguration(
        request: CreateDomainConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.CreateDomainConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.CreateDomainConfigurationRequest,
      CreateDomainConfigurationResponse
    ]("createDomainConfiguration", api.createDomainConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.CreateDomainConfigurationResponse.wrap)
      .provideEnvironment(r)
    def getOTAUpdate(
        request: GetOtaUpdateRequest
    ): IO[AwsError, zio.aws.iot.model.GetOtaUpdateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.GetOtaUpdateRequest,
        GetOtaUpdateResponse
      ]("getOTAUpdate", api.getOTAUpdate)(request.buildAwsValue())
        .map(zio.aws.iot.model.GetOtaUpdateResponse.wrap)
        .provideEnvironment(r)
    def registerCertificateWithoutCA(
        request: RegisterCertificateWithoutCaRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.RegisterCertificateWithoutCaResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.RegisterCertificateWithoutCaRequest,
      RegisterCertificateWithoutCaResponse
    ]("registerCertificateWithoutCA", api.registerCertificateWithoutCA)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.RegisterCertificateWithoutCaResponse.wrap)
      .provideEnvironment(r)
    def rejectCertificateTransfer(
        request: RejectCertificateTransferRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.RejectCertificateTransferRequest,
      RejectCertificateTransferResponse
    ]("rejectCertificateTransfer", api.rejectCertificateTransfer)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeAuditFinding(
        request: DescribeAuditFindingRequest
    ): IO[AwsError, zio.aws.iot.model.DescribeAuditFindingResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DescribeAuditFindingRequest,
        DescribeAuditFindingResponse
      ]("describeAuditFinding", api.describeAuditFinding)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.DescribeAuditFindingResponse.wrap)
        .provideEnvironment(r)
    def startOnDemandAuditTask(
        request: StartOnDemandAuditTaskRequest
    ): IO[AwsError, zio.aws.iot.model.StartOnDemandAuditTaskResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.StartOnDemandAuditTaskRequest,
        StartOnDemandAuditTaskResponse
      ]("startOnDemandAuditTask", api.startOnDemandAuditTask)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.StartOnDemandAuditTaskResponse.wrap)
        .provideEnvironment(r)
    def deleteSecurityProfile(
        request: DeleteSecurityProfileRequest
    ): IO[AwsError, zio.aws.iot.model.DeleteSecurityProfileResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DeleteSecurityProfileRequest,
        DeleteSecurityProfileResponse
      ]("deleteSecurityProfile", api.deleteSecurityProfile)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.DeleteSecurityProfileResponse.wrap)
        .provideEnvironment(r)
    def listAuditMitigationActionsExecutions(
        request: ListAuditMitigationActionsExecutionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iot.model.AuditMitigationActionExecutionMetadata.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest,
      AuditMitigationActionExecutionMetadata,
      ListAuditMitigationActionsExecutionsPublisher
    ](
      "listAuditMitigationActionsExecutions",
      api.listAuditMitigationActionsExecutionsPaginator,
      _.actionsExecutions()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.iot.model.AuditMitigationActionExecutionMetadata.wrap(item)
      )
      .provideEnvironment(r)
    def listAuditMitigationActionsExecutionsPaginated(
        request: ListAuditMitigationActionsExecutionsRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.ListAuditMitigationActionsExecutionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest,
      ListAuditMitigationActionsExecutionsResponse
    ](
      "listAuditMitigationActionsExecutions",
      api.listAuditMitigationActionsExecutions
    )(request.buildAwsValue())
      .map(zio.aws.iot.model.ListAuditMitigationActionsExecutionsResponse.wrap)
      .provideEnvironment(r)
    def getTopicRuleDestination(request: GetTopicRuleDestinationRequest): IO[
      AwsError,
      zio.aws.iot.model.GetTopicRuleDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.GetTopicRuleDestinationRequest,
      GetTopicRuleDestinationResponse
    ]("getTopicRuleDestination", api.getTopicRuleDestination)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.GetTopicRuleDestinationResponse.wrap)
      .provideEnvironment(r)
    def listThingGroups(
        request: ListThingGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.iot.model.GroupNameAndArn.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iot.model.ListThingGroupsRequest,
        GroupNameAndArn,
        ListThingGroupsPublisher
      ]("listThingGroups", api.listThingGroupsPaginator, _.thingGroups())(
        request.buildAwsValue()
      ).map(item => zio.aws.iot.model.GroupNameAndArn.wrap(item))
        .provideEnvironment(r)
    def listThingGroupsPaginated(
        request: ListThingGroupsRequest
    ): IO[AwsError, zio.aws.iot.model.ListThingGroupsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListThingGroupsRequest,
        ListThingGroupsResponse
      ]("listThingGroups", api.listThingGroups)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListThingGroupsResponse.wrap)
        .provideEnvironment(r)
    def deleteCertificate(
        request: DeleteCertificateRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DeleteCertificateRequest,
      DeleteCertificateResponse
    ]("deleteCertificate", api.deleteCertificate)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def describeJobTemplate(
        request: DescribeJobTemplateRequest
    ): IO[AwsError, zio.aws.iot.model.DescribeJobTemplateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DescribeJobTemplateRequest,
        DescribeJobTemplateResponse
      ]("describeJobTemplate", api.describeJobTemplate)(request.buildAwsValue())
        .map(zio.aws.iot.model.DescribeJobTemplateResponse.wrap)
        .provideEnvironment(r)
    def deleteFleetMetric(
        request: DeleteFleetMetricRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DeleteFleetMetricRequest,
      DeleteFleetMetricResponse
    ]("deleteFleetMetric", api.deleteFleetMetric)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def setDefaultPolicyVersion(
        request: SetDefaultPolicyVersionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.SetDefaultPolicyVersionRequest,
      SetDefaultPolicyVersionResponse
    ]("setDefaultPolicyVersion", api.setDefaultPolicyVersion)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteCACertificate(
        request: DeleteCaCertificateRequest
    ): IO[AwsError, zio.aws.iot.model.DeleteCaCertificateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DeleteCaCertificateRequest,
        DeleteCaCertificateResponse
      ]("deleteCACertificate", api.deleteCACertificate)(request.buildAwsValue())
        .map(zio.aws.iot.model.DeleteCaCertificateResponse.wrap)
        .provideEnvironment(r)
    def deleteV2LoggingLevel(
        request: DeleteV2LoggingLevelRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DeleteV2LoggingLevelRequest,
      DeleteV2LoggingLevelResponse
    ]("deleteV2LoggingLevel", api.deleteV2LoggingLevel)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listAuditFindings(
        request: ListAuditFindingsRequest
    ): ZStream[Any, AwsError, zio.aws.iot.model.AuditFinding.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iot.model.ListAuditFindingsRequest,
        AuditFinding,
        ListAuditFindingsPublisher
      ]("listAuditFindings", api.listAuditFindingsPaginator, _.findings())(
        request.buildAwsValue()
      ).map(item => zio.aws.iot.model.AuditFinding.wrap(item))
        .provideEnvironment(r)
    def listAuditFindingsPaginated(
        request: ListAuditFindingsRequest
    ): IO[AwsError, zio.aws.iot.model.ListAuditFindingsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListAuditFindingsRequest,
        ListAuditFindingsResponse
      ]("listAuditFindings", api.listAuditFindings)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListAuditFindingsResponse.wrap)
        .provideEnvironment(r)
    def validateSecurityProfileBehaviors(
        request: ValidateSecurityProfileBehaviorsRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.ValidateSecurityProfileBehaviorsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.ValidateSecurityProfileBehaviorsRequest,
      ValidateSecurityProfileBehaviorsResponse
    ]("validateSecurityProfileBehaviors", api.validateSecurityProfileBehaviors)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.ValidateSecurityProfileBehaviorsResponse.wrap)
      .provideEnvironment(r)
    def listRoleAliases(
        request: ListRoleAliasesRequest
    ): ZStream[Any, AwsError, RoleAlias] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListRoleAliasesRequest,
      java.lang.String,
      ListRoleAliasesPublisher
    ]("listRoleAliases", api.listRoleAliasesPaginator, _.roleAliases())(
      request.buildAwsValue()
    ).map(item => zio.aws.iot.model.primitives.RoleAlias(item))
      .provideEnvironment(r)
    def listRoleAliasesPaginated(
        request: ListRoleAliasesRequest
    ): IO[AwsError, zio.aws.iot.model.ListRoleAliasesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListRoleAliasesRequest,
        ListRoleAliasesResponse
      ]("listRoleAliases", api.listRoleAliases)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListRoleAliasesResponse.wrap)
        .provideEnvironment(r)
    def listCertificatesByCA(
        request: ListCertificatesByCaRequest
    ): ZStream[Any, AwsError, zio.aws.iot.model.Certificate.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iot.model.ListCertificatesByCaRequest,
        Certificate,
        ListCertificatesByCAPublisher
      ](
        "listCertificatesByCA",
        api.listCertificatesByCAPaginator,
        _.certificates()
      )(request.buildAwsValue())
        .map(item => zio.aws.iot.model.Certificate.wrap(item))
        .provideEnvironment(r)
    def listCertificatesByCAPaginated(
        request: ListCertificatesByCaRequest
    ): IO[AwsError, zio.aws.iot.model.ListCertificatesByCaResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListCertificatesByCaRequest,
        ListCertificatesByCaResponse
      ]("listCertificatesByCA", api.listCertificatesByCA)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.ListCertificatesByCaResponse.wrap)
        .provideEnvironment(r)
    def updateAccountAuditConfiguration(
        request: UpdateAccountAuditConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.UpdateAccountAuditConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.UpdateAccountAuditConfigurationRequest,
      UpdateAccountAuditConfigurationResponse
    ]("updateAccountAuditConfiguration", api.updateAccountAuditConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.UpdateAccountAuditConfigurationResponse.wrap)
      .provideEnvironment(r)
    def describeSecurityProfile(request: DescribeSecurityProfileRequest): IO[
      AwsError,
      zio.aws.iot.model.DescribeSecurityProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DescribeSecurityProfileRequest,
      DescribeSecurityProfileResponse
    ]("describeSecurityProfile", api.describeSecurityProfile)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.DescribeSecurityProfileResponse.wrap)
      .provideEnvironment(r)
    def listAuthorizers(
        request: ListAuthorizersRequest
    ): ZStream[Any, AwsError, zio.aws.iot.model.AuthorizerSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iot.model.ListAuthorizersRequest,
        AuthorizerSummary,
        ListAuthorizersPublisher
      ]("listAuthorizers", api.listAuthorizersPaginator, _.authorizers())(
        request.buildAwsValue()
      ).map(item => zio.aws.iot.model.AuthorizerSummary.wrap(item))
        .provideEnvironment(r)
    def listAuthorizersPaginated(
        request: ListAuthorizersRequest
    ): IO[AwsError, zio.aws.iot.model.ListAuthorizersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListAuthorizersRequest,
        ListAuthorizersResponse
      ]("listAuthorizers", api.listAuthorizers)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListAuthorizersResponse.wrap)
        .provideEnvironment(r)
    def deleteStream(
        request: DeleteStreamRequest
    ): IO[AwsError, zio.aws.iot.model.DeleteStreamResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DeleteStreamRequest,
        DeleteStreamResponse
      ]("deleteStream", api.deleteStream)(request.buildAwsValue())
        .map(zio.aws.iot.model.DeleteStreamResponse.wrap)
        .provideEnvironment(r)
    def deleteOTAUpdate(
        request: DeleteOtaUpdateRequest
    ): IO[AwsError, zio.aws.iot.model.DeleteOtaUpdateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DeleteOtaUpdateRequest,
        DeleteOtaUpdateResponse
      ]("deleteOTAUpdate", api.deleteOTAUpdate)(request.buildAwsValue())
        .map(zio.aws.iot.model.DeleteOtaUpdateResponse.wrap)
        .provideEnvironment(r)
    def updateMitigationAction(
        request: UpdateMitigationActionRequest
    ): IO[AwsError, zio.aws.iot.model.UpdateMitigationActionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.UpdateMitigationActionRequest,
        UpdateMitigationActionResponse
      ]("updateMitigationAction", api.updateMitigationAction)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.UpdateMitigationActionResponse.wrap)
        .provideEnvironment(r)
    def clearDefaultAuthorizer(
        request: ClearDefaultAuthorizerRequest
    ): IO[AwsError, zio.aws.iot.model.ClearDefaultAuthorizerResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ClearDefaultAuthorizerRequest,
        ClearDefaultAuthorizerResponse
      ]("clearDefaultAuthorizer", api.clearDefaultAuthorizer)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.ClearDefaultAuthorizerResponse.wrap)
        .provideEnvironment(r)
    def deleteScheduledAudit(
        request: DeleteScheduledAuditRequest
    ): IO[AwsError, zio.aws.iot.model.DeleteScheduledAuditResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DeleteScheduledAuditRequest,
        DeleteScheduledAuditResponse
      ]("deleteScheduledAudit", api.deleteScheduledAudit)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.DeleteScheduledAuditResponse.wrap)
        .provideEnvironment(r)
    def listPolicies(
        request: ListPoliciesRequest
    ): ZStream[Any, AwsError, zio.aws.iot.model.Policy.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iot.model.ListPoliciesRequest,
        Policy,
        ListPoliciesPublisher
      ]("listPolicies", api.listPoliciesPaginator, _.policies())(
        request.buildAwsValue()
      ).map(item => zio.aws.iot.model.Policy.wrap(item)).provideEnvironment(r)
    def listPoliciesPaginated(
        request: ListPoliciesRequest
    ): IO[AwsError, zio.aws.iot.model.ListPoliciesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListPoliciesRequest,
        ListPoliciesResponse
      ]("listPolicies", api.listPolicies)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListPoliciesResponse.wrap)
        .provideEnvironment(r)
    def describeProvisioningTemplateVersion(
        request: DescribeProvisioningTemplateVersionRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.DescribeProvisioningTemplateVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionRequest,
      DescribeProvisioningTemplateVersionResponse
    ](
      "describeProvisioningTemplateVersion",
      api.describeProvisioningTemplateVersion
    )(request.buildAwsValue())
      .map(zio.aws.iot.model.DescribeProvisioningTemplateVersionResponse.wrap)
      .provideEnvironment(r)
    def listCustomMetrics(
        request: ListCustomMetricsRequest
    ): ZStream[Any, AwsError, MetricName] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListCustomMetricsRequest,
      java.lang.String,
      ListCustomMetricsPublisher
    ]("listCustomMetrics", api.listCustomMetricsPaginator, _.metricNames())(
      request.buildAwsValue()
    ).map(item => zio.aws.iot.model.primitives.MetricName(item))
      .provideEnvironment(r)
    def listCustomMetricsPaginated(
        request: ListCustomMetricsRequest
    ): IO[AwsError, zio.aws.iot.model.ListCustomMetricsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListCustomMetricsRequest,
        ListCustomMetricsResponse
      ]("listCustomMetrics", api.listCustomMetrics)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListCustomMetricsResponse.wrap)
        .provideEnvironment(r)
    def listOTAUpdates(
        request: ListOtaUpdatesRequest
    ): ZStream[Any, AwsError, zio.aws.iot.model.OTAUpdateSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iot.model.ListOtaUpdatesRequest,
        OTAUpdateSummary,
        ListOTAUpdatesPublisher
      ]("listOTAUpdates", api.listOTAUpdatesPaginator, _.otaUpdates())(
        request.buildAwsValue()
      ).map(item => zio.aws.iot.model.OTAUpdateSummary.wrap(item))
        .provideEnvironment(r)
    def listOTAUpdatesPaginated(
        request: ListOtaUpdatesRequest
    ): IO[AwsError, zio.aws.iot.model.ListOtaUpdatesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListOtaUpdatesRequest,
        ListOtaUpdatesResponse
      ]("listOTAUpdates", api.listOTAUpdates)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListOtaUpdatesResponse.wrap)
        .provideEnvironment(r)
    def replaceTopicRule(request: ReplaceTopicRuleRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ReplaceTopicRuleRequest,
        ReplaceTopicRuleResponse
      ]("replaceTopicRule", api.replaceTopicRule)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def getV2LoggingOptions(
        request: GetV2LoggingOptionsRequest
    ): IO[AwsError, zio.aws.iot.model.GetV2LoggingOptionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.GetV2LoggingOptionsRequest,
        GetV2LoggingOptionsResponse
      ]("getV2LoggingOptions", api.getV2LoggingOptions)(request.buildAwsValue())
        .map(zio.aws.iot.model.GetV2LoggingOptionsResponse.wrap)
        .provideEnvironment(r)
    def describeStream(
        request: DescribeStreamRequest
    ): IO[AwsError, zio.aws.iot.model.DescribeStreamResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DescribeStreamRequest,
        DescribeStreamResponse
      ]("describeStream", api.describeStream)(request.buildAwsValue())
        .map(zio.aws.iot.model.DescribeStreamResponse.wrap)
        .provideEnvironment(r)
    def listMitigationActions(request: ListMitigationActionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.iot.model.MitigationActionIdentifier.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListMitigationActionsRequest,
      MitigationActionIdentifier,
      ListMitigationActionsPublisher
    ](
      "listMitigationActions",
      api.listMitigationActionsPaginator,
      _.actionIdentifiers()
    )(request.buildAwsValue())
      .map(item => zio.aws.iot.model.MitigationActionIdentifier.wrap(item))
      .provideEnvironment(r)
    def listMitigationActionsPaginated(
        request: ListMitigationActionsRequest
    ): IO[AwsError, zio.aws.iot.model.ListMitigationActionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListMitigationActionsRequest,
        ListMitigationActionsResponse
      ]("listMitigationActions", api.listMitigationActions)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.ListMitigationActionsResponse.wrap)
        .provideEnvironment(r)
    def cancelCertificateTransfer(
        request: CancelCertificateTransferRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.CancelCertificateTransferRequest,
      CancelCertificateTransferResponse
    ]("cancelCertificateTransfer", api.cancelCertificateTransfer)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createStream(
        request: CreateStreamRequest
    ): IO[AwsError, zio.aws.iot.model.CreateStreamResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.CreateStreamRequest,
        CreateStreamResponse
      ]("createStream", api.createStream)(request.buildAwsValue())
        .map(zio.aws.iot.model.CreateStreamResponse.wrap)
        .provideEnvironment(r)
    def acceptCertificateTransfer(
        request: AcceptCertificateTransferRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.AcceptCertificateTransferRequest,
      AcceptCertificateTransferResponse
    ]("acceptCertificateTransfer", api.acceptCertificateTransfer)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listDetectMitigationActionsExecutions(
        request: ListDetectMitigationActionsExecutionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iot.model.DetectMitigationActionExecution.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsRequest,
      DetectMitigationActionExecution,
      ListDetectMitigationActionsExecutionsPublisher
    ](
      "listDetectMitigationActionsExecutions",
      api.listDetectMitigationActionsExecutionsPaginator,
      _.actionsExecutions()
    )(request.buildAwsValue())
      .map(item => zio.aws.iot.model.DetectMitigationActionExecution.wrap(item))
      .provideEnvironment(r)
    def listDetectMitigationActionsExecutionsPaginated(
        request: ListDetectMitigationActionsExecutionsRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.ListDetectMitigationActionsExecutionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsRequest,
      ListDetectMitigationActionsExecutionsResponse
    ](
      "listDetectMitigationActionsExecutions",
      api.listDetectMitigationActionsExecutions
    )(request.buildAwsValue())
      .map(zio.aws.iot.model.ListDetectMitigationActionsExecutionsResponse.wrap)
      .provideEnvironment(r)
    def createTopicRule(request: CreateTopicRuleRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.CreateTopicRuleRequest,
        CreateTopicRuleResponse
      ]("createTopicRule", api.createTopicRule)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deletePolicyVersion(
        request: DeletePolicyVersionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DeletePolicyVersionRequest,
      DeletePolicyVersionResponse
    ]("deletePolicyVersion", api.deletePolicyVersion)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listTopicRuleDestinations(
        request: ListTopicRuleDestinationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iot.model.TopicRuleDestinationSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsRequest,
      TopicRuleDestinationSummary,
      ListTopicRuleDestinationsPublisher
    ](
      "listTopicRuleDestinations",
      api.listTopicRuleDestinationsPaginator,
      _.destinationSummaries()
    )(request.buildAwsValue())
      .map(item => zio.aws.iot.model.TopicRuleDestinationSummary.wrap(item))
      .provideEnvironment(r)
    def listTopicRuleDestinationsPaginated(
        request: ListTopicRuleDestinationsRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.ListTopicRuleDestinationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsRequest,
      ListTopicRuleDestinationsResponse
    ]("listTopicRuleDestinations", api.listTopicRuleDestinations)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.ListTopicRuleDestinationsResponse.wrap)
      .provideEnvironment(r)
    def searchIndex(
        request: SearchIndexRequest
    ): IO[AwsError, zio.aws.iot.model.SearchIndexResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.SearchIndexRequest,
        SearchIndexResponse
      ]("searchIndex", api.searchIndex)(request.buildAwsValue())
        .map(zio.aws.iot.model.SearchIndexResponse.wrap)
        .provideEnvironment(r)
    def attachSecurityProfile(
        request: AttachSecurityProfileRequest
    ): IO[AwsError, zio.aws.iot.model.AttachSecurityProfileResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.AttachSecurityProfileRequest,
        AttachSecurityProfileResponse
      ]("attachSecurityProfile", api.attachSecurityProfile)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.AttachSecurityProfileResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.iot.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.iot.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def updateCertificate(
        request: UpdateCertificateRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.UpdateCertificateRequest,
      UpdateCertificateResponse
    ]("updateCertificate", api.updateCertificate)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def createFleetMetric(
        request: CreateFleetMetricRequest
    ): IO[AwsError, zio.aws.iot.model.CreateFleetMetricResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.CreateFleetMetricRequest,
        CreateFleetMetricResponse
      ]("createFleetMetric", api.createFleetMetric)(request.buildAwsValue())
        .map(zio.aws.iot.model.CreateFleetMetricResponse.wrap)
        .provideEnvironment(r)
    def describeEndpoint(
        request: DescribeEndpointRequest
    ): IO[AwsError, zio.aws.iot.model.DescribeEndpointResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DescribeEndpointRequest,
        DescribeEndpointResponse
      ]("describeEndpoint", api.describeEndpoint)(request.buildAwsValue())
        .map(zio.aws.iot.model.DescribeEndpointResponse.wrap)
        .provideEnvironment(r)
    def updateProvisioningTemplate(
        request: UpdateProvisioningTemplateRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.UpdateProvisioningTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.UpdateProvisioningTemplateRequest,
      UpdateProvisioningTemplateResponse
    ]("updateProvisioningTemplate", api.updateProvisioningTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.UpdateProvisioningTemplateResponse.wrap)
      .provideEnvironment(r)
    def listSecurityProfiles(request: ListSecurityProfilesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.iot.model.SecurityProfileIdentifier.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListSecurityProfilesRequest,
      SecurityProfileIdentifier,
      ListSecurityProfilesPublisher
    ](
      "listSecurityProfiles",
      api.listSecurityProfilesPaginator,
      _.securityProfileIdentifiers()
    )(request.buildAwsValue())
      .map(item => zio.aws.iot.model.SecurityProfileIdentifier.wrap(item))
      .provideEnvironment(r)
    def listSecurityProfilesPaginated(
        request: ListSecurityProfilesRequest
    ): IO[AwsError, zio.aws.iot.model.ListSecurityProfilesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListSecurityProfilesRequest,
        ListSecurityProfilesResponse
      ]("listSecurityProfiles", api.listSecurityProfiles)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.ListSecurityProfilesResponse.wrap)
        .provideEnvironment(r)
    def deleteTopicRuleDestination(
        request: DeleteTopicRuleDestinationRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.DeleteTopicRuleDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DeleteTopicRuleDestinationRequest,
      DeleteTopicRuleDestinationResponse
    ]("deleteTopicRuleDestination", api.deleteTopicRuleDestination)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.DeleteTopicRuleDestinationResponse.wrap)
      .provideEnvironment(r)
    def createCertificateFromCsr(request: CreateCertificateFromCsrRequest): IO[
      AwsError,
      zio.aws.iot.model.CreateCertificateFromCsrResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrRequest,
      CreateCertificateFromCsrResponse
    ]("createCertificateFromCsr", api.createCertificateFromCsr)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.CreateCertificateFromCsrResponse.wrap)
      .provideEnvironment(r)
    def createRoleAlias(
        request: CreateRoleAliasRequest
    ): IO[AwsError, zio.aws.iot.model.CreateRoleAliasResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.CreateRoleAliasRequest,
        CreateRoleAliasResponse
      ]("createRoleAlias", api.createRoleAlias)(request.buildAwsValue())
        .map(zio.aws.iot.model.CreateRoleAliasResponse.wrap)
        .provideEnvironment(r)
    def registerCACertificate(
        request: RegisterCaCertificateRequest
    ): IO[AwsError, zio.aws.iot.model.RegisterCaCertificateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.RegisterCaCertificateRequest,
        RegisterCaCertificateResponse
      ]("registerCACertificate", api.registerCACertificate)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.RegisterCaCertificateResponse.wrap)
        .provideEnvironment(r)
    def setV2LoggingOptions(
        request: SetV2LoggingOptionsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.SetV2LoggingOptionsRequest,
      SetV2LoggingOptionsResponse
    ]("setV2LoggingOptions", api.setV2LoggingOptions)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getStatistics(
        request: GetStatisticsRequest
    ): IO[AwsError, zio.aws.iot.model.GetStatisticsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.GetStatisticsRequest,
        GetStatisticsResponse
      ]("getStatistics", api.getStatistics)(request.buildAwsValue())
        .map(zio.aws.iot.model.GetStatisticsResponse.wrap)
        .provideEnvironment(r)
    def listDimensions(
        request: ListDimensionsRequest
    ): ZStream[Any, AwsError, DimensionName] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListDimensionsRequest,
      java.lang.String,
      ListDimensionsPublisher
    ]("listDimensions", api.listDimensionsPaginator, _.dimensionNames())(
      request.buildAwsValue()
    ).map(item => zio.aws.iot.model.primitives.DimensionName(item))
      .provideEnvironment(r)
    def listDimensionsPaginated(
        request: ListDimensionsRequest
    ): IO[AwsError, zio.aws.iot.model.ListDimensionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListDimensionsRequest,
        ListDimensionsResponse
      ]("listDimensions", api.listDimensions)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListDimensionsResponse.wrap)
        .provideEnvironment(r)
    def createThingGroup(
        request: CreateThingGroupRequest
    ): IO[AwsError, zio.aws.iot.model.CreateThingGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.CreateThingGroupRequest,
        CreateThingGroupResponse
      ]("createThingGroup", api.createThingGroup)(request.buildAwsValue())
        .map(zio.aws.iot.model.CreateThingGroupResponse.wrap)
        .provideEnvironment(r)
    def listDetectMitigationActionsTasks(
        request: ListDetectMitigationActionsTasksRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iot.model.DetectMitigationActionsTaskSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsTasksRequest,
      DetectMitigationActionsTaskSummary,
      ListDetectMitigationActionsTasksPublisher
    ](
      "listDetectMitigationActionsTasks",
      api.listDetectMitigationActionsTasksPaginator,
      _.tasks()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.iot.model.DetectMitigationActionsTaskSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listDetectMitigationActionsTasksPaginated(
        request: ListDetectMitigationActionsTasksRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.ListDetectMitigationActionsTasksResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsTasksRequest,
      ListDetectMitigationActionsTasksResponse
    ]("listDetectMitigationActionsTasks", api.listDetectMitigationActionsTasks)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.ListDetectMitigationActionsTasksResponse.wrap)
      .provideEnvironment(r)
    def updateFleetMetric(
        request: UpdateFleetMetricRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.UpdateFleetMetricRequest,
      UpdateFleetMetricResponse
    ]("updateFleetMetric", api.updateFleetMetric)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def deleteTopicRule(request: DeleteTopicRuleRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DeleteTopicRuleRequest,
        DeleteTopicRuleResponse
      ]("deleteTopicRule", api.deleteTopicRule)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def createMitigationAction(
        request: CreateMitigationActionRequest
    ): IO[AwsError, zio.aws.iot.model.CreateMitigationActionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.CreateMitigationActionRequest,
        CreateMitigationActionResponse
      ]("createMitigationAction", api.createMitigationAction)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.CreateMitigationActionResponse.wrap)
        .provideEnvironment(r)
    def describeCustomMetric(
        request: DescribeCustomMetricRequest
    ): IO[AwsError, zio.aws.iot.model.DescribeCustomMetricResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DescribeCustomMetricRequest,
        DescribeCustomMetricResponse
      ]("describeCustomMetric", api.describeCustomMetric)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.DescribeCustomMetricResponse.wrap)
        .provideEnvironment(r)
    def describeDetectMitigationActionsTask(
        request: DescribeDetectMitigationActionsTaskRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.DescribeDetectMitigationActionsTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DescribeDetectMitigationActionsTaskRequest,
      DescribeDetectMitigationActionsTaskResponse
    ](
      "describeDetectMitigationActionsTask",
      api.describeDetectMitigationActionsTask
    )(request.buildAwsValue())
      .map(zio.aws.iot.model.DescribeDetectMitigationActionsTaskResponse.wrap)
      .provideEnvironment(r)
    def listBillingGroups(
        request: ListBillingGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.iot.model.GroupNameAndArn.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest,
        GroupNameAndArn,
        ListBillingGroupsPublisher
      ]("listBillingGroups", api.listBillingGroupsPaginator, _.billingGroups())(
        request.buildAwsValue()
      ).map(item => zio.aws.iot.model.GroupNameAndArn.wrap(item))
        .provideEnvironment(r)
    def listBillingGroupsPaginated(
        request: ListBillingGroupsRequest
    ): IO[AwsError, zio.aws.iot.model.ListBillingGroupsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest,
        ListBillingGroupsResponse
      ]("listBillingGroups", api.listBillingGroups)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListBillingGroupsResponse.wrap)
        .provideEnvironment(r)
    def updateJob(request: UpdateJobRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.UpdateJobRequest,
        UpdateJobResponse
      ]("updateJob", api.updateJob)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def createAuthorizer(
        request: CreateAuthorizerRequest
    ): IO[AwsError, zio.aws.iot.model.CreateAuthorizerResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.CreateAuthorizerRequest,
        CreateAuthorizerResponse
      ]("createAuthorizer", api.createAuthorizer)(request.buildAwsValue())
        .map(zio.aws.iot.model.CreateAuthorizerResponse.wrap)
        .provideEnvironment(r)
    def setDefaultAuthorizer(
        request: SetDefaultAuthorizerRequest
    ): IO[AwsError, zio.aws.iot.model.SetDefaultAuthorizerResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.SetDefaultAuthorizerRequest,
        SetDefaultAuthorizerResponse
      ]("setDefaultAuthorizer", api.setDefaultAuthorizer)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.SetDefaultAuthorizerResponse.wrap)
        .provideEnvironment(r)
    def deleteRoleAlias(
        request: DeleteRoleAliasRequest
    ): IO[AwsError, zio.aws.iot.model.DeleteRoleAliasResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DeleteRoleAliasRequest,
        DeleteRoleAliasResponse
      ]("deleteRoleAlias", api.deleteRoleAlias)(request.buildAwsValue())
        .map(zio.aws.iot.model.DeleteRoleAliasResponse.wrap)
        .provideEnvironment(r)
    def attachPolicy(request: AttachPolicyRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.AttachPolicyRequest,
        AttachPolicyResponse
      ]("attachPolicy", api.attachPolicy)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listThingRegistrationTasks(
        request: ListThingRegistrationTasksRequest
    ): ZStream[Any, AwsError, TaskId] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksRequest,
      java.lang.String,
      ListThingRegistrationTasksPublisher
    ](
      "listThingRegistrationTasks",
      api.listThingRegistrationTasksPaginator,
      _.taskIds()
    )(request.buildAwsValue())
      .map(item => zio.aws.iot.model.primitives.TaskId(item))
      .provideEnvironment(r)
    def listThingRegistrationTasksPaginated(
        request: ListThingRegistrationTasksRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.ListThingRegistrationTasksResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksRequest,
      ListThingRegistrationTasksResponse
    ]("listThingRegistrationTasks", api.listThingRegistrationTasks)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.ListThingRegistrationTasksResponse.wrap)
      .provideEnvironment(r)
    def describeAuditSuppression(request: DescribeAuditSuppressionRequest): IO[
      AwsError,
      zio.aws.iot.model.DescribeAuditSuppressionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DescribeAuditSuppressionRequest,
      DescribeAuditSuppressionResponse
    ]("describeAuditSuppression", api.describeAuditSuppression)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.DescribeAuditSuppressionResponse.wrap)
      .provideEnvironment(r)
    def listThingPrincipals(
        request: ListThingPrincipalsRequest
    ): ZStream[Any, AwsError, PrincipalArn] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListThingPrincipalsRequest,
      java.lang.String,
      ListThingPrincipalsPublisher
    ]("listThingPrincipals", api.listThingPrincipalsPaginator, _.principals())(
      request.buildAwsValue()
    ).map(item => zio.aws.iot.model.primitives.PrincipalArn(item))
      .provideEnvironment(r)
    def listThingPrincipalsPaginated(
        request: ListThingPrincipalsRequest
    ): IO[AwsError, zio.aws.iot.model.ListThingPrincipalsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListThingPrincipalsRequest,
        ListThingPrincipalsResponse
      ]("listThingPrincipals", api.listThingPrincipals)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListThingPrincipalsResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): ZStream[Any, AwsError, zio.aws.iot.model.Tag.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iot.model.ListTagsForResourceRequest,
        Tag,
        ListTagsForResourcePublisher
      ]("listTagsForResource", api.listTagsForResourcePaginator, _.tags())(
        request.buildAwsValue()
      ).map(item => zio.aws.iot.model.Tag.wrap(item)).provideEnvironment(r)
    def listTagsForResourcePaginated(
        request: ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.iot.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteThing(
        request: DeleteThingRequest
    ): IO[AwsError, zio.aws.iot.model.DeleteThingResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DeleteThingRequest,
        DeleteThingResponse
      ]("deleteThing", api.deleteThing)(request.buildAwsValue())
        .map(zio.aws.iot.model.DeleteThingResponse.wrap)
        .provideEnvironment(r)
    def listAuditMitigationActionsTasks(
        request: ListAuditMitigationActionsTasksRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iot.model.AuditMitigationActionsTaskMetadata.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksRequest,
      AuditMitigationActionsTaskMetadata,
      ListAuditMitigationActionsTasksPublisher
    ](
      "listAuditMitigationActionsTasks",
      api.listAuditMitigationActionsTasksPaginator,
      _.tasks()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.iot.model.AuditMitigationActionsTaskMetadata.wrap(item)
      )
      .provideEnvironment(r)
    def listAuditMitigationActionsTasksPaginated(
        request: ListAuditMitigationActionsTasksRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.ListAuditMitigationActionsTasksResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksRequest,
      ListAuditMitigationActionsTasksResponse
    ]("listAuditMitigationActionsTasks", api.listAuditMitigationActionsTasks)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.ListAuditMitigationActionsTasksResponse.wrap)
      .provideEnvironment(r)
    def listJobs(
        request: ListJobsRequest
    ): ZStream[Any, AwsError, zio.aws.iot.model.JobSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iot.model.ListJobsRequest,
        JobSummary,
        ListJobsPublisher
      ]("listJobs", api.listJobsPaginator, _.jobs())(request.buildAwsValue())
        .map(item => zio.aws.iot.model.JobSummary.wrap(item))
        .provideEnvironment(r)
    def listJobsPaginated(
        request: ListJobsRequest
    ): IO[AwsError, zio.aws.iot.model.ListJobsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListJobsRequest,
        ListJobsResponse
      ]("listJobs", api.listJobs)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListJobsResponse.wrap)
        .provideEnvironment(r)
    def createCustomMetric(
        request: CreateCustomMetricRequest
    ): IO[AwsError, zio.aws.iot.model.CreateCustomMetricResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.CreateCustomMetricRequest,
        CreateCustomMetricResponse
      ]("createCustomMetric", api.createCustomMetric)(request.buildAwsValue())
        .map(zio.aws.iot.model.CreateCustomMetricResponse.wrap)
        .provideEnvironment(r)
    def createPolicy(
        request: CreatePolicyRequest
    ): IO[AwsError, zio.aws.iot.model.CreatePolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.CreatePolicyRequest,
        CreatePolicyResponse
      ]("createPolicy", api.createPolicy)(request.buildAwsValue())
        .map(zio.aws.iot.model.CreatePolicyResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.iot.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.iot.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def enableTopicRule(request: EnableTopicRuleRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.EnableTopicRuleRequest,
        EnableTopicRuleResponse
      ]("enableTopicRule", api.enableTopicRule)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteThingType(
        request: DeleteThingTypeRequest
    ): IO[AwsError, zio.aws.iot.model.DeleteThingTypeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DeleteThingTypeRequest,
        DeleteThingTypeResponse
      ]("deleteThingType", api.deleteThingType)(request.buildAwsValue())
        .map(zio.aws.iot.model.DeleteThingTypeResponse.wrap)
        .provideEnvironment(r)
    def listManagedJobTemplates(request: ListManagedJobTemplatesRequest): IO[
      AwsError,
      zio.aws.iot.model.ListManagedJobTemplatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesRequest,
      ListManagedJobTemplatesResponse
    ]("listManagedJobTemplates", api.listManagedJobTemplates)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.ListManagedJobTemplatesResponse.wrap)
      .provideEnvironment(r)
    def listThingsInThingGroup(
        request: ListThingsInThingGroupRequest
    ): ZStream[Any, AwsError, ThingName] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListThingsInThingGroupRequest,
      java.lang.String,
      ListThingsInThingGroupPublisher
    ](
      "listThingsInThingGroup",
      api.listThingsInThingGroupPaginator,
      _.things()
    )(request.buildAwsValue())
      .map(item => zio.aws.iot.model.primitives.ThingName(item))
      .provideEnvironment(r)
    def listThingsInThingGroupPaginated(
        request: ListThingsInThingGroupRequest
    ): IO[AwsError, zio.aws.iot.model.ListThingsInThingGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListThingsInThingGroupRequest,
        ListThingsInThingGroupResponse
      ]("listThingsInThingGroup", api.listThingsInThingGroup)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.ListThingsInThingGroupResponse.wrap)
        .provideEnvironment(r)
    def getTopicRule(
        request: GetTopicRuleRequest
    ): IO[AwsError, zio.aws.iot.model.GetTopicRuleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.GetTopicRuleRequest,
        GetTopicRuleResponse
      ]("getTopicRule", api.getTopicRule)(request.buildAwsValue())
        .map(zio.aws.iot.model.GetTopicRuleResponse.wrap)
        .provideEnvironment(r)
    def listScheduledAudits(request: ListScheduledAuditsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.iot.model.ScheduledAuditMetadata.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListScheduledAuditsRequest,
      ScheduledAuditMetadata,
      ListScheduledAuditsPublisher
    ](
      "listScheduledAudits",
      api.listScheduledAuditsPaginator,
      _.scheduledAudits()
    )(request.buildAwsValue())
      .map(item => zio.aws.iot.model.ScheduledAuditMetadata.wrap(item))
      .provideEnvironment(r)
    def listScheduledAuditsPaginated(
        request: ListScheduledAuditsRequest
    ): IO[AwsError, zio.aws.iot.model.ListScheduledAuditsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListScheduledAuditsRequest,
        ListScheduledAuditsResponse
      ]("listScheduledAudits", api.listScheduledAudits)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListScheduledAuditsResponse.wrap)
        .provideEnvironment(r)
    def startThingRegistrationTask(
        request: StartThingRegistrationTaskRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.StartThingRegistrationTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.StartThingRegistrationTaskRequest,
      StartThingRegistrationTaskResponse
    ]("startThingRegistrationTask", api.startThingRegistrationTask)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.StartThingRegistrationTaskResponse.wrap)
      .provideEnvironment(r)
    def listV2LoggingLevels(request: ListV2LoggingLevelsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.iot.model.LogTargetConfiguration.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsRequest,
      LogTargetConfiguration,
      ListV2LoggingLevelsPublisher
    ](
      "listV2LoggingLevels",
      api.listV2LoggingLevelsPaginator,
      _.logTargetConfigurations()
    )(request.buildAwsValue())
      .map(item => zio.aws.iot.model.LogTargetConfiguration.wrap(item))
      .provideEnvironment(r)
    def listV2LoggingLevelsPaginated(
        request: ListV2LoggingLevelsRequest
    ): IO[AwsError, zio.aws.iot.model.ListV2LoggingLevelsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsRequest,
        ListV2LoggingLevelsResponse
      ]("listV2LoggingLevels", api.listV2LoggingLevels)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListV2LoggingLevelsResponse.wrap)
        .provideEnvironment(r)
    def deletePolicy(request: DeletePolicyRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DeletePolicyRequest,
        DeletePolicyResponse
      ]("deletePolicy", api.deletePolicy)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteAuthorizer(
        request: DeleteAuthorizerRequest
    ): IO[AwsError, zio.aws.iot.model.DeleteAuthorizerResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DeleteAuthorizerRequest,
        DeleteAuthorizerResponse
      ]("deleteAuthorizer", api.deleteAuthorizer)(request.buildAwsValue())
        .map(zio.aws.iot.model.DeleteAuthorizerResponse.wrap)
        .provideEnvironment(r)
    def getPolicy(
        request: GetPolicyRequest
    ): IO[AwsError, zio.aws.iot.model.GetPolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.GetPolicyRequest,
        GetPolicyResponse
      ]("getPolicy", api.getPolicy)(request.buildAwsValue())
        .map(zio.aws.iot.model.GetPolicyResponse.wrap)
        .provideEnvironment(r)
    def startAuditMitigationActionsTask(
        request: StartAuditMitigationActionsTaskRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.StartAuditMitigationActionsTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.StartAuditMitigationActionsTaskRequest,
      StartAuditMitigationActionsTaskResponse
    ]("startAuditMitigationActionsTask", api.startAuditMitigationActionsTask)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.StartAuditMitigationActionsTaskResponse.wrap)
      .provideEnvironment(r)
    def transferCertificate(
        request: TransferCertificateRequest
    ): IO[AwsError, zio.aws.iot.model.TransferCertificateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.TransferCertificateRequest,
        TransferCertificateResponse
      ]("transferCertificate", api.transferCertificate)(request.buildAwsValue())
        .map(zio.aws.iot.model.TransferCertificateResponse.wrap)
        .provideEnvironment(r)
    def addThingToThingGroup(
        request: AddThingToThingGroupRequest
    ): IO[AwsError, zio.aws.iot.model.AddThingToThingGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.AddThingToThingGroupRequest,
        AddThingToThingGroupResponse
      ]("addThingToThingGroup", api.addThingToThingGroup)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.AddThingToThingGroupResponse.wrap)
        .provideEnvironment(r)
    def startDetectMitigationActionsTask(
        request: StartDetectMitigationActionsTaskRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.StartDetectMitigationActionsTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.StartDetectMitigationActionsTaskRequest,
      StartDetectMitigationActionsTaskResponse
    ]("startDetectMitigationActionsTask", api.startDetectMitigationActionsTask)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.StartDetectMitigationActionsTaskResponse.wrap)
      .provideEnvironment(r)
    def associateTargetsWithJob(request: AssociateTargetsWithJobRequest): IO[
      AwsError,
      zio.aws.iot.model.AssociateTargetsWithJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.AssociateTargetsWithJobRequest,
      AssociateTargetsWithJobResponse
    ]("associateTargetsWithJob", api.associateTargetsWithJob)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.AssociateTargetsWithJobResponse.wrap)
      .provideEnvironment(r)
    def describeEventConfigurations(
        request: DescribeEventConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.DescribeEventConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DescribeEventConfigurationsRequest,
      DescribeEventConfigurationsResponse
    ]("describeEventConfigurations", api.describeEventConfigurations)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.DescribeEventConfigurationsResponse.wrap)
      .provideEnvironment(r)
    def describeThingType(
        request: DescribeThingTypeRequest
    ): IO[AwsError, zio.aws.iot.model.DescribeThingTypeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DescribeThingTypeRequest,
        DescribeThingTypeResponse
      ]("describeThingType", api.describeThingType)(request.buildAwsValue())
        .map(zio.aws.iot.model.DescribeThingTypeResponse.wrap)
        .provideEnvironment(r)
    def listJobExecutionsForThing(
        request: ListJobExecutionsForThingRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iot.model.JobExecutionSummaryForThing.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingRequest,
      JobExecutionSummaryForThing,
      ListJobExecutionsForThingPublisher
    ](
      "listJobExecutionsForThing",
      api.listJobExecutionsForThingPaginator,
      _.executionSummaries()
    )(request.buildAwsValue())
      .map(item => zio.aws.iot.model.JobExecutionSummaryForThing.wrap(item))
      .provideEnvironment(r)
    def listJobExecutionsForThingPaginated(
        request: ListJobExecutionsForThingRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.ListJobExecutionsForThingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingRequest,
      ListJobExecutionsForThingResponse
    ]("listJobExecutionsForThing", api.listJobExecutionsForThing)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.ListJobExecutionsForThingResponse.wrap)
      .provideEnvironment(r)
    def updateRoleAlias(
        request: UpdateRoleAliasRequest
    ): IO[AwsError, zio.aws.iot.model.UpdateRoleAliasResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.UpdateRoleAliasRequest,
        UpdateRoleAliasResponse
      ]("updateRoleAlias", api.updateRoleAlias)(request.buildAwsValue())
        .map(zio.aws.iot.model.UpdateRoleAliasResponse.wrap)
        .provideEnvironment(r)
    def listProvisioningTemplates(
        request: ListProvisioningTemplatesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iot.model.ProvisioningTemplateSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListProvisioningTemplatesRequest,
      ProvisioningTemplateSummary,
      ListProvisioningTemplatesPublisher
    ](
      "listProvisioningTemplates",
      api.listProvisioningTemplatesPaginator,
      _.templates()
    )(request.buildAwsValue())
      .map(item => zio.aws.iot.model.ProvisioningTemplateSummary.wrap(item))
      .provideEnvironment(r)
    def listProvisioningTemplatesPaginated(
        request: ListProvisioningTemplatesRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.ListProvisioningTemplatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.ListProvisioningTemplatesRequest,
      ListProvisioningTemplatesResponse
    ]("listProvisioningTemplates", api.listProvisioningTemplates)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.ListProvisioningTemplatesResponse.wrap)
      .provideEnvironment(r)
    def listThingTypes(
        request: ListThingTypesRequest
    ): ZStream[Any, AwsError, zio.aws.iot.model.ThingTypeDefinition.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iot.model.ListThingTypesRequest,
        ThingTypeDefinition,
        ListThingTypesPublisher
      ]("listThingTypes", api.listThingTypesPaginator, _.thingTypes())(
        request.buildAwsValue()
      ).map(item => zio.aws.iot.model.ThingTypeDefinition.wrap(item))
        .provideEnvironment(r)
    def listThingTypesPaginated(
        request: ListThingTypesRequest
    ): IO[AwsError, zio.aws.iot.model.ListThingTypesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListThingTypesRequest,
        ListThingTypesResponse
      ]("listThingTypes", api.listThingTypes)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListThingTypesResponse.wrap)
        .provideEnvironment(r)
    def disableTopicRule(request: DisableTopicRuleRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DisableTopicRuleRequest,
        DisableTopicRuleResponse
      ]("disableTopicRule", api.disableTopicRule)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def registerCertificate(
        request: RegisterCertificateRequest
    ): IO[AwsError, zio.aws.iot.model.RegisterCertificateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.RegisterCertificateRequest,
        RegisterCertificateResponse
      ]("registerCertificate", api.registerCertificate)(request.buildAwsValue())
        .map(zio.aws.iot.model.RegisterCertificateResponse.wrap)
        .provideEnvironment(r)
    def describeDimension(
        request: DescribeDimensionRequest
    ): IO[AwsError, zio.aws.iot.model.DescribeDimensionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DescribeDimensionRequest,
        DescribeDimensionResponse
      ]("describeDimension", api.describeDimension)(request.buildAwsValue())
        .map(zio.aws.iot.model.DescribeDimensionResponse.wrap)
        .provideEnvironment(r)
    def createPolicyVersion(
        request: CreatePolicyVersionRequest
    ): IO[AwsError, zio.aws.iot.model.CreatePolicyVersionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.CreatePolicyVersionRequest,
        CreatePolicyVersionResponse
      ]("createPolicyVersion", api.createPolicyVersion)(request.buildAwsValue())
        .map(zio.aws.iot.model.CreatePolicyVersionResponse.wrap)
        .provideEnvironment(r)
    def deleteRegistrationCode(
        request: DeleteRegistrationCodeRequest
    ): IO[AwsError, zio.aws.iot.model.DeleteRegistrationCodeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DeleteRegistrationCodeRequest,
        DeleteRegistrationCodeResponse
      ]("deleteRegistrationCode", api.deleteRegistrationCode)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.DeleteRegistrationCodeResponse.wrap)
        .provideEnvironment(r)
    def describeBillingGroup(
        request: DescribeBillingGroupRequest
    ): IO[AwsError, zio.aws.iot.model.DescribeBillingGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DescribeBillingGroupRequest,
        DescribeBillingGroupResponse
      ]("describeBillingGroup", api.describeBillingGroup)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.DescribeBillingGroupResponse.wrap)
        .provideEnvironment(r)
    def updateSecurityProfile(
        request: UpdateSecurityProfileRequest
    ): IO[AwsError, zio.aws.iot.model.UpdateSecurityProfileResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.UpdateSecurityProfileRequest,
        UpdateSecurityProfileResponse
      ]("updateSecurityProfile", api.updateSecurityProfile)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.UpdateSecurityProfileResponse.wrap)
        .provideEnvironment(r)
    def updateTopicRuleDestination(
        request: UpdateTopicRuleDestinationRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.UpdateTopicRuleDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.UpdateTopicRuleDestinationRequest,
      UpdateTopicRuleDestinationResponse
    ]("updateTopicRuleDestination", api.updateTopicRuleDestination)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.UpdateTopicRuleDestinationResponse.wrap)
      .provideEnvironment(r)
    def updateBillingGroup(
        request: UpdateBillingGroupRequest
    ): IO[AwsError, zio.aws.iot.model.UpdateBillingGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.UpdateBillingGroupRequest,
        UpdateBillingGroupResponse
      ]("updateBillingGroup", api.updateBillingGroup)(request.buildAwsValue())
        .map(zio.aws.iot.model.UpdateBillingGroupResponse.wrap)
        .provideEnvironment(r)
    def getEffectivePolicies(
        request: GetEffectivePoliciesRequest
    ): IO[AwsError, zio.aws.iot.model.GetEffectivePoliciesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.GetEffectivePoliciesRequest,
        GetEffectivePoliciesResponse
      ]("getEffectivePolicies", api.getEffectivePolicies)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.GetEffectivePoliciesResponse.wrap)
        .provideEnvironment(r)
    def listAuditTasks(
        request: ListAuditTasksRequest
    ): ZStream[Any, AwsError, zio.aws.iot.model.AuditTaskMetadata.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iot.model.ListAuditTasksRequest,
        AuditTaskMetadata,
        ListAuditTasksPublisher
      ]("listAuditTasks", api.listAuditTasksPaginator, _.tasks())(
        request.buildAwsValue()
      ).map(item => zio.aws.iot.model.AuditTaskMetadata.wrap(item))
        .provideEnvironment(r)
    def listAuditTasksPaginated(
        request: ListAuditTasksRequest
    ): IO[AwsError, zio.aws.iot.model.ListAuditTasksResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListAuditTasksRequest,
        ListAuditTasksResponse
      ]("listAuditTasks", api.listAuditTasks)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListAuditTasksResponse.wrap)
        .provideEnvironment(r)
    def describeCertificate(
        request: DescribeCertificateRequest
    ): IO[AwsError, zio.aws.iot.model.DescribeCertificateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DescribeCertificateRequest,
        DescribeCertificateResponse
      ]("describeCertificate", api.describeCertificate)(request.buildAwsValue())
        .map(zio.aws.iot.model.DescribeCertificateResponse.wrap)
        .provideEnvironment(r)
    def describeAuditMitigationActionsTask(
        request: DescribeAuditMitigationActionsTaskRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.DescribeAuditMitigationActionsTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskRequest,
      DescribeAuditMitigationActionsTaskResponse
    ](
      "describeAuditMitigationActionsTask",
      api.describeAuditMitigationActionsTask
    )(request.buildAwsValue())
      .map(zio.aws.iot.model.DescribeAuditMitigationActionsTaskResponse.wrap)
      .provideEnvironment(r)
    def createThingType(
        request: CreateThingTypeRequest
    ): IO[AwsError, zio.aws.iot.model.CreateThingTypeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.CreateThingTypeRequest,
        CreateThingTypeResponse
      ]("createThingType", api.createThingType)(request.buildAwsValue())
        .map(zio.aws.iot.model.CreateThingTypeResponse.wrap)
        .provideEnvironment(r)
    def createAuditSuppression(
        request: CreateAuditSuppressionRequest
    ): IO[AwsError, zio.aws.iot.model.CreateAuditSuppressionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.CreateAuditSuppressionRequest,
        CreateAuditSuppressionResponse
      ]("createAuditSuppression", api.createAuditSuppression)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.CreateAuditSuppressionResponse.wrap)
        .provideEnvironment(r)
    def getLoggingOptions(
        request: GetLoggingOptionsRequest
    ): IO[AwsError, zio.aws.iot.model.GetLoggingOptionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.GetLoggingOptionsRequest,
        GetLoggingOptionsResponse
      ]("getLoggingOptions", api.getLoggingOptions)(request.buildAwsValue())
        .map(zio.aws.iot.model.GetLoggingOptionsResponse.wrap)
        .provideEnvironment(r)
    def listThingGroupsForThing(
        request: ListThingGroupsForThingRequest
    ): ZStream[Any, AwsError, zio.aws.iot.model.GroupNameAndArn.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iot.model.ListThingGroupsForThingRequest,
        GroupNameAndArn,
        ListThingGroupsForThingPublisher
      ](
        "listThingGroupsForThing",
        api.listThingGroupsForThingPaginator,
        _.thingGroups()
      )(request.buildAwsValue())
        .map(item => zio.aws.iot.model.GroupNameAndArn.wrap(item))
        .provideEnvironment(r)
    def listThingGroupsForThingPaginated(
        request: ListThingGroupsForThingRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.ListThingGroupsForThingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.ListThingGroupsForThingRequest,
      ListThingGroupsForThingResponse
    ]("listThingGroupsForThing", api.listThingGroupsForThing)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.ListThingGroupsForThingResponse.wrap)
      .provideEnvironment(r)
    def getBucketsAggregation(
        request: GetBucketsAggregationRequest
    ): IO[AwsError, zio.aws.iot.model.GetBucketsAggregationResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.GetBucketsAggregationRequest,
        GetBucketsAggregationResponse
      ]("getBucketsAggregation", api.getBucketsAggregation)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.GetBucketsAggregationResponse.wrap)
        .provideEnvironment(r)
    def removeThingFromBillingGroup(
        request: RemoveThingFromBillingGroupRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.RemoveThingFromBillingGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.RemoveThingFromBillingGroupRequest,
      RemoveThingFromBillingGroupResponse
    ]("removeThingFromBillingGroup", api.removeThingFromBillingGroup)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.RemoveThingFromBillingGroupResponse.wrap)
      .provideEnvironment(r)
    def listCertificates(
        request: ListCertificatesRequest
    ): ZStream[Any, AwsError, zio.aws.iot.model.Certificate.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iot.model.ListCertificatesRequest,
        Certificate,
        ListCertificatesPublisher
      ]("listCertificates", api.listCertificatesPaginator, _.certificates())(
        request.buildAwsValue()
      ).map(item => zio.aws.iot.model.Certificate.wrap(item))
        .provideEnvironment(r)
    def listCertificatesPaginated(
        request: ListCertificatesRequest
    ): IO[AwsError, zio.aws.iot.model.ListCertificatesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListCertificatesRequest,
        ListCertificatesResponse
      ]("listCertificates", api.listCertificates)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListCertificatesResponse.wrap)
        .provideEnvironment(r)
    def getPolicyVersion(
        request: GetPolicyVersionRequest
    ): IO[AwsError, zio.aws.iot.model.GetPolicyVersionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.GetPolicyVersionRequest,
        GetPolicyVersionResponse
      ]("getPolicyVersion", api.getPolicyVersion)(request.buildAwsValue())
        .map(zio.aws.iot.model.GetPolicyVersionResponse.wrap)
        .provideEnvironment(r)
    def describeRoleAlias(
        request: DescribeRoleAliasRequest
    ): IO[AwsError, zio.aws.iot.model.DescribeRoleAliasResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DescribeRoleAliasRequest,
        DescribeRoleAliasResponse
      ]("describeRoleAlias", api.describeRoleAlias)(request.buildAwsValue())
        .map(zio.aws.iot.model.DescribeRoleAliasResponse.wrap)
        .provideEnvironment(r)
    def deleteProvisioningTemplate(
        request: DeleteProvisioningTemplateRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.DeleteProvisioningTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateRequest,
      DeleteProvisioningTemplateResponse
    ]("deleteProvisioningTemplate", api.deleteProvisioningTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.DeleteProvisioningTemplateResponse.wrap)
      .provideEnvironment(r)
    def updateDynamicThingGroup(request: UpdateDynamicThingGroupRequest): IO[
      AwsError,
      zio.aws.iot.model.UpdateDynamicThingGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.UpdateDynamicThingGroupRequest,
      UpdateDynamicThingGroupResponse
    ]("updateDynamicThingGroup", api.updateDynamicThingGroup)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.UpdateDynamicThingGroupResponse.wrap)
      .provideEnvironment(r)
    def createDimension(
        request: CreateDimensionRequest
    ): IO[AwsError, zio.aws.iot.model.CreateDimensionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.CreateDimensionRequest,
        CreateDimensionResponse
      ]("createDimension", api.createDimension)(request.buildAwsValue())
        .map(zio.aws.iot.model.CreateDimensionResponse.wrap)
        .provideEnvironment(r)
    def deprecateThingType(
        request: DeprecateThingTypeRequest
    ): IO[AwsError, zio.aws.iot.model.DeprecateThingTypeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DeprecateThingTypeRequest,
        DeprecateThingTypeResponse
      ]("deprecateThingType", api.deprecateThingType)(request.buildAwsValue())
        .map(zio.aws.iot.model.DeprecateThingTypeResponse.wrap)
        .provideEnvironment(r)
    def addThingToBillingGroup(
        request: AddThingToBillingGroupRequest
    ): IO[AwsError, zio.aws.iot.model.AddThingToBillingGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.AddThingToBillingGroupRequest,
        AddThingToBillingGroupResponse
      ]("addThingToBillingGroup", api.addThingToBillingGroup)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.AddThingToBillingGroupResponse.wrap)
        .provideEnvironment(r)
    def describeDefaultAuthorizer(
        request: DescribeDefaultAuthorizerRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.DescribeDefaultAuthorizerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DescribeDefaultAuthorizerRequest,
      DescribeDefaultAuthorizerResponse
    ]("describeDefaultAuthorizer", api.describeDefaultAuthorizer)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.DescribeDefaultAuthorizerResponse.wrap)
      .provideEnvironment(r)
    def testAuthorization(
        request: TestAuthorizationRequest
    ): IO[AwsError, zio.aws.iot.model.TestAuthorizationResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.TestAuthorizationRequest,
        TestAuthorizationResponse
      ]("testAuthorization", api.testAuthorization)(request.buildAwsValue())
        .map(zio.aws.iot.model.TestAuthorizationResponse.wrap)
        .provideEnvironment(r)
    def listOutgoingCertificates(request: ListOutgoingCertificatesRequest)
        : ZStream[
          Any,
          AwsError,
          zio.aws.iot.model.OutgoingCertificate.ReadOnly
        ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesRequest,
      OutgoingCertificate,
      ListOutgoingCertificatesPublisher
    ](
      "listOutgoingCertificates",
      api.listOutgoingCertificatesPaginator,
      _.outgoingCertificates()
    )(request.buildAwsValue())
      .map(item => zio.aws.iot.model.OutgoingCertificate.wrap(item))
      .provideEnvironment(r)
    def listOutgoingCertificatesPaginated(
        request: ListOutgoingCertificatesRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.ListOutgoingCertificatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesRequest,
      ListOutgoingCertificatesResponse
    ]("listOutgoingCertificates", api.listOutgoingCertificates)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.ListOutgoingCertificatesResponse.wrap)
      .provideEnvironment(r)
    def confirmTopicRuleDestination(
        request: ConfirmTopicRuleDestinationRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.ConfirmTopicRuleDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.ConfirmTopicRuleDestinationRequest,
      ConfirmTopicRuleDestinationResponse
    ]("confirmTopicRuleDestination", api.confirmTopicRuleDestination)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.ConfirmTopicRuleDestinationResponse.wrap)
      .provideEnvironment(r)
    def deleteAccountAuditConfiguration(
        request: DeleteAccountAuditConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.DeleteAccountAuditConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DeleteAccountAuditConfigurationRequest,
      DeleteAccountAuditConfigurationResponse
    ]("deleteAccountAuditConfiguration", api.deleteAccountAuditConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.DeleteAccountAuditConfigurationResponse.wrap)
      .provideEnvironment(r)
    def describeFleetMetric(
        request: DescribeFleetMetricRequest
    ): IO[AwsError, zio.aws.iot.model.DescribeFleetMetricResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DescribeFleetMetricRequest,
        DescribeFleetMetricResponse
      ]("describeFleetMetric", api.describeFleetMetric)(request.buildAwsValue())
        .map(zio.aws.iot.model.DescribeFleetMetricResponse.wrap)
        .provideEnvironment(r)
    def listThings(
        request: ListThingsRequest
    ): ZStream[Any, AwsError, zio.aws.iot.model.ThingAttribute.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iot.model.ListThingsRequest,
        ThingAttribute,
        ListThingsPublisher
      ]("listThings", api.listThingsPaginator, _.things())(
        request.buildAwsValue()
      ).map(item => zio.aws.iot.model.ThingAttribute.wrap(item))
        .provideEnvironment(r)
    def listThingsPaginated(
        request: ListThingsRequest
    ): IO[AwsError, zio.aws.iot.model.ListThingsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListThingsRequest,
        ListThingsResponse
      ]("listThings", api.listThings)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListThingsResponse.wrap)
        .provideEnvironment(r)
    def describeAuditTask(
        request: DescribeAuditTaskRequest
    ): IO[AwsError, zio.aws.iot.model.DescribeAuditTaskResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DescribeAuditTaskRequest,
        DescribeAuditTaskResponse
      ]("describeAuditTask", api.describeAuditTask)(request.buildAwsValue())
        .map(zio.aws.iot.model.DescribeAuditTaskResponse.wrap)
        .provideEnvironment(r)
    def updateEventConfigurations(
        request: UpdateEventConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.UpdateEventConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.UpdateEventConfigurationsRequest,
      UpdateEventConfigurationsResponse
    ]("updateEventConfigurations", api.updateEventConfigurations)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.UpdateEventConfigurationsResponse.wrap)
      .provideEnvironment(r)
    def deleteJob(request: DeleteJobRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DeleteJobRequest,
        DeleteJobResponse
      ]("deleteJob", api.deleteJob)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listThingRegistrationTaskReports(
        request: ListThingRegistrationTaskReportsRequest
    ): ZStream[Any, AwsError, S3FileUrl] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsRequest,
      java.lang.String,
      ListThingRegistrationTaskReportsPublisher
    ](
      "listThingRegistrationTaskReports",
      api.listThingRegistrationTaskReportsPaginator,
      _.resourceLinks()
    )(request.buildAwsValue())
      .map(item => zio.aws.iot.model.primitives.S3FileUrl(item))
      .provideEnvironment(r)
    def listThingRegistrationTaskReportsPaginated(
        request: ListThingRegistrationTaskReportsRequest
    ): IO[
      AwsError,
      zio.aws.iot.model.ListThingRegistrationTaskReportsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsRequest,
      ListThingRegistrationTaskReportsResponse
    ]("listThingRegistrationTaskReports", api.listThingRegistrationTaskReports)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.ListThingRegistrationTaskReportsResponse.wrap)
      .provideEnvironment(r)
    def createJobTemplate(
        request: CreateJobTemplateRequest
    ): IO[AwsError, zio.aws.iot.model.CreateJobTemplateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.CreateJobTemplateRequest,
        CreateJobTemplateResponse
      ]("createJobTemplate", api.createJobTemplate)(request.buildAwsValue())
        .map(zio.aws.iot.model.CreateJobTemplateResponse.wrap)
        .provideEnvironment(r)
    def listFleetMetrics(request: ListFleetMetricsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.iot.model.FleetMetricNameAndArn.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iot.model.ListFleetMetricsRequest,
      FleetMetricNameAndArn,
      ListFleetMetricsPublisher
    ]("listFleetMetrics", api.listFleetMetricsPaginator, _.fleetMetrics())(
      request.buildAwsValue()
    ).map(item => zio.aws.iot.model.FleetMetricNameAndArn.wrap(item))
      .provideEnvironment(r)
    def listFleetMetricsPaginated(
        request: ListFleetMetricsRequest
    ): IO[AwsError, zio.aws.iot.model.ListFleetMetricsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListFleetMetricsRequest,
        ListFleetMetricsResponse
      ]("listFleetMetrics", api.listFleetMetrics)(request.buildAwsValue())
        .map(zio.aws.iot.model.ListFleetMetricsResponse.wrap)
        .provideEnvironment(r)
    def listActiveViolations(
        request: ListActiveViolationsRequest
    ): ZStream[Any, AwsError, zio.aws.iot.model.ActiveViolation.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iot.model.ListActiveViolationsRequest,
        ActiveViolation,
        ListActiveViolationsPublisher
      ](
        "listActiveViolations",
        api.listActiveViolationsPaginator,
        _.activeViolations()
      )(request.buildAwsValue())
        .map(item => zio.aws.iot.model.ActiveViolation.wrap(item))
        .provideEnvironment(r)
    def listActiveViolationsPaginated(
        request: ListActiveViolationsRequest
    ): IO[AwsError, zio.aws.iot.model.ListActiveViolationsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.ListActiveViolationsRequest,
        ListActiveViolationsResponse
      ]("listActiveViolations", api.listActiveViolations)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.ListActiveViolationsResponse.wrap)
        .provideEnvironment(r)
    def cancelAuditTask(
        request: CancelAuditTaskRequest
    ): IO[AwsError, zio.aws.iot.model.CancelAuditTaskResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.CancelAuditTaskRequest,
        CancelAuditTaskResponse
      ]("cancelAuditTask", api.cancelAuditTask)(request.buildAwsValue())
        .map(zio.aws.iot.model.CancelAuditTaskResponse.wrap)
        .provideEnvironment(r)
    def deleteDynamicThingGroup(request: DeleteDynamicThingGroupRequest): IO[
      AwsError,
      zio.aws.iot.model.DeleteDynamicThingGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iot.model.DeleteDynamicThingGroupRequest,
      DeleteDynamicThingGroupResponse
    ]("deleteDynamicThingGroup", api.deleteDynamicThingGroup)(
      request.buildAwsValue()
    ).map(zio.aws.iot.model.DeleteDynamicThingGroupResponse.wrap)
      .provideEnvironment(r)
    def detachSecurityProfile(
        request: DetachSecurityProfileRequest
    ): IO[AwsError, zio.aws.iot.model.DetachSecurityProfileResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.DetachSecurityProfileRequest,
        DetachSecurityProfileResponse
      ]("detachSecurityProfile", api.detachSecurityProfile)(
        request.buildAwsValue()
      ).map(zio.aws.iot.model.DetachSecurityProfileResponse.wrap)
        .provideEnvironment(r)
    def createThing(
        request: CreateThingRequest
    ): IO[AwsError, zio.aws.iot.model.CreateThingResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iot.model.CreateThingRequest,
        CreateThingResponse
      ]("createThing", api.createThing)(request.buildAwsValue())
        .map(zio.aws.iot.model.CreateThingResponse.wrap)
        .provideEnvironment(r)
  }
  def deleteCustomMetric(request: DeleteCustomMetricRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DeleteCustomMetricResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCustomMetric(request))
  def createProvisioningTemplateVersion(
      request: CreateProvisioningTemplateVersionRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateProvisioningTemplateVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProvisioningTemplateVersion(request))
  def registerThing(request: RegisterThingRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.RegisterThingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerThing(request))
  def listProvisioningTemplateVersions(
      request: ListProvisioningTemplateVersionsRequest
  ): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ProvisioningTemplateVersionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listProvisioningTemplateVersions(request))
  def listProvisioningTemplateVersionsPaginated(
      request: ListProvisioningTemplateVersionsRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListProvisioningTemplateVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProvisioningTemplateVersionsPaginated(request))
  def updateAuditSuppression(request: UpdateAuditSuppressionRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.UpdateAuditSuppressionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAuditSuppression(request))
  def listTargetsForSecurityProfile(
      request: ListTargetsForSecurityProfileRequest
  ): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.SecurityProfileTarget.ReadOnly
  ] = ZStream.serviceWithStream(_.listTargetsForSecurityProfile(request))
  def listTargetsForSecurityProfilePaginated(
      request: ListTargetsForSecurityProfileRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListTargetsForSecurityProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTargetsForSecurityProfilePaginated(request))
  def createDynamicThingGroup(request: CreateDynamicThingGroupRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateDynamicThingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDynamicThingGroup(request))
  def listStreams(request: ListStreamsRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.StreamSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listStreams(request))
  def listStreamsPaginated(request: ListStreamsRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListStreamsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStreamsPaginated(request))
  def createTopicRuleDestination(
      request: CreateTopicRuleDestinationRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateTopicRuleDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTopicRuleDestination(request))
  def createScheduledAudit(request: CreateScheduledAuditRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateScheduledAuditResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createScheduledAudit(request))
  def describeJob(request: DescribeJobRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeJob(request))
  def createOTAUpdate(request: CreateOtaUpdateRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateOtaUpdateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createOTAUpdate(request))
  def deleteDomainConfiguration(request: DeleteDomainConfigurationRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DeleteDomainConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDomainConfiguration(request))
  def setV2LoggingLevel(
      request: SetV2LoggingLevelRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.setV2LoggingLevel(request))
  def deleteJobExecution(
      request: DeleteJobExecutionRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteJobExecution(request))
  def testInvokeAuthorizer(request: TestInvokeAuthorizerRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.TestInvokeAuthorizerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.testInvokeAuthorizer(request))
  def updateCACertificate(
      request: UpdateCaCertificateRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateCACertificate(request))
  def deleteDimension(request: DeleteDimensionRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DeleteDimensionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDimension(request))
  def listIndices(
      request: ListIndicesRequest
  ): ZStream[zio.aws.iot.Iot, AwsError, IndexName] =
    ZStream.serviceWithStream(_.listIndices(request))
  def listIndicesPaginated(request: ListIndicesRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListIndicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listIndicesPaginated(request))
  def removeThingFromThingGroup(request: RemoveThingFromThingGroupRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.RemoveThingFromThingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeThingFromThingGroup(request))
  def describeAuthorizer(request: DescribeAuthorizerRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeAuthorizerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAuthorizer(request))
  def updateIndexingConfiguration(
      request: UpdateIndexingConfigurationRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.UpdateIndexingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateIndexingConfiguration(request))
  def cancelJobExecution(
      request: CancelJobExecutionRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.cancelJobExecution(request))
  def detachThingPrincipal(request: DetachThingPrincipalRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DetachThingPrincipalResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detachThingPrincipal(request))
  def deleteBillingGroup(request: DeleteBillingGroupRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DeleteBillingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBillingGroup(request))
  def createKeysAndCertificate(request: CreateKeysAndCertificateRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateKeysAndCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createKeysAndCertificate(request))
  def updateScheduledAudit(request: UpdateScheduledAuditRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.UpdateScheduledAuditResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateScheduledAudit(request))
  def deleteThingGroup(request: DeleteThingGroupRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DeleteThingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteThingGroup(request))
  def listJobTemplates(request: ListJobTemplatesRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.JobTemplateSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listJobTemplates(request))
  def listJobTemplatesPaginated(request: ListJobTemplatesRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListJobTemplatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listJobTemplatesPaginated(request))
  def describeProvisioningTemplate(
      request: DescribeProvisioningTemplateRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeProvisioningTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProvisioningTemplate(request))
  def listSecurityProfilesForTarget(
      request: ListSecurityProfilesForTargetRequest
  ): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.SecurityProfileTargetMapping.ReadOnly
  ] = ZStream.serviceWithStream(_.listSecurityProfilesForTarget(request))
  def listSecurityProfilesForTargetPaginated(
      request: ListSecurityProfilesForTargetRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListSecurityProfilesForTargetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSecurityProfilesForTargetPaginated(request))
  def cancelDetectMitigationActionsTask(
      request: CancelDetectMitigationActionsTaskRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CancelDetectMitigationActionsTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelDetectMitigationActionsTask(request))
  def getIndexingConfiguration(request: GetIndexingConfigurationRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.GetIndexingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIndexingConfiguration(request))
  def stopThingRegistrationTask(request: StopThingRegistrationTaskRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.StopThingRegistrationTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopThingRegistrationTask(request))
  def createSecurityProfile(request: CreateSecurityProfileRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateSecurityProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSecurityProfile(request))
  def updateDimension(request: UpdateDimensionRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.UpdateDimensionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDimension(request))
  def updateCustomMetric(request: UpdateCustomMetricRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.UpdateCustomMetricResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCustomMetric(request))
  def describeThingRegistrationTask(
      request: DescribeThingRegistrationTaskRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeThingRegistrationTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeThingRegistrationTask(request))
  def listCACertificates(request: ListCaCertificatesRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CACertificate.ReadOnly
  ] = ZStream.serviceWithStream(_.listCACertificates(request))
  def listCACertificatesPaginated(request: ListCaCertificatesRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListCaCertificatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCACertificatesPaginated(request))
  def deleteProvisioningTemplateVersion(
      request: DeleteProvisioningTemplateVersionRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DeleteProvisioningTemplateVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProvisioningTemplateVersion(request))
  def getCardinality(request: GetCardinalityRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.GetCardinalityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCardinality(request))
  def listDomainConfigurations(
      request: ListDomainConfigurationsRequest
  ): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DomainConfigurationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDomainConfigurations(request))
  def listDomainConfigurationsPaginated(
      request: ListDomainConfigurationsRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListDomainConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDomainConfigurationsPaginated(request))
  def describeAccountAuditConfiguration(
      request: DescribeAccountAuditConfigurationRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeAccountAuditConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAccountAuditConfiguration(request))
  def putVerificationStateOnViolation(
      request: PutVerificationStateOnViolationRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.putVerificationStateOnViolation(request))
  def listPrincipalThings(
      request: ListPrincipalThingsRequest
  ): ZStream[zio.aws.iot.Iot, AwsError, ThingName] =
    ZStream.serviceWithStream(_.listPrincipalThings(request))
  def listPrincipalThingsPaginated(request: ListPrincipalThingsRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListPrincipalThingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPrincipalThingsPaginated(request))
  def getBehaviorModelTrainingSummaries(
      request: GetBehaviorModelTrainingSummariesRequest
  ): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.BehaviorModelTrainingSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.getBehaviorModelTrainingSummaries(request))
  def getBehaviorModelTrainingSummariesPaginated(
      request: GetBehaviorModelTrainingSummariesRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.GetBehaviorModelTrainingSummariesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBehaviorModelTrainingSummariesPaginated(request))
  def describeScheduledAudit(request: DescribeScheduledAuditRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeScheduledAuditResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeScheduledAudit(request))
  def updateThingGroupsForThing(request: UpdateThingGroupsForThingRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.UpdateThingGroupsForThingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateThingGroupsForThing(request))
  def updateThing(request: UpdateThingRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.UpdateThingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateThing(request))
  def describeThing(request: DescribeThingRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeThingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeThing(request))
  def createProvisioningClaim(request: CreateProvisioningClaimRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateProvisioningClaimResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProvisioningClaim(request))
  def getPercentiles(request: GetPercentilesRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.GetPercentilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPercentiles(request))
  def deleteMitigationAction(request: DeleteMitigationActionRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DeleteMitigationActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMitigationAction(request))
  def describeJobExecution(request: DescribeJobExecutionRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeJobExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeJobExecution(request))
  def updateStream(request: UpdateStreamRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.UpdateStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateStream(request))
  def deleteAuditSuppression(request: DeleteAuditSuppressionRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DeleteAuditSuppressionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAuditSuppression(request))
  def deleteJobTemplate(
      request: DeleteJobTemplateRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteJobTemplate(request))
  def getJobDocument(request: GetJobDocumentRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.GetJobDocumentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getJobDocument(request))
  def getRegistrationCode(request: GetRegistrationCodeRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.GetRegistrationCodeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRegistrationCode(request))
  def updateThingGroup(request: UpdateThingGroupRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.UpdateThingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateThingGroup(request))
  def listJobExecutionsForJob(request: ListJobExecutionsForJobRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.JobExecutionSummaryForJob.ReadOnly
  ] = ZStream.serviceWithStream(_.listJobExecutionsForJob(request))
  def listJobExecutionsForJobPaginated(
      request: ListJobExecutionsForJobRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListJobExecutionsForJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listJobExecutionsForJobPaginated(request))
  def listAuditSuppressions(request: ListAuditSuppressionsRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.AuditSuppression.ReadOnly
  ] = ZStream.serviceWithStream(_.listAuditSuppressions(request))
  def listAuditSuppressionsPaginated(
      request: ListAuditSuppressionsRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListAuditSuppressionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAuditSuppressionsPaginated(request))
  def describeManagedJobTemplate(
      request: DescribeManagedJobTemplateRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeManagedJobTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeManagedJobTemplate(request))
  def createBillingGroup(request: CreateBillingGroupRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateBillingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBillingGroup(request))
  def listTargetsForPolicy(
      request: ListTargetsForPolicyRequest
  ): ZStream[zio.aws.iot.Iot, AwsError, PolicyTarget] =
    ZStream.serviceWithStream(_.listTargetsForPolicy(request))
  def listTargetsForPolicyPaginated(request: ListTargetsForPolicyRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListTargetsForPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTargetsForPolicyPaginated(request))
  def describeDomainConfiguration(
      request: DescribeDomainConfigurationRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeDomainConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDomainConfiguration(request))
  def describeCACertificate(request: DescribeCaCertificateRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeCaCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCACertificate(request))
  def updateDomainConfiguration(request: UpdateDomainConfigurationRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.UpdateDomainConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDomainConfiguration(request))
  def createJob(request: CreateJobRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createJob(request))
  def setLoggingOptions(
      request: SetLoggingOptionsRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.setLoggingOptions(request))
  def listAttachedPolicies(
      request: ListAttachedPoliciesRequest
  ): ZStream[zio.aws.iot.Iot, AwsError, zio.aws.iot.model.Policy.ReadOnly] =
    ZStream.serviceWithStream(_.listAttachedPolicies(request))
  def listAttachedPoliciesPaginated(request: ListAttachedPoliciesRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListAttachedPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAttachedPoliciesPaginated(request))
  def detachPolicy(
      request: DetachPolicyRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.detachPolicy(request))
  def describeIndex(request: DescribeIndexRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeIndexResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeIndex(request))
  def cancelAuditMitigationActionsTask(
      request: CancelAuditMitigationActionsTaskRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CancelAuditMitigationActionsTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelAuditMitigationActionsTask(request))
  def attachThingPrincipal(request: AttachThingPrincipalRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.AttachThingPrincipalResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.attachThingPrincipal(request))
  def describeMitigationAction(request: DescribeMitigationActionRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeMitigationActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMitigationAction(request))
  def createProvisioningTemplate(
      request: CreateProvisioningTemplateRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateProvisioningTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProvisioningTemplate(request))
  def listThingsInBillingGroup(
      request: ListThingsInBillingGroupRequest
  ): ZStream[zio.aws.iot.Iot, AwsError, ThingName] =
    ZStream.serviceWithStream(_.listThingsInBillingGroup(request))
  def listThingsInBillingGroupPaginated(
      request: ListThingsInBillingGroupRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListThingsInBillingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listThingsInBillingGroupPaginated(request))
  def cancelJob(request: CancelJobRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CancelJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelJob(request))
  def listViolationEvents(request: ListViolationEventsRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ViolationEvent.ReadOnly
  ] = ZStream.serviceWithStream(_.listViolationEvents(request))
  def listViolationEventsPaginated(request: ListViolationEventsRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListViolationEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listViolationEventsPaginated(request))
  def describeThingGroup(request: DescribeThingGroupRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeThingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeThingGroup(request))
  def listTopicRules(request: ListTopicRulesRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.TopicRuleListItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listTopicRules(request))
  def listTopicRulesPaginated(request: ListTopicRulesRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListTopicRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTopicRulesPaginated(request))
  def listPolicyVersions(request: ListPolicyVersionsRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListPolicyVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPolicyVersions(request))
  def updateAuthorizer(request: UpdateAuthorizerRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.UpdateAuthorizerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAuthorizer(request))
  def createDomainConfiguration(request: CreateDomainConfigurationRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateDomainConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDomainConfiguration(request))
  def getOTAUpdate(request: GetOtaUpdateRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.GetOtaUpdateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getOTAUpdate(request))
  def registerCertificateWithoutCA(
      request: RegisterCertificateWithoutCaRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.RegisterCertificateWithoutCaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerCertificateWithoutCA(request))
  def rejectCertificateTransfer(
      request: RejectCertificateTransferRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.rejectCertificateTransfer(request))
  def describeAuditFinding(request: DescribeAuditFindingRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeAuditFindingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAuditFinding(request))
  def startOnDemandAuditTask(request: StartOnDemandAuditTaskRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.StartOnDemandAuditTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startOnDemandAuditTask(request))
  def deleteSecurityProfile(request: DeleteSecurityProfileRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DeleteSecurityProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSecurityProfile(request))
  def listAuditMitigationActionsExecutions(
      request: ListAuditMitigationActionsExecutionsRequest
  ): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.AuditMitigationActionExecutionMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listAuditMitigationActionsExecutions(request))
  def listAuditMitigationActionsExecutionsPaginated(
      request: ListAuditMitigationActionsExecutionsRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListAuditMitigationActionsExecutionsResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.listAuditMitigationActionsExecutionsPaginated(request))
  def getTopicRuleDestination(request: GetTopicRuleDestinationRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.GetTopicRuleDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTopicRuleDestination(request))
  def listThingGroups(request: ListThingGroupsRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.GroupNameAndArn.ReadOnly
  ] = ZStream.serviceWithStream(_.listThingGroups(request))
  def listThingGroupsPaginated(request: ListThingGroupsRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListThingGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listThingGroupsPaginated(request))
  def deleteCertificate(
      request: DeleteCertificateRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteCertificate(request))
  def describeJobTemplate(request: DescribeJobTemplateRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeJobTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeJobTemplate(request))
  def deleteFleetMetric(
      request: DeleteFleetMetricRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteFleetMetric(request))
  def setDefaultPolicyVersion(
      request: SetDefaultPolicyVersionRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.setDefaultPolicyVersion(request))
  def deleteCACertificate(request: DeleteCaCertificateRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DeleteCaCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCACertificate(request))
  def deleteV2LoggingLevel(
      request: DeleteV2LoggingLevelRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteV2LoggingLevel(request))
  def listAuditFindings(request: ListAuditFindingsRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.AuditFinding.ReadOnly
  ] = ZStream.serviceWithStream(_.listAuditFindings(request))
  def listAuditFindingsPaginated(request: ListAuditFindingsRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListAuditFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAuditFindingsPaginated(request))
  def validateSecurityProfileBehaviors(
      request: ValidateSecurityProfileBehaviorsRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ValidateSecurityProfileBehaviorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.validateSecurityProfileBehaviors(request))
  def listRoleAliases(
      request: ListRoleAliasesRequest
  ): ZStream[zio.aws.iot.Iot, AwsError, RoleAlias] =
    ZStream.serviceWithStream(_.listRoleAliases(request))
  def listRoleAliasesPaginated(request: ListRoleAliasesRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListRoleAliasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRoleAliasesPaginated(request))
  def listCertificatesByCA(request: ListCertificatesByCaRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.Certificate.ReadOnly
  ] = ZStream.serviceWithStream(_.listCertificatesByCA(request))
  def listCertificatesByCAPaginated(request: ListCertificatesByCaRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListCertificatesByCaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCertificatesByCAPaginated(request))
  def updateAccountAuditConfiguration(
      request: UpdateAccountAuditConfigurationRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.UpdateAccountAuditConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAccountAuditConfiguration(request))
  def describeSecurityProfile(request: DescribeSecurityProfileRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeSecurityProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSecurityProfile(request))
  def listAuthorizers(request: ListAuthorizersRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.AuthorizerSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listAuthorizers(request))
  def listAuthorizersPaginated(request: ListAuthorizersRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListAuthorizersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAuthorizersPaginated(request))
  def deleteStream(request: DeleteStreamRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DeleteStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteStream(request))
  def deleteOTAUpdate(request: DeleteOtaUpdateRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DeleteOtaUpdateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteOTAUpdate(request))
  def updateMitigationAction(request: UpdateMitigationActionRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.UpdateMitigationActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMitigationAction(request))
  def clearDefaultAuthorizer(request: ClearDefaultAuthorizerRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ClearDefaultAuthorizerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.clearDefaultAuthorizer(request))
  def deleteScheduledAudit(request: DeleteScheduledAuditRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DeleteScheduledAuditResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteScheduledAudit(request))
  def listPolicies(
      request: ListPoliciesRequest
  ): ZStream[zio.aws.iot.Iot, AwsError, zio.aws.iot.model.Policy.ReadOnly] =
    ZStream.serviceWithStream(_.listPolicies(request))
  def listPoliciesPaginated(request: ListPoliciesRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPoliciesPaginated(request))
  def describeProvisioningTemplateVersion(
      request: DescribeProvisioningTemplateVersionRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeProvisioningTemplateVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProvisioningTemplateVersion(request))
  def listCustomMetrics(
      request: ListCustomMetricsRequest
  ): ZStream[zio.aws.iot.Iot, AwsError, MetricName] =
    ZStream.serviceWithStream(_.listCustomMetrics(request))
  def listCustomMetricsPaginated(request: ListCustomMetricsRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListCustomMetricsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCustomMetricsPaginated(request))
  def listOTAUpdates(request: ListOtaUpdatesRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.OTAUpdateSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listOTAUpdates(request))
  def listOTAUpdatesPaginated(request: ListOtaUpdatesRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListOtaUpdatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOTAUpdatesPaginated(request))
  def replaceTopicRule(
      request: ReplaceTopicRuleRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.replaceTopicRule(request))
  def getV2LoggingOptions(request: GetV2LoggingOptionsRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.GetV2LoggingOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getV2LoggingOptions(request))
  def describeStream(request: DescribeStreamRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStream(request))
  def listMitigationActions(request: ListMitigationActionsRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.MitigationActionIdentifier.ReadOnly
  ] = ZStream.serviceWithStream(_.listMitigationActions(request))
  def listMitigationActionsPaginated(
      request: ListMitigationActionsRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListMitigationActionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMitigationActionsPaginated(request))
  def cancelCertificateTransfer(
      request: CancelCertificateTransferRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.cancelCertificateTransfer(request))
  def createStream(request: CreateStreamRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStream(request))
  def acceptCertificateTransfer(
      request: AcceptCertificateTransferRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.acceptCertificateTransfer(request))
  def listDetectMitigationActionsExecutions(
      request: ListDetectMitigationActionsExecutionsRequest
  ): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DetectMitigationActionExecution.ReadOnly
  ] =
    ZStream.serviceWithStream(_.listDetectMitigationActionsExecutions(request))
  def listDetectMitigationActionsExecutionsPaginated(
      request: ListDetectMitigationActionsExecutionsRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListDetectMitigationActionsExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.listDetectMitigationActionsExecutionsPaginated(request)
  )
  def createTopicRule(
      request: CreateTopicRuleRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.createTopicRule(request))
  def deletePolicyVersion(
      request: DeletePolicyVersionRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deletePolicyVersion(request))
  def listTopicRuleDestinations(
      request: ListTopicRuleDestinationsRequest
  ): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.TopicRuleDestinationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listTopicRuleDestinations(request))
  def listTopicRuleDestinationsPaginated(
      request: ListTopicRuleDestinationsRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListTopicRuleDestinationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTopicRuleDestinationsPaginated(request))
  def searchIndex(request: SearchIndexRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.SearchIndexResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchIndex(request))
  def attachSecurityProfile(request: AttachSecurityProfileRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.AttachSecurityProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.attachSecurityProfile(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def updateCertificate(
      request: UpdateCertificateRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateCertificate(request))
  def createFleetMetric(request: CreateFleetMetricRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateFleetMetricResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFleetMetric(request))
  def describeEndpoint(request: DescribeEndpointRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEndpoint(request))
  def updateProvisioningTemplate(
      request: UpdateProvisioningTemplateRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.UpdateProvisioningTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProvisioningTemplate(request))
  def listSecurityProfiles(request: ListSecurityProfilesRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.SecurityProfileIdentifier.ReadOnly
  ] = ZStream.serviceWithStream(_.listSecurityProfiles(request))
  def listSecurityProfilesPaginated(request: ListSecurityProfilesRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListSecurityProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSecurityProfilesPaginated(request))
  def deleteTopicRuleDestination(
      request: DeleteTopicRuleDestinationRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DeleteTopicRuleDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTopicRuleDestination(request))
  def createCertificateFromCsr(request: CreateCertificateFromCsrRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateCertificateFromCsrResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCertificateFromCsr(request))
  def createRoleAlias(request: CreateRoleAliasRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateRoleAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRoleAlias(request))
  def registerCACertificate(request: RegisterCaCertificateRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.RegisterCaCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerCACertificate(request))
  def setV2LoggingOptions(
      request: SetV2LoggingOptionsRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.setV2LoggingOptions(request))
  def getStatistics(request: GetStatisticsRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.GetStatisticsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStatistics(request))
  def listDimensions(
      request: ListDimensionsRequest
  ): ZStream[zio.aws.iot.Iot, AwsError, DimensionName] =
    ZStream.serviceWithStream(_.listDimensions(request))
  def listDimensionsPaginated(request: ListDimensionsRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListDimensionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDimensionsPaginated(request))
  def createThingGroup(request: CreateThingGroupRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateThingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createThingGroup(request))
  def listDetectMitigationActionsTasks(
      request: ListDetectMitigationActionsTasksRequest
  ): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DetectMitigationActionsTaskSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDetectMitigationActionsTasks(request))
  def listDetectMitigationActionsTasksPaginated(
      request: ListDetectMitigationActionsTasksRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListDetectMitigationActionsTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDetectMitigationActionsTasksPaginated(request))
  def updateFleetMetric(
      request: UpdateFleetMetricRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateFleetMetric(request))
  def deleteTopicRule(
      request: DeleteTopicRuleRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteTopicRule(request))
  def createMitigationAction(request: CreateMitigationActionRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateMitigationActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMitigationAction(request))
  def describeCustomMetric(request: DescribeCustomMetricRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeCustomMetricResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCustomMetric(request))
  def describeDetectMitigationActionsTask(
      request: DescribeDetectMitigationActionsTaskRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeDetectMitigationActionsTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDetectMitigationActionsTask(request))
  def listBillingGroups(request: ListBillingGroupsRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.GroupNameAndArn.ReadOnly
  ] = ZStream.serviceWithStream(_.listBillingGroups(request))
  def listBillingGroupsPaginated(request: ListBillingGroupsRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListBillingGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBillingGroupsPaginated(request))
  def updateJob(
      request: UpdateJobRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateJob(request))
  def createAuthorizer(request: CreateAuthorizerRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateAuthorizerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAuthorizer(request))
  def setDefaultAuthorizer(request: SetDefaultAuthorizerRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.SetDefaultAuthorizerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setDefaultAuthorizer(request))
  def deleteRoleAlias(request: DeleteRoleAliasRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DeleteRoleAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRoleAlias(request))
  def attachPolicy(
      request: AttachPolicyRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.attachPolicy(request))
  def listThingRegistrationTasks(
      request: ListThingRegistrationTasksRequest
  ): ZStream[zio.aws.iot.Iot, AwsError, TaskId] =
    ZStream.serviceWithStream(_.listThingRegistrationTasks(request))
  def listThingRegistrationTasksPaginated(
      request: ListThingRegistrationTasksRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListThingRegistrationTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listThingRegistrationTasksPaginated(request))
  def describeAuditSuppression(request: DescribeAuditSuppressionRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeAuditSuppressionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAuditSuppression(request))
  def listThingPrincipals(
      request: ListThingPrincipalsRequest
  ): ZStream[zio.aws.iot.Iot, AwsError, PrincipalArn] =
    ZStream.serviceWithStream(_.listThingPrincipals(request))
  def listThingPrincipalsPaginated(request: ListThingPrincipalsRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListThingPrincipalsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listThingPrincipalsPaginated(request))
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): ZStream[zio.aws.iot.Iot, AwsError, zio.aws.iot.model.Tag.ReadOnly] =
    ZStream.serviceWithStream(_.listTagsForResource(request))
  def listTagsForResourcePaginated(request: ListTagsForResourceRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def deleteThing(request: DeleteThingRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DeleteThingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteThing(request))
  def listAuditMitigationActionsTasks(
      request: ListAuditMitigationActionsTasksRequest
  ): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.AuditMitigationActionsTaskMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listAuditMitigationActionsTasks(request))
  def listAuditMitigationActionsTasksPaginated(
      request: ListAuditMitigationActionsTasksRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListAuditMitigationActionsTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAuditMitigationActionsTasksPaginated(request))
  def listJobs(
      request: ListJobsRequest
  ): ZStream[zio.aws.iot.Iot, AwsError, zio.aws.iot.model.JobSummary.ReadOnly] =
    ZStream.serviceWithStream(_.listJobs(request))
  def listJobsPaginated(request: ListJobsRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listJobsPaginated(request))
  def createCustomMetric(request: CreateCustomMetricRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateCustomMetricResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCustomMetric(request))
  def createPolicy(request: CreatePolicyRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreatePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPolicy(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def enableTopicRule(
      request: EnableTopicRuleRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.enableTopicRule(request))
  def deleteThingType(request: DeleteThingTypeRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DeleteThingTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteThingType(request))
  def listManagedJobTemplates(request: ListManagedJobTemplatesRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListManagedJobTemplatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listManagedJobTemplates(request))
  def listThingsInThingGroup(
      request: ListThingsInThingGroupRequest
  ): ZStream[zio.aws.iot.Iot, AwsError, ThingName] =
    ZStream.serviceWithStream(_.listThingsInThingGroup(request))
  def listThingsInThingGroupPaginated(
      request: ListThingsInThingGroupRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListThingsInThingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listThingsInThingGroupPaginated(request))
  def getTopicRule(request: GetTopicRuleRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.GetTopicRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTopicRule(request))
  def listScheduledAudits(request: ListScheduledAuditsRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ScheduledAuditMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listScheduledAudits(request))
  def listScheduledAuditsPaginated(request: ListScheduledAuditsRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListScheduledAuditsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listScheduledAuditsPaginated(request))
  def startThingRegistrationTask(
      request: StartThingRegistrationTaskRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.StartThingRegistrationTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startThingRegistrationTask(request))
  def listV2LoggingLevels(request: ListV2LoggingLevelsRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.LogTargetConfiguration.ReadOnly
  ] = ZStream.serviceWithStream(_.listV2LoggingLevels(request))
  def listV2LoggingLevelsPaginated(request: ListV2LoggingLevelsRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListV2LoggingLevelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listV2LoggingLevelsPaginated(request))
  def deletePolicy(
      request: DeletePolicyRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deletePolicy(request))
  def deleteAuthorizer(request: DeleteAuthorizerRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DeleteAuthorizerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAuthorizer(request))
  def getPolicy(request: GetPolicyRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.GetPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPolicy(request))
  def startAuditMitigationActionsTask(
      request: StartAuditMitigationActionsTaskRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.StartAuditMitigationActionsTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startAuditMitigationActionsTask(request))
  def transferCertificate(request: TransferCertificateRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.TransferCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.transferCertificate(request))
  def addThingToThingGroup(request: AddThingToThingGroupRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.AddThingToThingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addThingToThingGroup(request))
  def startDetectMitigationActionsTask(
      request: StartDetectMitigationActionsTaskRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.StartDetectMitigationActionsTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDetectMitigationActionsTask(request))
  def associateTargetsWithJob(request: AssociateTargetsWithJobRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.AssociateTargetsWithJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateTargetsWithJob(request))
  def describeEventConfigurations(
      request: DescribeEventConfigurationsRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeEventConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventConfigurations(request))
  def describeThingType(request: DescribeThingTypeRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeThingTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeThingType(request))
  def listJobExecutionsForThing(
      request: ListJobExecutionsForThingRequest
  ): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.JobExecutionSummaryForThing.ReadOnly
  ] = ZStream.serviceWithStream(_.listJobExecutionsForThing(request))
  def listJobExecutionsForThingPaginated(
      request: ListJobExecutionsForThingRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListJobExecutionsForThingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listJobExecutionsForThingPaginated(request))
  def updateRoleAlias(request: UpdateRoleAliasRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.UpdateRoleAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRoleAlias(request))
  def listProvisioningTemplates(
      request: ListProvisioningTemplatesRequest
  ): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ProvisioningTemplateSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listProvisioningTemplates(request))
  def listProvisioningTemplatesPaginated(
      request: ListProvisioningTemplatesRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListProvisioningTemplatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProvisioningTemplatesPaginated(request))
  def listThingTypes(request: ListThingTypesRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ThingTypeDefinition.ReadOnly
  ] = ZStream.serviceWithStream(_.listThingTypes(request))
  def listThingTypesPaginated(request: ListThingTypesRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListThingTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listThingTypesPaginated(request))
  def disableTopicRule(
      request: DisableTopicRuleRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disableTopicRule(request))
  def registerCertificate(request: RegisterCertificateRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.RegisterCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerCertificate(request))
  def describeDimension(request: DescribeDimensionRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeDimensionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDimension(request))
  def createPolicyVersion(request: CreatePolicyVersionRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreatePolicyVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPolicyVersion(request))
  def deleteRegistrationCode(request: DeleteRegistrationCodeRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DeleteRegistrationCodeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRegistrationCode(request))
  def describeBillingGroup(request: DescribeBillingGroupRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeBillingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeBillingGroup(request))
  def updateSecurityProfile(request: UpdateSecurityProfileRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.UpdateSecurityProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSecurityProfile(request))
  def updateTopicRuleDestination(
      request: UpdateTopicRuleDestinationRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.UpdateTopicRuleDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTopicRuleDestination(request))
  def updateBillingGroup(request: UpdateBillingGroupRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.UpdateBillingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBillingGroup(request))
  def getEffectivePolicies(request: GetEffectivePoliciesRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.GetEffectivePoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEffectivePolicies(request))
  def listAuditTasks(request: ListAuditTasksRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.AuditTaskMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listAuditTasks(request))
  def listAuditTasksPaginated(request: ListAuditTasksRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListAuditTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAuditTasksPaginated(request))
  def describeCertificate(request: DescribeCertificateRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCertificate(request))
  def describeAuditMitigationActionsTask(
      request: DescribeAuditMitigationActionsTaskRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeAuditMitigationActionsTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAuditMitigationActionsTask(request))
  def createThingType(request: CreateThingTypeRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateThingTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createThingType(request))
  def createAuditSuppression(request: CreateAuditSuppressionRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateAuditSuppressionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAuditSuppression(request))
  def getLoggingOptions(request: GetLoggingOptionsRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.GetLoggingOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLoggingOptions(request))
  def listThingGroupsForThing(request: ListThingGroupsForThingRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.GroupNameAndArn.ReadOnly
  ] = ZStream.serviceWithStream(_.listThingGroupsForThing(request))
  def listThingGroupsForThingPaginated(
      request: ListThingGroupsForThingRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListThingGroupsForThingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listThingGroupsForThingPaginated(request))
  def getBucketsAggregation(request: GetBucketsAggregationRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.GetBucketsAggregationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketsAggregation(request))
  def removeThingFromBillingGroup(
      request: RemoveThingFromBillingGroupRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.RemoveThingFromBillingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeThingFromBillingGroup(request))
  def listCertificates(request: ListCertificatesRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.Certificate.ReadOnly
  ] = ZStream.serviceWithStream(_.listCertificates(request))
  def listCertificatesPaginated(request: ListCertificatesRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListCertificatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCertificatesPaginated(request))
  def getPolicyVersion(request: GetPolicyVersionRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.GetPolicyVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPolicyVersion(request))
  def describeRoleAlias(request: DescribeRoleAliasRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeRoleAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRoleAlias(request))
  def deleteProvisioningTemplate(
      request: DeleteProvisioningTemplateRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DeleteProvisioningTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProvisioningTemplate(request))
  def updateDynamicThingGroup(request: UpdateDynamicThingGroupRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.UpdateDynamicThingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDynamicThingGroup(request))
  def createDimension(request: CreateDimensionRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateDimensionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDimension(request))
  def deprecateThingType(request: DeprecateThingTypeRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DeprecateThingTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deprecateThingType(request))
  def addThingToBillingGroup(request: AddThingToBillingGroupRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.AddThingToBillingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addThingToBillingGroup(request))
  def describeDefaultAuthorizer(request: DescribeDefaultAuthorizerRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeDefaultAuthorizerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDefaultAuthorizer(request))
  def testAuthorization(request: TestAuthorizationRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.TestAuthorizationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.testAuthorization(request))
  def listOutgoingCertificates(
      request: ListOutgoingCertificatesRequest
  ): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.OutgoingCertificate.ReadOnly
  ] = ZStream.serviceWithStream(_.listOutgoingCertificates(request))
  def listOutgoingCertificatesPaginated(
      request: ListOutgoingCertificatesRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListOutgoingCertificatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOutgoingCertificatesPaginated(request))
  def confirmTopicRuleDestination(
      request: ConfirmTopicRuleDestinationRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ConfirmTopicRuleDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.confirmTopicRuleDestination(request))
  def deleteAccountAuditConfiguration(
      request: DeleteAccountAuditConfigurationRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DeleteAccountAuditConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAccountAuditConfiguration(request))
  def describeFleetMetric(request: DescribeFleetMetricRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeFleetMetricResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFleetMetric(request))
  def listThings(request: ListThingsRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ThingAttribute.ReadOnly
  ] = ZStream.serviceWithStream(_.listThings(request))
  def listThingsPaginated(request: ListThingsRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListThingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listThingsPaginated(request))
  def describeAuditTask(request: DescribeAuditTaskRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DescribeAuditTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAuditTask(request))
  def updateEventConfigurations(request: UpdateEventConfigurationsRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.UpdateEventConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEventConfigurations(request))
  def deleteJob(
      request: DeleteJobRequest
  ): ZIO[zio.aws.iot.Iot, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteJob(request))
  def listThingRegistrationTaskReports(
      request: ListThingRegistrationTaskReportsRequest
  ): ZStream[zio.aws.iot.Iot, AwsError, S3FileUrl] =
    ZStream.serviceWithStream(_.listThingRegistrationTaskReports(request))
  def listThingRegistrationTaskReportsPaginated(
      request: ListThingRegistrationTaskReportsRequest
  ): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListThingRegistrationTaskReportsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listThingRegistrationTaskReportsPaginated(request))
  def createJobTemplate(request: CreateJobTemplateRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateJobTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createJobTemplate(request))
  def listFleetMetrics(request: ListFleetMetricsRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.FleetMetricNameAndArn.ReadOnly
  ] = ZStream.serviceWithStream(_.listFleetMetrics(request))
  def listFleetMetricsPaginated(request: ListFleetMetricsRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListFleetMetricsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFleetMetricsPaginated(request))
  def listActiveViolations(request: ListActiveViolationsRequest): ZStream[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ActiveViolation.ReadOnly
  ] = ZStream.serviceWithStream(_.listActiveViolations(request))
  def listActiveViolationsPaginated(request: ListActiveViolationsRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.ListActiveViolationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listActiveViolationsPaginated(request))
  def cancelAuditTask(request: CancelAuditTaskRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CancelAuditTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelAuditTask(request))
  def deleteDynamicThingGroup(request: DeleteDynamicThingGroupRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DeleteDynamicThingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDynamicThingGroup(request))
  def detachSecurityProfile(request: DetachSecurityProfileRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.DetachSecurityProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detachSecurityProfile(request))
  def createThing(request: CreateThingRequest): ZIO[
    zio.aws.iot.Iot,
    AwsError,
    zio.aws.iot.model.CreateThingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createThing(request))
}
