package zio.aws.iot.model
import scala.jdk.CollectionConverters.*
sealed trait ActionType {
  def unwrap: software.amazon.awssdk.services.iot.model.ActionType
}
object ActionType {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.ActionType
  ): zio.aws.iot.model.ActionType = value match {
    case software.amazon.awssdk.services.iot.model.ActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.ActionType.PUBLISH =>
      val r = PUBLISH
      r
    case software.amazon.awssdk.services.iot.model.ActionType.SUBSCRIBE =>
      val r = SUBSCRIBE
      r
    case software.amazon.awssdk.services.iot.model.ActionType.RECEIVE =>
      val r = RECEIVE
      r
    case software.amazon.awssdk.services.iot.model.ActionType.CONNECT =>
      val r = CONNECT
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.ActionType {
    override def unwrap: software.amazon.awssdk.services.iot.model.ActionType =
      software.amazon.awssdk.services.iot.model.ActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object PUBLISH extends zio.aws.iot.model.ActionType {
    override def unwrap: software.amazon.awssdk.services.iot.model.ActionType =
      software.amazon.awssdk.services.iot.model.ActionType.PUBLISH
  }
  case object SUBSCRIBE extends zio.aws.iot.model.ActionType {
    override def unwrap: software.amazon.awssdk.services.iot.model.ActionType =
      software.amazon.awssdk.services.iot.model.ActionType.SUBSCRIBE
  }
  case object RECEIVE extends zio.aws.iot.model.ActionType {
    override def unwrap: software.amazon.awssdk.services.iot.model.ActionType =
      software.amazon.awssdk.services.iot.model.ActionType.RECEIVE
  }
  case object CONNECT extends zio.aws.iot.model.ActionType {
    override def unwrap: software.amazon.awssdk.services.iot.model.ActionType =
      software.amazon.awssdk.services.iot.model.ActionType.CONNECT
  }
}
