package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  OverrideDynamicGroups,
  ThingName,
  ThingGroupArn,
  ThingArn,
  ThingGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AddThingToThingGroupRequest(
    thingGroupName: Option[ThingGroupName] = None,
    thingGroupArn: Option[ThingGroupArn] = None,
    thingName: Option[ThingName] = None,
    thingArn: Option[ThingArn] = None,
    overrideDynamicGroups: Option[OverrideDynamicGroups] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AddThingToThingGroupRequest = {
    import AddThingToThingGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AddThingToThingGroupRequest
      .builder()
      .optionallyWith(
        thingGroupName.map(value =>
          ThingGroupName.unwrap(value): java.lang.String
        )
      )(_.thingGroupName)
      .optionallyWith(
        thingGroupArn.map(value =>
          ThingGroupArn.unwrap(value): java.lang.String
        )
      )(_.thingGroupArn)
      .optionallyWith(
        thingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.thingName)
      .optionallyWith(
        thingArn.map(value => ThingArn.unwrap(value): java.lang.String)
      )(_.thingArn)
      .optionallyWith(
        overrideDynamicGroups.map(value =>
          OverrideDynamicGroups.unwrap(value): java.lang.Boolean
        )
      )(_.overrideDynamicGroups)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AddThingToThingGroupRequest.ReadOnly =
    zio.aws.iot.model.AddThingToThingGroupRequest.wrap(buildAwsValue())
}
object AddThingToThingGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AddThingToThingGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AddThingToThingGroupRequest =
      zio.aws.iot.model.AddThingToThingGroupRequest(
        thingGroupName.map(value => value),
        thingGroupArn.map(value => value),
        thingName.map(value => value),
        thingArn.map(value => value),
        overrideDynamicGroups.map(value => value)
      )
    def thingGroupName: Option[ThingGroupName]
    def thingGroupArn: Option[ThingGroupArn]
    def thingName: Option[ThingName]
    def thingArn: Option[ThingArn]
    def overrideDynamicGroups: Option[OverrideDynamicGroups]
    def getThingGroupName: ZIO[Any, AwsError, ThingGroupName] =
      AwsError.unwrapOptionField("thingGroupName", thingGroupName)
    def getThingGroupArn: ZIO[Any, AwsError, ThingGroupArn] =
      AwsError.unwrapOptionField("thingGroupArn", thingGroupArn)
    def getThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getThingArn: ZIO[Any, AwsError, ThingArn] =
      AwsError.unwrapOptionField("thingArn", thingArn)
    def getOverrideDynamicGroups: ZIO[Any, AwsError, OverrideDynamicGroups] =
      AwsError.unwrapOptionField("overrideDynamicGroups", overrideDynamicGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AddThingToThingGroupRequest
  ) extends zio.aws.iot.model.AddThingToThingGroupRequest.ReadOnly {
    override val thingGroupName: Option[ThingGroupName] = scala
      .Option(impl.thingGroupName())
      .map(value => zio.aws.iot.model.primitives.ThingGroupName(value))
    override val thingGroupArn: Option[ThingGroupArn] = scala
      .Option(impl.thingGroupArn())
      .map(value => zio.aws.iot.model.primitives.ThingGroupArn(value))
    override val thingName: Option[ThingName] = scala
      .Option(impl.thingName())
      .map(value => zio.aws.iot.model.primitives.ThingName(value))
    override val thingArn: Option[ThingArn] = scala
      .Option(impl.thingArn())
      .map(value => zio.aws.iot.model.primitives.ThingArn(value))
    override val overrideDynamicGroups: Option[OverrideDynamicGroups] = scala
      .Option(impl.overrideDynamicGroups())
      .map(value => zio.aws.iot.model.primitives.OverrideDynamicGroups(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AddThingToThingGroupRequest
  ): zio.aws.iot.model.AddThingToThingGroupRequest.ReadOnly = new Wrapper(impl)
}
