package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{OverrideDynamicGroups, ThingGroupName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AddThingsToThingGroupParams(
    thingGroupNames: Iterable[ThingGroupName],
    overrideDynamicGroups: Option[OverrideDynamicGroups] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AddThingsToThingGroupParams = {
    import AddThingsToThingGroupParams.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AddThingsToThingGroupParams
      .builder()
      .thingGroupNames(thingGroupNames.map { item =>
        ThingGroupName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        overrideDynamicGroups.map(value =>
          OverrideDynamicGroups.unwrap(value): java.lang.Boolean
        )
      )(_.overrideDynamicGroups)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AddThingsToThingGroupParams.ReadOnly =
    zio.aws.iot.model.AddThingsToThingGroupParams.wrap(buildAwsValue())
}
object AddThingsToThingGroupParams {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AddThingsToThingGroupParams
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AddThingsToThingGroupParams =
      zio.aws.iot.model.AddThingsToThingGroupParams(
        thingGroupNames,
        overrideDynamicGroups.map(value => value)
      )
    def thingGroupNames: List[ThingGroupName]
    def overrideDynamicGroups: Option[OverrideDynamicGroups]
    def getThingGroupNames: ZIO[Any, Nothing, List[ThingGroupName]] =
      ZIO.succeed(thingGroupNames)
    def getOverrideDynamicGroups: ZIO[Any, AwsError, OverrideDynamicGroups] =
      AwsError.unwrapOptionField("overrideDynamicGroups", overrideDynamicGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AddThingsToThingGroupParams
  ) extends zio.aws.iot.model.AddThingsToThingGroupParams.ReadOnly {
    override val thingGroupNames: List[ThingGroupName] = impl
      .thingGroupNames()
      .asScala
      .map { item =>
        zio.aws.iot.model.primitives.ThingGroupName(item)
      }
      .toList
    override val overrideDynamicGroups: Option[OverrideDynamicGroups] = scala
      .Option(impl.overrideDynamicGroups())
      .map(value => zio.aws.iot.model.primitives.OverrideDynamicGroups(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AddThingsToThingGroupParams
  ): zio.aws.iot.model.AddThingsToThingGroupParams.ReadOnly = new Wrapper(impl)
}
