package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  AssetPropertyOffsetInNanos,
  AssetPropertyTimeInSeconds
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AssetPropertyTimestamp(
    timeInSeconds: AssetPropertyTimeInSeconds,
    offsetInNanos: Option[AssetPropertyOffsetInNanos] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AssetPropertyTimestamp = {
    import AssetPropertyTimestamp.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AssetPropertyTimestamp
      .builder()
      .timeInSeconds(
        AssetPropertyTimeInSeconds.unwrap(timeInSeconds): java.lang.String
      )
      .optionallyWith(
        offsetInNanos.map(value =>
          AssetPropertyOffsetInNanos.unwrap(value): java.lang.String
        )
      )(_.offsetInNanos)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AssetPropertyTimestamp.ReadOnly =
    zio.aws.iot.model.AssetPropertyTimestamp.wrap(buildAwsValue())
}
object AssetPropertyTimestamp {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AssetPropertyTimestamp
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AssetPropertyTimestamp = zio.aws.iot.model
      .AssetPropertyTimestamp(timeInSeconds, offsetInNanos.map(value => value))
    def timeInSeconds: AssetPropertyTimeInSeconds
    def offsetInNanos: Option[AssetPropertyOffsetInNanos]
    def getTimeInSeconds: ZIO[Any, Nothing, AssetPropertyTimeInSeconds] =
      ZIO.succeed(timeInSeconds)
    def getOffsetInNanos: ZIO[Any, AwsError, AssetPropertyOffsetInNanos] =
      AwsError.unwrapOptionField("offsetInNanos", offsetInNanos)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AssetPropertyTimestamp
  ) extends zio.aws.iot.model.AssetPropertyTimestamp.ReadOnly {
    override val timeInSeconds: AssetPropertyTimeInSeconds =
      zio.aws.iot.model.primitives
        .AssetPropertyTimeInSeconds(impl.timeInSeconds())
    override val offsetInNanos: Option[AssetPropertyOffsetInNanos] = scala
      .Option(impl.offsetInNanos())
      .map(value =>
        zio.aws.iot.model.primitives.AssetPropertyOffsetInNanos(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AssetPropertyTimestamp
  ): zio.aws.iot.model.AssetPropertyTimestamp.ReadOnly = new Wrapper(impl)
}
