package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ErrorMessage,
  MitigationActionId,
  Timestamp,
  ErrorCode,
  FindingId,
  MitigationActionsTaskId,
  MitigationActionName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class AuditMitigationActionExecutionMetadata(
    taskId: Option[MitigationActionsTaskId] = None,
    findingId: Option[FindingId] = None,
    actionName: Option[MitigationActionName] = None,
    actionId: Option[MitigationActionId] = None,
    status: Option[zio.aws.iot.model.AuditMitigationActionsExecutionStatus] =
      None,
    startTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None,
    errorCode: Option[ErrorCode] = None,
    message: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AuditMitigationActionExecutionMetadata = {
    import AuditMitigationActionExecutionMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AuditMitigationActionExecutionMetadata
      .builder()
      .optionallyWith(
        taskId.map(value =>
          MitigationActionsTaskId.unwrap(value): java.lang.String
        )
      )(_.taskId)
      .optionallyWith(
        findingId.map(value => FindingId.unwrap(value): java.lang.String)
      )(_.findingId)
      .optionallyWith(
        actionName.map(value =>
          MitigationActionName.unwrap(value): java.lang.String
        )
      )(_.actionName)
      .optionallyWith(
        actionId.map(value =>
          MitigationActionId.unwrap(value): java.lang.String
        )
      )(_.actionId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.AuditMitigationActionExecutionMetadata.ReadOnly =
    zio.aws.iot.model.AuditMitigationActionExecutionMetadata
      .wrap(buildAwsValue())
}
object AuditMitigationActionExecutionMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AuditMitigationActionExecutionMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AuditMitigationActionExecutionMetadata =
      zio.aws.iot.model.AuditMitigationActionExecutionMetadata(
        taskId.map(value => value),
        findingId.map(value => value),
        actionName.map(value => value),
        actionId.map(value => value),
        status.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        errorCode.map(value => value),
        message.map(value => value)
      )
    def taskId: Option[MitigationActionsTaskId]
    def findingId: Option[FindingId]
    def actionName: Option[MitigationActionName]
    def actionId: Option[MitigationActionId]
    def status: Option[zio.aws.iot.model.AuditMitigationActionsExecutionStatus]
    def startTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def errorCode: Option[ErrorCode]
    def message: Option[ErrorMessage]
    def getTaskId: ZIO[Any, AwsError, MitigationActionsTaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getFindingId: ZIO[Any, AwsError, FindingId] =
      AwsError.unwrapOptionField("findingId", findingId)
    def getActionName: ZIO[Any, AwsError, MitigationActionName] =
      AwsError.unwrapOptionField("actionName", actionName)
    def getActionId: ZIO[Any, AwsError, MitigationActionId] =
      AwsError.unwrapOptionField("actionId", actionId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.AuditMitigationActionsExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AuditMitigationActionExecutionMetadata
  ) extends zio.aws.iot.model.AuditMitigationActionExecutionMetadata.ReadOnly {
    override val taskId: Option[MitigationActionsTaskId] = scala
      .Option(impl.taskId())
      .map(value => zio.aws.iot.model.primitives.MitigationActionsTaskId(value))
    override val findingId: Option[FindingId] = scala
      .Option(impl.findingId())
      .map(value => zio.aws.iot.model.primitives.FindingId(value))
    override val actionName: Option[MitigationActionName] = scala
      .Option(impl.actionName())
      .map(value => zio.aws.iot.model.primitives.MitigationActionName(value))
    override val actionId: Option[MitigationActionId] = scala
      .Option(impl.actionId())
      .map(value => zio.aws.iot.model.primitives.MitigationActionId(value))
    override val status
        : Option[zio.aws.iot.model.AuditMitigationActionsExecutionStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          zio.aws.iot.model.AuditMitigationActionsExecutionStatus.wrap(value)
        )
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val errorCode: Option[ErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.iot.model.primitives.ErrorCode(value))
    override val message: Option[ErrorMessage] = scala
      .Option(impl.message())
      .map(value => zio.aws.iot.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AuditMitigationActionExecutionMetadata
  ): zio.aws.iot.model.AuditMitigationActionExecutionMetadata.ReadOnly =
    new Wrapper(impl)
}
