package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{Timestamp, MitigationActionsTaskId}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class AuditMitigationActionsTaskMetadata(
    taskId: Option[MitigationActionsTaskId] = None,
    startTime: Option[Timestamp] = None,
    taskStatus: Option[zio.aws.iot.model.AuditMitigationActionsTaskStatus] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AuditMitigationActionsTaskMetadata = {
    import AuditMitigationActionsTaskMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AuditMitigationActionsTaskMetadata
      .builder()
      .optionallyWith(
        taskId.map(value =>
          MitigationActionsTaskId.unwrap(value): java.lang.String
        )
      )(_.taskId)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(taskStatus.map(value => value.unwrap))(_.taskStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.AuditMitigationActionsTaskMetadata.ReadOnly =
    zio.aws.iot.model.AuditMitigationActionsTaskMetadata.wrap(buildAwsValue())
}
object AuditMitigationActionsTaskMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AuditMitigationActionsTaskMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AuditMitigationActionsTaskMetadata =
      zio.aws.iot.model.AuditMitigationActionsTaskMetadata(
        taskId.map(value => value),
        startTime.map(value => value),
        taskStatus.map(value => value)
      )
    def taskId: Option[MitigationActionsTaskId]
    def startTime: Option[Timestamp]
    def taskStatus: Option[zio.aws.iot.model.AuditMitigationActionsTaskStatus]
    def getTaskId: ZIO[Any, AwsError, MitigationActionsTaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getTaskStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.AuditMitigationActionsTaskStatus
    ] = AwsError.unwrapOptionField("taskStatus", taskStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AuditMitigationActionsTaskMetadata
  ) extends zio.aws.iot.model.AuditMitigationActionsTaskMetadata.ReadOnly {
    override val taskId: Option[MitigationActionsTaskId] = scala
      .Option(impl.taskId())
      .map(value => zio.aws.iot.model.primitives.MitigationActionsTaskId(value))
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val taskStatus
        : Option[zio.aws.iot.model.AuditMitigationActionsTaskStatus] = scala
      .Option(impl.taskStatus())
      .map(value =>
        zio.aws.iot.model.AuditMitigationActionsTaskStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AuditMitigationActionsTaskMetadata
  ): zio.aws.iot.model.AuditMitigationActionsTaskMetadata.ReadOnly =
    new Wrapper(impl)
}
