package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{Enabled, RoleArn, TargetArn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AuditNotificationTarget(
    targetArn: Option[TargetArn] = None,
    roleArn: Option[RoleArn] = None,
    enabled: Option[Enabled] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AuditNotificationTarget = {
    import AuditNotificationTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AuditNotificationTarget
      .builder()
      .optionallyWith(
        targetArn.map(value => TargetArn.unwrap(value): java.lang.String)
      )(_.targetArn)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        enabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AuditNotificationTarget.ReadOnly =
    zio.aws.iot.model.AuditNotificationTarget.wrap(buildAwsValue())
}
object AuditNotificationTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AuditNotificationTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AuditNotificationTarget =
      zio.aws.iot.model.AuditNotificationTarget(
        targetArn.map(value => value),
        roleArn.map(value => value),
        enabled.map(value => value)
      )
    def targetArn: Option[TargetArn]
    def roleArn: Option[RoleArn]
    def enabled: Option[Enabled]
    def getTargetArn: ZIO[Any, AwsError, TargetArn] =
      AwsError.unwrapOptionField("targetArn", targetArn)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AuditNotificationTarget
  ) extends zio.aws.iot.model.AuditNotificationTarget.ReadOnly {
    override val targetArn: Option[TargetArn] = scala
      .Option(impl.targetArn())
      .map(value => zio.aws.iot.model.primitives.TargetArn(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.RoleArn(value))
    override val enabled: Option[Enabled] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.iot.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AuditNotificationTarget
  ): zio.aws.iot.model.AuditNotificationTarget.ReadOnly = new Wrapper(impl)
}
