package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AuditTaskId
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AuditTaskMetadata(
    taskId: Option[AuditTaskId] = None,
    taskStatus: Option[zio.aws.iot.model.AuditTaskStatus] = None,
    taskType: Option[zio.aws.iot.model.AuditTaskType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AuditTaskMetadata = {
    import AuditTaskMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AuditTaskMetadata
      .builder()
      .optionallyWith(
        taskId.map(value => AuditTaskId.unwrap(value): java.lang.String)
      )(_.taskId)
      .optionallyWith(taskStatus.map(value => value.unwrap))(_.taskStatus)
      .optionallyWith(taskType.map(value => value.unwrap))(_.taskType)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AuditTaskMetadata.ReadOnly =
    zio.aws.iot.model.AuditTaskMetadata.wrap(buildAwsValue())
}
object AuditTaskMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AuditTaskMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AuditTaskMetadata =
      zio.aws.iot.model.AuditTaskMetadata(
        taskId.map(value => value),
        taskStatus.map(value => value),
        taskType.map(value => value)
      )
    def taskId: Option[AuditTaskId]
    def taskStatus: Option[zio.aws.iot.model.AuditTaskStatus]
    def taskType: Option[zio.aws.iot.model.AuditTaskType]
    def getTaskId: ZIO[Any, AwsError, AuditTaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getTaskStatus: ZIO[Any, AwsError, zio.aws.iot.model.AuditTaskStatus] =
      AwsError.unwrapOptionField("taskStatus", taskStatus)
    def getTaskType: ZIO[Any, AwsError, zio.aws.iot.model.AuditTaskType] =
      AwsError.unwrapOptionField("taskType", taskType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AuditTaskMetadata
  ) extends zio.aws.iot.model.AuditTaskMetadata.ReadOnly {
    override val taskId: Option[AuditTaskId] = scala
      .Option(impl.taskId())
      .map(value => zio.aws.iot.model.primitives.AuditTaskId(value))
    override val taskStatus: Option[zio.aws.iot.model.AuditTaskStatus] = scala
      .Option(impl.taskStatus())
      .map(value => zio.aws.iot.model.AuditTaskStatus.wrap(value))
    override val taskType: Option[zio.aws.iot.model.AuditTaskType] = scala
      .Option(impl.taskType())
      .map(value => zio.aws.iot.model.AuditTaskType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AuditTaskMetadata
  ): zio.aws.iot.model.AuditTaskMetadata.ReadOnly = new Wrapper(impl)
}
