package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.MissingContextValue
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AuthResult(
    authInfo: Option[zio.aws.iot.model.AuthInfo] = None,
    allowed: Option[zio.aws.iot.model.Allowed] = None,
    denied: Option[zio.aws.iot.model.Denied] = None,
    authDecision: Option[zio.aws.iot.model.AuthDecision] = None,
    missingContextValues: Option[Iterable[MissingContextValue]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.AuthResult = {
    import AuthResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AuthResult
      .builder()
      .optionallyWith(authInfo.map(value => value.buildAwsValue()))(_.authInfo)
      .optionallyWith(allowed.map(value => value.buildAwsValue()))(_.allowed)
      .optionallyWith(denied.map(value => value.buildAwsValue()))(_.denied)
      .optionallyWith(authDecision.map(value => value.unwrap))(_.authDecision)
      .optionallyWith(
        missingContextValues.map(value =>
          value.map { item =>
            MissingContextValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.missingContextValues)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AuthResult.ReadOnly =
    zio.aws.iot.model.AuthResult.wrap(buildAwsValue())
}
object AuthResult {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.AuthResult] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AuthResult = zio.aws.iot.model.AuthResult(
      authInfo.map(value => value.asEditable),
      allowed.map(value => value.asEditable),
      denied.map(value => value.asEditable),
      authDecision.map(value => value),
      missingContextValues.map(value => value)
    )
    def authInfo: Option[zio.aws.iot.model.AuthInfo.ReadOnly]
    def allowed: Option[zio.aws.iot.model.Allowed.ReadOnly]
    def denied: Option[zio.aws.iot.model.Denied.ReadOnly]
    def authDecision: Option[zio.aws.iot.model.AuthDecision]
    def missingContextValues: Option[List[MissingContextValue]]
    def getAuthInfo: ZIO[Any, AwsError, zio.aws.iot.model.AuthInfo.ReadOnly] =
      AwsError.unwrapOptionField("authInfo", authInfo)
    def getAllowed: ZIO[Any, AwsError, zio.aws.iot.model.Allowed.ReadOnly] =
      AwsError.unwrapOptionField("allowed", allowed)
    def getDenied: ZIO[Any, AwsError, zio.aws.iot.model.Denied.ReadOnly] =
      AwsError.unwrapOptionField("denied", denied)
    def getAuthDecision: ZIO[Any, AwsError, zio.aws.iot.model.AuthDecision] =
      AwsError.unwrapOptionField("authDecision", authDecision)
    def getMissingContextValues: ZIO[Any, AwsError, List[MissingContextValue]] =
      AwsError.unwrapOptionField("missingContextValues", missingContextValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AuthResult
  ) extends zio.aws.iot.model.AuthResult.ReadOnly {
    override val authInfo: Option[zio.aws.iot.model.AuthInfo.ReadOnly] = scala
      .Option(impl.authInfo())
      .map(value => zio.aws.iot.model.AuthInfo.wrap(value))
    override val allowed: Option[zio.aws.iot.model.Allowed.ReadOnly] = scala
      .Option(impl.allowed())
      .map(value => zio.aws.iot.model.Allowed.wrap(value))
    override val denied: Option[zio.aws.iot.model.Denied.ReadOnly] = scala
      .Option(impl.denied())
      .map(value => zio.aws.iot.model.Denied.wrap(value))
    override val authDecision: Option[zio.aws.iot.model.AuthDecision] = scala
      .Option(impl.authDecision())
      .map(value => zio.aws.iot.model.AuthDecision.wrap(value))
    override val missingContextValues: Option[List[MissingContextValue]] = scala
      .Option(impl.missingContextValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.MissingContextValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AuthResult
  ): zio.aws.iot.model.AuthResult.ReadOnly = new Wrapper(impl)
}
