package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{AllowAuthorizerOverride, AuthorizerName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AuthorizerConfig(
    defaultAuthorizerName: Option[AuthorizerName] = None,
    allowAuthorizerOverride: Option[AllowAuthorizerOverride] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AuthorizerConfig = {
    import AuthorizerConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AuthorizerConfig
      .builder()
      .optionallyWith(
        defaultAuthorizerName.map(value =>
          AuthorizerName.unwrap(value): java.lang.String
        )
      )(_.defaultAuthorizerName)
      .optionallyWith(
        allowAuthorizerOverride.map(value =>
          AllowAuthorizerOverride.unwrap(value): java.lang.Boolean
        )
      )(_.allowAuthorizerOverride)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AuthorizerConfig.ReadOnly =
    zio.aws.iot.model.AuthorizerConfig.wrap(buildAwsValue())
}
object AuthorizerConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AuthorizerConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AuthorizerConfig =
      zio.aws.iot.model.AuthorizerConfig(
        defaultAuthorizerName.map(value => value),
        allowAuthorizerOverride.map(value => value)
      )
    def defaultAuthorizerName: Option[AuthorizerName]
    def allowAuthorizerOverride: Option[AllowAuthorizerOverride]
    def getDefaultAuthorizerName: ZIO[Any, AwsError, AuthorizerName] =
      AwsError.unwrapOptionField("defaultAuthorizerName", defaultAuthorizerName)
    def getAllowAuthorizerOverride
        : ZIO[Any, AwsError, AllowAuthorizerOverride] = AwsError
      .unwrapOptionField("allowAuthorizerOverride", allowAuthorizerOverride)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AuthorizerConfig
  ) extends zio.aws.iot.model.AuthorizerConfig.ReadOnly {
    override val defaultAuthorizerName: Option[AuthorizerName] = scala
      .Option(impl.defaultAuthorizerName())
      .map(value => zio.aws.iot.model.primitives.AuthorizerName(value))
    override val allowAuthorizerOverride: Option[AllowAuthorizerOverride] =
      scala
        .Option(impl.allowAuthorizerOverride())
        .map(value =>
          zio.aws.iot.model.primitives.AllowAuthorizerOverride(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AuthorizerConfig
  ): zio.aws.iot.model.AuthorizerConfig.ReadOnly = new Wrapper(impl)
}
