package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.MaximumPerMinute
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AwsJobExecutionsRolloutConfig(
    maximumPerMinute: Option[MaximumPerMinute] = None,
    exponentialRate: Option[zio.aws.iot.model.AwsJobExponentialRolloutRate] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AwsJobExecutionsRolloutConfig = {
    import AwsJobExecutionsRolloutConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AwsJobExecutionsRolloutConfig
      .builder()
      .optionallyWith(
        maximumPerMinute.map(value => MaximumPerMinute.unwrap(value): Integer)
      )(_.maximumPerMinute)
      .optionallyWith(exponentialRate.map(value => value.buildAwsValue()))(
        _.exponentialRate
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AwsJobExecutionsRolloutConfig.ReadOnly =
    zio.aws.iot.model.AwsJobExecutionsRolloutConfig.wrap(buildAwsValue())
}
object AwsJobExecutionsRolloutConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AwsJobExecutionsRolloutConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AwsJobExecutionsRolloutConfig =
      zio.aws.iot.model.AwsJobExecutionsRolloutConfig(
        maximumPerMinute.map(value => value),
        exponentialRate.map(value => value.asEditable)
      )
    def maximumPerMinute: Option[MaximumPerMinute]
    def exponentialRate
        : Option[zio.aws.iot.model.AwsJobExponentialRolloutRate.ReadOnly]
    def getMaximumPerMinute: ZIO[Any, AwsError, MaximumPerMinute] =
      AwsError.unwrapOptionField("maximumPerMinute", maximumPerMinute)
    def getExponentialRate: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.AwsJobExponentialRolloutRate.ReadOnly
    ] = AwsError.unwrapOptionField("exponentialRate", exponentialRate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AwsJobExecutionsRolloutConfig
  ) extends zio.aws.iot.model.AwsJobExecutionsRolloutConfig.ReadOnly {
    override val maximumPerMinute: Option[MaximumPerMinute] = scala
      .Option(impl.maximumPerMinute())
      .map(value => zio.aws.iot.model.primitives.MaximumPerMinute(value))
    override val exponentialRate
        : Option[zio.aws.iot.model.AwsJobExponentialRolloutRate.ReadOnly] =
      scala
        .Option(impl.exponentialRate())
        .map(value =>
          zio.aws.iot.model.AwsJobExponentialRolloutRate.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AwsJobExecutionsRolloutConfig
  ): zio.aws.iot.model.AwsJobExecutionsRolloutConfig.ReadOnly = new Wrapper(
    impl
  )
}
