package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.ExpiresInSeconds
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AwsJobPresignedUrlConfig(
    expiresInSec: Option[ExpiresInSeconds] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AwsJobPresignedUrlConfig = {
    import AwsJobPresignedUrlConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AwsJobPresignedUrlConfig
      .builder()
      .optionallyWith(
        expiresInSec.map(value =>
          ExpiresInSeconds.unwrap(value): java.lang.Long
        )
      )(_.expiresInSec)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AwsJobPresignedUrlConfig.ReadOnly =
    zio.aws.iot.model.AwsJobPresignedUrlConfig.wrap(buildAwsValue())
}
object AwsJobPresignedUrlConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AwsJobPresignedUrlConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AwsJobPresignedUrlConfig =
      zio.aws.iot.model
        .AwsJobPresignedUrlConfig(expiresInSec.map(value => value))
    def expiresInSec: Option[ExpiresInSeconds]
    def getExpiresInSec: ZIO[Any, AwsError, ExpiresInSeconds] =
      AwsError.unwrapOptionField("expiresInSec", expiresInSec)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AwsJobPresignedUrlConfig
  ) extends zio.aws.iot.model.AwsJobPresignedUrlConfig.ReadOnly {
    override val expiresInSec: Option[ExpiresInSeconds] = scala
      .Option(impl.expiresInSec())
      .map(value => zio.aws.iot.model.primitives.ExpiresInSeconds(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AwsJobPresignedUrlConfig
  ): zio.aws.iot.model.AwsJobPresignedUrlConfig.ReadOnly = new Wrapper(impl)
}
