package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.AwsJobRateIncreaseCriteriaNumberOfThings
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AwsJobRateIncreaseCriteria(
    numberOfNotifiedThings: Option[AwsJobRateIncreaseCriteriaNumberOfThings] =
      None,
    numberOfSucceededThings: Option[AwsJobRateIncreaseCriteriaNumberOfThings] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AwsJobRateIncreaseCriteria = {
    import AwsJobRateIncreaseCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AwsJobRateIncreaseCriteria
      .builder()
      .optionallyWith(
        numberOfNotifiedThings.map(value =>
          AwsJobRateIncreaseCriteriaNumberOfThings.unwrap(value): Integer
        )
      )(_.numberOfNotifiedThings)
      .optionallyWith(
        numberOfSucceededThings.map(value =>
          AwsJobRateIncreaseCriteriaNumberOfThings.unwrap(value): Integer
        )
      )(_.numberOfSucceededThings)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AwsJobRateIncreaseCriteria.ReadOnly =
    zio.aws.iot.model.AwsJobRateIncreaseCriteria.wrap(buildAwsValue())
}
object AwsJobRateIncreaseCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AwsJobRateIncreaseCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AwsJobRateIncreaseCriteria =
      zio.aws.iot.model.AwsJobRateIncreaseCriteria(
        numberOfNotifiedThings.map(value => value),
        numberOfSucceededThings.map(value => value)
      )
    def numberOfNotifiedThings: Option[AwsJobRateIncreaseCriteriaNumberOfThings]
    def numberOfSucceededThings
        : Option[AwsJobRateIncreaseCriteriaNumberOfThings]
    def getNumberOfNotifiedThings
        : ZIO[Any, AwsError, AwsJobRateIncreaseCriteriaNumberOfThings] =
      AwsError.unwrapOptionField(
        "numberOfNotifiedThings",
        numberOfNotifiedThings
      )
    def getNumberOfSucceededThings
        : ZIO[Any, AwsError, AwsJobRateIncreaseCriteriaNumberOfThings] =
      AwsError.unwrapOptionField(
        "numberOfSucceededThings",
        numberOfSucceededThings
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AwsJobRateIncreaseCriteria
  ) extends zio.aws.iot.model.AwsJobRateIncreaseCriteria.ReadOnly {
    override val numberOfNotifiedThings
        : Option[AwsJobRateIncreaseCriteriaNumberOfThings] = scala
      .Option(impl.numberOfNotifiedThings())
      .map(value =>
        zio.aws.iot.model.primitives
          .AwsJobRateIncreaseCriteriaNumberOfThings(value)
      )
    override val numberOfSucceededThings
        : Option[AwsJobRateIncreaseCriteriaNumberOfThings] = scala
      .Option(impl.numberOfSucceededThings())
      .map(value =>
        zio.aws.iot.model.primitives
          .AwsJobRateIncreaseCriteriaNumberOfThings(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AwsJobRateIncreaseCriteria
  ): zio.aws.iot.model.AwsJobRateIncreaseCriteria.ReadOnly = new Wrapper(impl)
}
