package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{DateType, CertificateId, CertificateArn}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CACertificate(
    certificateArn: Option[CertificateArn] = None,
    certificateId: Option[CertificateId] = None,
    status: Option[zio.aws.iot.model.CACertificateStatus] = None,
    creationDate: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CACertificate = {
    import CACertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CACertificate
      .builder()
      .optionallyWith(
        certificateArn.map(value =>
          CertificateArn.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(
        certificateId.map(value =>
          CertificateId.unwrap(value): java.lang.String
        )
      )(_.certificateId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CACertificate.ReadOnly =
    zio.aws.iot.model.CACertificate.wrap(buildAwsValue())
}
object CACertificate {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.CACertificate] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CACertificate =
      zio.aws.iot.model.CACertificate(
        certificateArn.map(value => value),
        certificateId.map(value => value),
        status.map(value => value),
        creationDate.map(value => value)
      )
    def certificateArn: Option[CertificateArn]
    def certificateId: Option[CertificateId]
    def status: Option[zio.aws.iot.model.CACertificateStatus]
    def creationDate: Option[DateType]
    def getCertificateArn: ZIO[Any, AwsError, CertificateArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificateId: ZIO[Any, AwsError, CertificateId] =
      AwsError.unwrapOptionField("certificateId", certificateId)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.CACertificateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CACertificate
  ) extends zio.aws.iot.model.CACertificate.ReadOnly {
    override val certificateArn: Option[CertificateArn] = scala
      .Option(impl.certificateArn())
      .map(value => zio.aws.iot.model.primitives.CertificateArn(value))
    override val certificateId: Option[CertificateId] = scala
      .Option(impl.certificateId())
      .map(value => zio.aws.iot.model.primitives.CertificateId(value))
    override val status: Option[zio.aws.iot.model.CACertificateStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.iot.model.CACertificateStatus.wrap(value))
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CACertificate
  ): zio.aws.iot.model.CACertificate.ReadOnly = new Wrapper(impl)
}
