package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{ForceFlag, Comment, ReasonCode, JobId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CancelJobRequest(
    jobId: JobId,
    reasonCode: Option[ReasonCode] = None,
    comment: Option[Comment] = None,
    force: Option[ForceFlag] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CancelJobRequest = {
    import CancelJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CancelJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(
        reasonCode.map(value => ReasonCode.unwrap(value): java.lang.String)
      )(_.reasonCode)
      .optionallyWith(
        comment.map(value => Comment.unwrap(value): java.lang.String)
      )(_.comment)
      .optionallyWith(
        force.map(value => ForceFlag.unwrap(value): java.lang.Boolean)
      )(_.force)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CancelJobRequest.ReadOnly =
    zio.aws.iot.model.CancelJobRequest.wrap(buildAwsValue())
}
object CancelJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CancelJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CancelJobRequest =
      zio.aws.iot.model.CancelJobRequest(
        jobId,
        reasonCode.map(value => value),
        comment.map(value => value),
        force.map(value => value)
      )
    def jobId: JobId
    def reasonCode: Option[ReasonCode]
    def comment: Option[Comment]
    def force: Option[ForceFlag]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getReasonCode: ZIO[Any, AwsError, ReasonCode] =
      AwsError.unwrapOptionField("reasonCode", reasonCode)
    def getComment: ZIO[Any, AwsError, Comment] =
      AwsError.unwrapOptionField("comment", comment)
    def getForce: ZIO[Any, AwsError, ForceFlag] =
      AwsError.unwrapOptionField("force", force)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CancelJobRequest
  ) extends zio.aws.iot.model.CancelJobRequest.ReadOnly {
    override val jobId: JobId = zio.aws.iot.model.primitives.JobId(impl.jobId())
    override val reasonCode: Option[ReasonCode] = scala
      .Option(impl.reasonCode())
      .map(value => zio.aws.iot.model.primitives.ReasonCode(value))
    override val comment: Option[Comment] = scala
      .Option(impl.comment())
      .map(value => zio.aws.iot.model.primitives.Comment(value))
    override val force: Option[ForceFlag] = scala
      .Option(impl.force())
      .map(value => zio.aws.iot.model.primitives.ForceFlag(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CancelJobRequest
  ): zio.aws.iot.model.CancelJobRequest.ReadOnly = new Wrapper(impl)
}
