package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{JobDescription, JobId, JobArn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CancelJobResponse(
    jobArn: Option[JobArn] = None,
    jobId: Option[JobId] = None,
    description: Option[JobDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CancelJobResponse = {
    import CancelJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CancelJobResponse
      .builder()
      .optionallyWith(
        jobArn.map(value => JobArn.unwrap(value): java.lang.String)
      )(_.jobArn)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        description.map(value => JobDescription.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CancelJobResponse.ReadOnly =
    zio.aws.iot.model.CancelJobResponse.wrap(buildAwsValue())
}
object CancelJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CancelJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CancelJobResponse =
      zio.aws.iot.model.CancelJobResponse(
        jobArn.map(value => value),
        jobId.map(value => value),
        description.map(value => value)
      )
    def jobArn: Option[JobArn]
    def jobId: Option[JobId]
    def description: Option[JobDescription]
    def getJobArn: ZIO[Any, AwsError, JobArn] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getDescription: ZIO[Any, AwsError, JobDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CancelJobResponse
  ) extends zio.aws.iot.model.CancelJobResponse.ReadOnly {
    override val jobArn: Option[JobArn] = scala
      .Option(impl.jobArn())
      .map(value => zio.aws.iot.model.primitives.JobArn(value))
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.iot.model.primitives.JobId(value))
    override val description: Option[JobDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.iot.model.primitives.JobDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CancelJobResponse
  ): zio.aws.iot.model.CancelJobResponse.ReadOnly = new Wrapper(impl)
}
