package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{DateType, CertificateId, CertificateArn}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Certificate(
    certificateArn: Option[CertificateArn] = None,
    certificateId: Option[CertificateId] = None,
    status: Option[zio.aws.iot.model.CertificateStatus] = None,
    certificateMode: Option[zio.aws.iot.model.CertificateMode] = None,
    creationDate: Option[DateType] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.Certificate = {
    import Certificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.Certificate
      .builder()
      .optionallyWith(
        certificateArn.map(value =>
          CertificateArn.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(
        certificateId.map(value =>
          CertificateId.unwrap(value): java.lang.String
        )
      )(_.certificateId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(certificateMode.map(value => value.unwrap))(
        _.certificateMode
      )
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.Certificate.ReadOnly =
    zio.aws.iot.model.Certificate.wrap(buildAwsValue())
}
object Certificate {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.Certificate] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.Certificate =
      zio.aws.iot.model.Certificate(
        certificateArn.map(value => value),
        certificateId.map(value => value),
        status.map(value => value),
        certificateMode.map(value => value),
        creationDate.map(value => value)
      )
    def certificateArn: Option[CertificateArn]
    def certificateId: Option[CertificateId]
    def status: Option[zio.aws.iot.model.CertificateStatus]
    def certificateMode: Option[zio.aws.iot.model.CertificateMode]
    def creationDate: Option[DateType]
    def getCertificateArn: ZIO[Any, AwsError, CertificateArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificateId: ZIO[Any, AwsError, CertificateId] =
      AwsError.unwrapOptionField("certificateId", certificateId)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.CertificateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCertificateMode
        : ZIO[Any, AwsError, zio.aws.iot.model.CertificateMode] =
      AwsError.unwrapOptionField("certificateMode", certificateMode)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.Certificate
  ) extends zio.aws.iot.model.Certificate.ReadOnly {
    override val certificateArn: Option[CertificateArn] = scala
      .Option(impl.certificateArn())
      .map(value => zio.aws.iot.model.primitives.CertificateArn(value))
    override val certificateId: Option[CertificateId] = scala
      .Option(impl.certificateId())
      .map(value => zio.aws.iot.model.primitives.CertificateId(value))
    override val status: Option[zio.aws.iot.model.CertificateStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.iot.model.CertificateStatus.wrap(value))
    override val certificateMode: Option[zio.aws.iot.model.CertificateMode] =
      scala
        .Option(impl.certificateMode())
        .map(value => zio.aws.iot.model.CertificateMode.wrap(value))
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.Certificate
  ): zio.aws.iot.model.Certificate.ReadOnly = new Wrapper(impl)
}
