package zio.aws.iot.model
import scala.jdk.CollectionConverters.*
sealed trait CertificateMode {
  def unwrap: software.amazon.awssdk.services.iot.model.CertificateMode
}
object CertificateMode {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.CertificateMode
  ): zio.aws.iot.model.CertificateMode = value match {
    case software.amazon.awssdk.services.iot.model.CertificateMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.CertificateMode.DEFAULT =>
      val r = DEFAULT
      r
    case software.amazon.awssdk.services.iot.model.CertificateMode.SNI_ONLY =>
      val r = SNI_ONLY
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.CertificateMode {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.CertificateMode =
      software.amazon.awssdk.services.iot.model.CertificateMode.UNKNOWN_TO_SDK_VERSION
  }
  case object DEFAULT extends zio.aws.iot.model.CertificateMode {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.CertificateMode =
      software.amazon.awssdk.services.iot.model.CertificateMode.DEFAULT
  }
  case object SNI_ONLY extends zio.aws.iot.model.CertificateMode {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.CertificateMode =
      software.amazon.awssdk.services.iot.model.CertificateMode.SNI_ONLY
  }
}
