package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.Enabled
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Configuration(enabled: Option[Enabled] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.Configuration = {
    import Configuration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.Configuration
      .builder()
      .optionallyWith(
        enabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.Configuration.ReadOnly =
    zio.aws.iot.model.Configuration.wrap(buildAwsValue())
}
object Configuration {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.Configuration] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.Configuration =
      zio.aws.iot.model.Configuration(enabled.map(value => value))
    def enabled: Option[Enabled]
    def getEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.Configuration
  ) extends zio.aws.iot.model.Configuration.ReadOnly {
    override val enabled: Option[Enabled] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.iot.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.Configuration
  ): zio.aws.iot.model.Configuration.ReadOnly = new Wrapper(impl)
}
