package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  KeyValue,
  BooleanKey,
  EnableCachingForHttp,
  KeyName,
  AuthorizerName,
  AuthorizerFunctionArn,
  TokenKeyName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateAuthorizerRequest(
    authorizerName: AuthorizerName,
    authorizerFunctionArn: AuthorizerFunctionArn,
    tokenKeyName: Option[TokenKeyName] = None,
    tokenSigningPublicKeys: Option[Map[KeyName, KeyValue]] = None,
    status: Option[zio.aws.iot.model.AuthorizerStatus] = None,
    tags: Option[Iterable[zio.aws.iot.model.Tag]] = None,
    signingDisabled: Option[BooleanKey] = None,
    enableCachingForHttp: Option[EnableCachingForHttp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateAuthorizerRequest = {
    import CreateAuthorizerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateAuthorizerRequest
      .builder()
      .authorizerName(AuthorizerName.unwrap(authorizerName): java.lang.String)
      .authorizerFunctionArn(
        AuthorizerFunctionArn.unwrap(authorizerFunctionArn): java.lang.String
      )
      .optionallyWith(
        tokenKeyName.map(value => TokenKeyName.unwrap(value): java.lang.String)
      )(_.tokenKeyName)
      .optionallyWith(
        tokenSigningPublicKeys.map(value =>
          value
            .map({ case (key, value) =>
              (KeyName.unwrap(key): java.lang.String) -> (KeyValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tokenSigningPublicKeys)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        signingDisabled.map(value =>
          BooleanKey.unwrap(value): java.lang.Boolean
        )
      )(_.signingDisabled)
      .optionallyWith(
        enableCachingForHttp.map(value =>
          EnableCachingForHttp.unwrap(value): java.lang.Boolean
        )
      )(_.enableCachingForHttp)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateAuthorizerRequest.ReadOnly =
    zio.aws.iot.model.CreateAuthorizerRequest.wrap(buildAwsValue())
}
object CreateAuthorizerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateAuthorizerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateAuthorizerRequest =
      zio.aws.iot.model.CreateAuthorizerRequest(
        authorizerName,
        authorizerFunctionArn,
        tokenKeyName.map(value => value),
        tokenSigningPublicKeys.map(value => value),
        status.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        signingDisabled.map(value => value),
        enableCachingForHttp.map(value => value)
      )
    def authorizerName: AuthorizerName
    def authorizerFunctionArn: AuthorizerFunctionArn
    def tokenKeyName: Option[TokenKeyName]
    def tokenSigningPublicKeys: Option[Map[KeyName, KeyValue]]
    def status: Option[zio.aws.iot.model.AuthorizerStatus]
    def tags: Option[List[zio.aws.iot.model.Tag.ReadOnly]]
    def signingDisabled: Option[BooleanKey]
    def enableCachingForHttp: Option[EnableCachingForHttp]
    def getAuthorizerName: ZIO[Any, Nothing, AuthorizerName] =
      ZIO.succeed(authorizerName)
    def getAuthorizerFunctionArn: ZIO[Any, Nothing, AuthorizerFunctionArn] =
      ZIO.succeed(authorizerFunctionArn)
    def getTokenKeyName: ZIO[Any, AwsError, TokenKeyName] =
      AwsError.unwrapOptionField("tokenKeyName", tokenKeyName)
    def getTokenSigningPublicKeys: ZIO[Any, AwsError, Map[KeyName, KeyValue]] =
      AwsError.unwrapOptionField(
        "tokenSigningPublicKeys",
        tokenSigningPublicKeys
      )
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.AuthorizerStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSigningDisabled: ZIO[Any, AwsError, BooleanKey] =
      AwsError.unwrapOptionField("signingDisabled", signingDisabled)
    def getEnableCachingForHttp: ZIO[Any, AwsError, EnableCachingForHttp] =
      AwsError.unwrapOptionField("enableCachingForHttp", enableCachingForHttp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateAuthorizerRequest
  ) extends zio.aws.iot.model.CreateAuthorizerRequest.ReadOnly {
    override val authorizerName: AuthorizerName =
      zio.aws.iot.model.primitives.AuthorizerName(impl.authorizerName())
    override val authorizerFunctionArn: AuthorizerFunctionArn =
      zio.aws.iot.model.primitives
        .AuthorizerFunctionArn(impl.authorizerFunctionArn())
    override val tokenKeyName: Option[TokenKeyName] = scala
      .Option(impl.tokenKeyName())
      .map(value => zio.aws.iot.model.primitives.TokenKeyName(value))
    override val tokenSigningPublicKeys: Option[Map[KeyName, KeyValue]] = scala
      .Option(impl.tokenSigningPublicKeys())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.primitives
              .KeyName(key) -> zio.aws.iot.model.primitives.KeyValue(value)
          })
          .toMap
      )
    override val status: Option[zio.aws.iot.model.AuthorizerStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.iot.model.AuthorizerStatus.wrap(value))
    override val tags: Option[List[zio.aws.iot.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.Tag.wrap(item)
        }.toList
      )
    override val signingDisabled: Option[BooleanKey] = scala
      .Option(impl.signingDisabled())
      .map(value => zio.aws.iot.model.primitives.BooleanKey(value))
    override val enableCachingForHttp: Option[EnableCachingForHttp] = scala
      .Option(impl.enableCachingForHttp())
      .map(value => zio.aws.iot.model.primitives.EnableCachingForHttp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateAuthorizerRequest
  ): zio.aws.iot.model.CreateAuthorizerRequest.ReadOnly = new Wrapper(impl)
}
