package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{FleetMetricArn, FleetMetricName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateFleetMetricResponse(
    metricName: Option[FleetMetricName] = None,
    metricArn: Option[FleetMetricArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateFleetMetricResponse = {
    import CreateFleetMetricResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateFleetMetricResponse
      .builder()
      .optionallyWith(
        metricName.map(value => FleetMetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        metricArn.map(value => FleetMetricArn.unwrap(value): java.lang.String)
      )(_.metricArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateFleetMetricResponse.ReadOnly =
    zio.aws.iot.model.CreateFleetMetricResponse.wrap(buildAwsValue())
}
object CreateFleetMetricResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateFleetMetricResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateFleetMetricResponse =
      zio.aws.iot.model.CreateFleetMetricResponse(
        metricName.map(value => value),
        metricArn.map(value => value)
      )
    def metricName: Option[FleetMetricName]
    def metricArn: Option[FleetMetricArn]
    def getMetricName: ZIO[Any, AwsError, FleetMetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getMetricArn: ZIO[Any, AwsError, FleetMetricArn] =
      AwsError.unwrapOptionField("metricArn", metricArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateFleetMetricResponse
  ) extends zio.aws.iot.model.CreateFleetMetricResponse.ReadOnly {
    override val metricName: Option[FleetMetricName] = scala
      .Option(impl.metricName())
      .map(value => zio.aws.iot.model.primitives.FleetMetricName(value))
    override val metricArn: Option[FleetMetricArn] = scala
      .Option(impl.metricArn())
      .map(value => zio.aws.iot.model.primitives.FleetMetricArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateFleetMetricResponse
  ): zio.aws.iot.model.CreateFleetMetricResponse.ReadOnly = new Wrapper(impl)
}
