package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{DateType, CertificatePem, CertificateId}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CreateProvisioningClaimResponse(
    certificateId: Option[CertificateId] = None,
    certificatePem: Option[CertificatePem] = None,
    keyPair: Option[zio.aws.iot.model.KeyPair] = None,
    expiration: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateProvisioningClaimResponse = {
    import CreateProvisioningClaimResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateProvisioningClaimResponse
      .builder()
      .optionallyWith(
        certificateId.map(value =>
          CertificateId.unwrap(value): java.lang.String
        )
      )(_.certificateId)
      .optionallyWith(
        certificatePem.map(value =>
          CertificatePem.unwrap(value): java.lang.String
        )
      )(_.certificatePem)
      .optionallyWith(keyPair.map(value => value.buildAwsValue()))(_.keyPair)
      .optionallyWith(expiration.map(value => DateType.unwrap(value): Instant))(
        _.expiration
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateProvisioningClaimResponse.ReadOnly =
    zio.aws.iot.model.CreateProvisioningClaimResponse.wrap(buildAwsValue())
}
object CreateProvisioningClaimResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateProvisioningClaimResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateProvisioningClaimResponse =
      zio.aws.iot.model.CreateProvisioningClaimResponse(
        certificateId.map(value => value),
        certificatePem.map(value => value),
        keyPair.map(value => value.asEditable),
        expiration.map(value => value)
      )
    def certificateId: Option[CertificateId]
    def certificatePem: Option[CertificatePem]
    def keyPair: Option[zio.aws.iot.model.KeyPair.ReadOnly]
    def expiration: Option[DateType]
    def getCertificateId: ZIO[Any, AwsError, CertificateId] =
      AwsError.unwrapOptionField("certificateId", certificateId)
    def getCertificatePem: ZIO[Any, AwsError, CertificatePem] =
      AwsError.unwrapOptionField("certificatePem", certificatePem)
    def getKeyPair: ZIO[Any, AwsError, zio.aws.iot.model.KeyPair.ReadOnly] =
      AwsError.unwrapOptionField("keyPair", keyPair)
    def getExpiration: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("expiration", expiration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateProvisioningClaimResponse
  ) extends zio.aws.iot.model.CreateProvisioningClaimResponse.ReadOnly {
    override val certificateId: Option[CertificateId] = scala
      .Option(impl.certificateId())
      .map(value => zio.aws.iot.model.primitives.CertificateId(value))
    override val certificatePem: Option[CertificatePem] = scala
      .Option(impl.certificatePem())
      .map(value => zio.aws.iot.model.primitives.CertificatePem(value))
    override val keyPair: Option[zio.aws.iot.model.KeyPair.ReadOnly] = scala
      .Option(impl.keyPair())
      .map(value => zio.aws.iot.model.KeyPair.wrap(value))
    override val expiration: Option[DateType] = scala
      .Option(impl.expiration())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateProvisioningClaimResponse
  ): zio.aws.iot.model.CreateProvisioningClaimResponse.ReadOnly = new Wrapper(
    impl
  )
}
