package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  RoleArn,
  TemplateName,
  TemplateDescription,
  Enabled,
  TemplateBody
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateProvisioningTemplateRequest(
    templateName: TemplateName,
    description: Option[TemplateDescription] = None,
    templateBody: TemplateBody,
    enabled: Option[Enabled] = None,
    provisioningRoleArn: RoleArn,
    preProvisioningHook: Option[zio.aws.iot.model.ProvisioningHook] = None,
    tags: Option[Iterable[zio.aws.iot.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateRequest = {
    import CreateProvisioningTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateRequest
      .builder()
      .templateName(TemplateName.unwrap(templateName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          TemplateDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .templateBody(TemplateBody.unwrap(templateBody): java.lang.String)
      .optionallyWith(
        enabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .provisioningRoleArn(
        RoleArn.unwrap(provisioningRoleArn): java.lang.String
      )
      .optionallyWith(preProvisioningHook.map(value => value.buildAwsValue()))(
        _.preProvisioningHook
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateProvisioningTemplateRequest.ReadOnly =
    zio.aws.iot.model.CreateProvisioningTemplateRequest.wrap(buildAwsValue())
}
object CreateProvisioningTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateProvisioningTemplateRequest =
      zio.aws.iot.model.CreateProvisioningTemplateRequest(
        templateName,
        description.map(value => value),
        templateBody,
        enabled.map(value => value),
        provisioningRoleArn,
        preProvisioningHook.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def templateName: TemplateName
    def description: Option[TemplateDescription]
    def templateBody: TemplateBody
    def enabled: Option[Enabled]
    def provisioningRoleArn: RoleArn
    def preProvisioningHook: Option[zio.aws.iot.model.ProvisioningHook.ReadOnly]
    def tags: Option[List[zio.aws.iot.model.Tag.ReadOnly]]
    def getTemplateName: ZIO[Any, Nothing, TemplateName] =
      ZIO.succeed(templateName)
    def getDescription: ZIO[Any, AwsError, TemplateDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTemplateBody: ZIO[Any, Nothing, TemplateBody] =
      ZIO.succeed(templateBody)
    def getEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getProvisioningRoleArn: ZIO[Any, Nothing, RoleArn] =
      ZIO.succeed(provisioningRoleArn)
    def getPreProvisioningHook
        : ZIO[Any, AwsError, zio.aws.iot.model.ProvisioningHook.ReadOnly] =
      AwsError.unwrapOptionField("preProvisioningHook", preProvisioningHook)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateRequest
  ) extends zio.aws.iot.model.CreateProvisioningTemplateRequest.ReadOnly {
    override val templateName: TemplateName =
      zio.aws.iot.model.primitives.TemplateName(impl.templateName())
    override val description: Option[TemplateDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.iot.model.primitives.TemplateDescription(value))
    override val templateBody: TemplateBody =
      zio.aws.iot.model.primitives.TemplateBody(impl.templateBody())
    override val enabled: Option[Enabled] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.iot.model.primitives.Enabled(value))
    override val provisioningRoleArn: RoleArn =
      zio.aws.iot.model.primitives.RoleArn(impl.provisioningRoleArn())
    override val preProvisioningHook
        : Option[zio.aws.iot.model.ProvisioningHook.ReadOnly] = scala
      .Option(impl.preProvisioningHook())
      .map(value => zio.aws.iot.model.ProvisioningHook.wrap(value))
    override val tags: Option[List[zio.aws.iot.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateRequest
  ): zio.aws.iot.model.CreateProvisioningTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
