package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{RoleAliasArn, RoleAlias}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateRoleAliasResponse(
    roleAlias: Option[RoleAlias] = None,
    roleAliasArn: Option[RoleAliasArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateRoleAliasResponse = {
    import CreateRoleAliasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateRoleAliasResponse
      .builder()
      .optionallyWith(
        roleAlias.map(value => RoleAlias.unwrap(value): java.lang.String)
      )(_.roleAlias)
      .optionallyWith(
        roleAliasArn.map(value => RoleAliasArn.unwrap(value): java.lang.String)
      )(_.roleAliasArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateRoleAliasResponse.ReadOnly =
    zio.aws.iot.model.CreateRoleAliasResponse.wrap(buildAwsValue())
}
object CreateRoleAliasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateRoleAliasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateRoleAliasResponse =
      zio.aws.iot.model.CreateRoleAliasResponse(
        roleAlias.map(value => value),
        roleAliasArn.map(value => value)
      )
    def roleAlias: Option[RoleAlias]
    def roleAliasArn: Option[RoleAliasArn]
    def getRoleAlias: ZIO[Any, AwsError, RoleAlias] =
      AwsError.unwrapOptionField("roleAlias", roleAlias)
    def getRoleAliasArn: ZIO[Any, AwsError, RoleAliasArn] =
      AwsError.unwrapOptionField("roleAliasArn", roleAliasArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateRoleAliasResponse
  ) extends zio.aws.iot.model.CreateRoleAliasResponse.ReadOnly {
    override val roleAlias: Option[RoleAlias] = scala
      .Option(impl.roleAlias())
      .map(value => zio.aws.iot.model.primitives.RoleAlias(value))
    override val roleAliasArn: Option[RoleAliasArn] = scala
      .Option(impl.roleAliasArn())
      .map(value => zio.aws.iot.model.primitives.RoleAliasArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateRoleAliasResponse
  ): zio.aws.iot.model.CreateRoleAliasResponse.ReadOnly = new Wrapper(impl)
}
