package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{SecurityProfileArn, SecurityProfileName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateSecurityProfileResponse(
    securityProfileName: Option[SecurityProfileName] = None,
    securityProfileArn: Option[SecurityProfileArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateSecurityProfileResponse = {
    import CreateSecurityProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateSecurityProfileResponse
      .builder()
      .optionallyWith(
        securityProfileName.map(value =>
          SecurityProfileName.unwrap(value): java.lang.String
        )
      )(_.securityProfileName)
      .optionallyWith(
        securityProfileArn.map(value =>
          SecurityProfileArn.unwrap(value): java.lang.String
        )
      )(_.securityProfileArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateSecurityProfileResponse.ReadOnly =
    zio.aws.iot.model.CreateSecurityProfileResponse.wrap(buildAwsValue())
}
object CreateSecurityProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateSecurityProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateSecurityProfileResponse =
      zio.aws.iot.model.CreateSecurityProfileResponse(
        securityProfileName.map(value => value),
        securityProfileArn.map(value => value)
      )
    def securityProfileName: Option[SecurityProfileName]
    def securityProfileArn: Option[SecurityProfileArn]
    def getSecurityProfileName: ZIO[Any, AwsError, SecurityProfileName] =
      AwsError.unwrapOptionField("securityProfileName", securityProfileName)
    def getSecurityProfileArn: ZIO[Any, AwsError, SecurityProfileArn] =
      AwsError.unwrapOptionField("securityProfileArn", securityProfileArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateSecurityProfileResponse
  ) extends zio.aws.iot.model.CreateSecurityProfileResponse.ReadOnly {
    override val securityProfileName: Option[SecurityProfileName] = scala
      .Option(impl.securityProfileName())
      .map(value => zio.aws.iot.model.primitives.SecurityProfileName(value))
    override val securityProfileArn: Option[SecurityProfileArn] = scala
      .Option(impl.securityProfileArn())
      .map(value => zio.aws.iot.model.primitives.SecurityProfileArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateSecurityProfileResponse
  ): zio.aws.iot.model.CreateSecurityProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
