package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{ThingTypeId, ThingTypeArn, ThingTypeName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateThingTypeResponse(
    thingTypeName: Option[ThingTypeName] = None,
    thingTypeArn: Option[ThingTypeArn] = None,
    thingTypeId: Option[ThingTypeId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateThingTypeResponse = {
    import CreateThingTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateThingTypeResponse
      .builder()
      .optionallyWith(
        thingTypeName.map(value =>
          ThingTypeName.unwrap(value): java.lang.String
        )
      )(_.thingTypeName)
      .optionallyWith(
        thingTypeArn.map(value => ThingTypeArn.unwrap(value): java.lang.String)
      )(_.thingTypeArn)
      .optionallyWith(
        thingTypeId.map(value => ThingTypeId.unwrap(value): java.lang.String)
      )(_.thingTypeId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateThingTypeResponse.ReadOnly =
    zio.aws.iot.model.CreateThingTypeResponse.wrap(buildAwsValue())
}
object CreateThingTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateThingTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateThingTypeResponse =
      zio.aws.iot.model.CreateThingTypeResponse(
        thingTypeName.map(value => value),
        thingTypeArn.map(value => value),
        thingTypeId.map(value => value)
      )
    def thingTypeName: Option[ThingTypeName]
    def thingTypeArn: Option[ThingTypeArn]
    def thingTypeId: Option[ThingTypeId]
    def getThingTypeName: ZIO[Any, AwsError, ThingTypeName] =
      AwsError.unwrapOptionField("thingTypeName", thingTypeName)
    def getThingTypeArn: ZIO[Any, AwsError, ThingTypeArn] =
      AwsError.unwrapOptionField("thingTypeArn", thingTypeArn)
    def getThingTypeId: ZIO[Any, AwsError, ThingTypeId] =
      AwsError.unwrapOptionField("thingTypeId", thingTypeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateThingTypeResponse
  ) extends zio.aws.iot.model.CreateThingTypeResponse.ReadOnly {
    override val thingTypeName: Option[ThingTypeName] = scala
      .Option(impl.thingTypeName())
      .map(value => zio.aws.iot.model.primitives.ThingTypeName(value))
    override val thingTypeArn: Option[ThingTypeArn] = scala
      .Option(impl.thingTypeArn())
      .map(value => zio.aws.iot.model.primitives.ThingTypeArn(value))
    override val thingTypeId: Option[ThingTypeId] = scala
      .Option(impl.thingTypeId())
      .map(value => zio.aws.iot.model.primitives.ThingTypeId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateThingTypeResponse
  ): zio.aws.iot.model.CreateThingTypeResponse.ReadOnly = new Wrapper(impl)
}
