package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{SignatureAlgorithm, HashAlgorithm}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CustomCodeSigning(
    signature: Option[zio.aws.iot.model.CodeSigningSignature] = None,
    certificateChain: Option[zio.aws.iot.model.CodeSigningCertificateChain] =
      None,
    hashAlgorithm: Option[HashAlgorithm] = None,
    signatureAlgorithm: Option[SignatureAlgorithm] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CustomCodeSigning = {
    import CustomCodeSigning.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CustomCodeSigning
      .builder()
      .optionallyWith(signature.map(value => value.buildAwsValue()))(
        _.signature
      )
      .optionallyWith(certificateChain.map(value => value.buildAwsValue()))(
        _.certificateChain
      )
      .optionallyWith(
        hashAlgorithm.map(value =>
          HashAlgorithm.unwrap(value): java.lang.String
        )
      )(_.hashAlgorithm)
      .optionallyWith(
        signatureAlgorithm.map(value =>
          SignatureAlgorithm.unwrap(value): java.lang.String
        )
      )(_.signatureAlgorithm)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CustomCodeSigning.ReadOnly =
    zio.aws.iot.model.CustomCodeSigning.wrap(buildAwsValue())
}
object CustomCodeSigning {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CustomCodeSigning
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CustomCodeSigning =
      zio.aws.iot.model.CustomCodeSigning(
        signature.map(value => value.asEditable),
        certificateChain.map(value => value.asEditable),
        hashAlgorithm.map(value => value),
        signatureAlgorithm.map(value => value)
      )
    def signature: Option[zio.aws.iot.model.CodeSigningSignature.ReadOnly]
    def certificateChain
        : Option[zio.aws.iot.model.CodeSigningCertificateChain.ReadOnly]
    def hashAlgorithm: Option[HashAlgorithm]
    def signatureAlgorithm: Option[SignatureAlgorithm]
    def getSignature
        : ZIO[Any, AwsError, zio.aws.iot.model.CodeSigningSignature.ReadOnly] =
      AwsError.unwrapOptionField("signature", signature)
    def getCertificateChain: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.CodeSigningCertificateChain.ReadOnly
    ] = AwsError.unwrapOptionField("certificateChain", certificateChain)
    def getHashAlgorithm: ZIO[Any, AwsError, HashAlgorithm] =
      AwsError.unwrapOptionField("hashAlgorithm", hashAlgorithm)
    def getSignatureAlgorithm: ZIO[Any, AwsError, SignatureAlgorithm] =
      AwsError.unwrapOptionField("signatureAlgorithm", signatureAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CustomCodeSigning
  ) extends zio.aws.iot.model.CustomCodeSigning.ReadOnly {
    override val signature
        : Option[zio.aws.iot.model.CodeSigningSignature.ReadOnly] = scala
      .Option(impl.signature())
      .map(value => zio.aws.iot.model.CodeSigningSignature.wrap(value))
    override val certificateChain
        : Option[zio.aws.iot.model.CodeSigningCertificateChain.ReadOnly] = scala
      .Option(impl.certificateChain())
      .map(value => zio.aws.iot.model.CodeSigningCertificateChain.wrap(value))
    override val hashAlgorithm: Option[HashAlgorithm] = scala
      .Option(impl.hashAlgorithm())
      .map(value => zio.aws.iot.model.primitives.HashAlgorithm(value))
    override val signatureAlgorithm: Option[SignatureAlgorithm] = scala
      .Option(impl.signatureAlgorithm())
      .map(value => zio.aws.iot.model.primitives.SignatureAlgorithm(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CustomCodeSigning
  ): zio.aws.iot.model.CustomCodeSigning.ReadOnly = new Wrapper(impl)
}
