package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{OptionalVersion, FleetMetricName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteFleetMetricRequest(
    metricName: FleetMetricName,
    expectedVersion: Option[OptionalVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteFleetMetricRequest = {
    import DeleteFleetMetricRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteFleetMetricRequest
      .builder()
      .metricName(FleetMetricName.unwrap(metricName): java.lang.String)
      .optionallyWith(
        expectedVersion.map(value =>
          OptionalVersion.unwrap(value): java.lang.Long
        )
      )(_.expectedVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteFleetMetricRequest.ReadOnly =
    zio.aws.iot.model.DeleteFleetMetricRequest.wrap(buildAwsValue())
}
object DeleteFleetMetricRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteFleetMetricRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteFleetMetricRequest =
      zio.aws.iot.model.DeleteFleetMetricRequest(
        metricName,
        expectedVersion.map(value => value)
      )
    def metricName: FleetMetricName
    def expectedVersion: Option[OptionalVersion]
    def getMetricName: ZIO[Any, Nothing, FleetMetricName] =
      ZIO.succeed(metricName)
    def getExpectedVersion: ZIO[Any, AwsError, OptionalVersion] =
      AwsError.unwrapOptionField("expectedVersion", expectedVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteFleetMetricRequest
  ) extends zio.aws.iot.model.DeleteFleetMetricRequest.ReadOnly {
    override val metricName: FleetMetricName =
      zio.aws.iot.model.primitives.FleetMetricName(impl.metricName())
    override val expectedVersion: Option[OptionalVersion] = scala
      .Option(impl.expectedVersion())
      .map(value => zio.aws.iot.model.primitives.OptionalVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteFleetMetricRequest
  ): zio.aws.iot.model.DeleteFleetMetricRequest.ReadOnly = new Wrapper(impl)
}
