package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{OptionalVersion, SecurityProfileName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteSecurityProfileRequest(
    securityProfileName: SecurityProfileName,
    expectedVersion: Option[OptionalVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteSecurityProfileRequest = {
    import DeleteSecurityProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteSecurityProfileRequest
      .builder()
      .securityProfileName(
        SecurityProfileName.unwrap(securityProfileName): java.lang.String
      )
      .optionallyWith(
        expectedVersion.map(value =>
          OptionalVersion.unwrap(value): java.lang.Long
        )
      )(_.expectedVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteSecurityProfileRequest.ReadOnly =
    zio.aws.iot.model.DeleteSecurityProfileRequest.wrap(buildAwsValue())
}
object DeleteSecurityProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteSecurityProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteSecurityProfileRequest =
      zio.aws.iot.model.DeleteSecurityProfileRequest(
        securityProfileName,
        expectedVersion.map(value => value)
      )
    def securityProfileName: SecurityProfileName
    def expectedVersion: Option[OptionalVersion]
    def getSecurityProfileName: ZIO[Any, Nothing, SecurityProfileName] =
      ZIO.succeed(securityProfileName)
    def getExpectedVersion: ZIO[Any, AwsError, OptionalVersion] =
      AwsError.unwrapOptionField("expectedVersion", expectedVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteSecurityProfileRequest
  ) extends zio.aws.iot.model.DeleteSecurityProfileRequest.ReadOnly {
    override val securityProfileName: SecurityProfileName =
      zio.aws.iot.model.primitives
        .SecurityProfileName(impl.securityProfileName())
    override val expectedVersion: Option[OptionalVersion] = scala
      .Option(impl.expectedVersion())
      .map(value => zio.aws.iot.model.primitives.OptionalVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteSecurityProfileRequest
  ): zio.aws.iot.model.DeleteSecurityProfileRequest.ReadOnly = new Wrapper(impl)
}
