package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{OptionalVersion, ThingName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteThingRequest(
    thingName: ThingName,
    expectedVersion: Option[OptionalVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteThingRequest = {
    import DeleteThingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteThingRequest
      .builder()
      .thingName(ThingName.unwrap(thingName): java.lang.String)
      .optionallyWith(
        expectedVersion.map(value =>
          OptionalVersion.unwrap(value): java.lang.Long
        )
      )(_.expectedVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteThingRequest.ReadOnly =
    zio.aws.iot.model.DeleteThingRequest.wrap(buildAwsValue())
}
object DeleteThingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteThingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteThingRequest = zio.aws.iot.model
      .DeleteThingRequest(thingName, expectedVersion.map(value => value))
    def thingName: ThingName
    def expectedVersion: Option[OptionalVersion]
    def getThingName: ZIO[Any, Nothing, ThingName] = ZIO.succeed(thingName)
    def getExpectedVersion: ZIO[Any, AwsError, OptionalVersion] =
      AwsError.unwrapOptionField("expectedVersion", expectedVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteThingRequest
  ) extends zio.aws.iot.model.DeleteThingRequest.ReadOnly {
    override val thingName: ThingName =
      zio.aws.iot.model.primitives.ThingName(impl.thingName())
    override val expectedVersion: Option[OptionalVersion] = scala
      .Option(impl.expectedVersion())
      .map(value => zio.aws.iot.model.primitives.OptionalVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteThingRequest
  ): zio.aws.iot.model.DeleteThingRequest.ReadOnly = new Wrapper(impl)
}
