package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{AuditCheckName, RoleArn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeAccountAuditConfigurationResponse(
    roleArn: Option[RoleArn] = None,
    auditNotificationTargetConfigurations: Option[Map[
      zio.aws.iot.model.AuditNotificationType,
      zio.aws.iot.model.AuditNotificationTarget
    ]] = None,
    auditCheckConfigurations: Option[
      Map[AuditCheckName, zio.aws.iot.model.AuditCheckConfiguration]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeAccountAuditConfigurationResponse = {
    import DescribeAccountAuditConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeAccountAuditConfigurationResponse
      .builder()
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        auditNotificationTargetConfigurations.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.auditNotificationTargetConfigurationsWithStrings)
      .optionallyWith(
        auditCheckConfigurations.map(value =>
          value
            .map({ case (key, value) =>
              (AuditCheckName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.auditCheckConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DescribeAccountAuditConfigurationResponse.ReadOnly =
    zio.aws.iot.model.DescribeAccountAuditConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeAccountAuditConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeAccountAuditConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot.model.DescribeAccountAuditConfigurationResponse =
      zio.aws.iot.model.DescribeAccountAuditConfigurationResponse(
        roleArn.map(value => value),
        auditNotificationTargetConfigurations.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        auditCheckConfigurations.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def roleArn: Option[RoleArn]
    def auditNotificationTargetConfigurations: Option[Map[
      zio.aws.iot.model.AuditNotificationType,
      zio.aws.iot.model.AuditNotificationTarget.ReadOnly
    ]]
    def auditCheckConfigurations: Option[
      Map[AuditCheckName, zio.aws.iot.model.AuditCheckConfiguration.ReadOnly]
    ]
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getAuditNotificationTargetConfigurations: ZIO[Any, AwsError, Map[
      zio.aws.iot.model.AuditNotificationType,
      zio.aws.iot.model.AuditNotificationTarget.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "auditNotificationTargetConfigurations",
      auditNotificationTargetConfigurations
    )
    def getAuditCheckConfigurations: ZIO[Any, AwsError, Map[
      AuditCheckName,
      zio.aws.iot.model.AuditCheckConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "auditCheckConfigurations",
      auditCheckConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeAccountAuditConfigurationResponse
  ) extends zio.aws.iot.model.DescribeAccountAuditConfigurationResponse.ReadOnly {
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.RoleArn(value))
    override val auditNotificationTargetConfigurations: Option[Map[
      zio.aws.iot.model.AuditNotificationType,
      zio.aws.iot.model.AuditNotificationTarget.ReadOnly
    ]] = scala
      .Option(impl.auditNotificationTargetConfigurations())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.AuditNotificationType.wrap(
              key
            ) -> zio.aws.iot.model.AuditNotificationTarget.wrap(value)
          })
          .toMap
      )
    override val auditCheckConfigurations: Option[
      Map[AuditCheckName, zio.aws.iot.model.AuditCheckConfiguration.ReadOnly]
    ] = scala
      .Option(impl.auditCheckConfigurations())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.primitives.AuditCheckName(
              key
            ) -> zio.aws.iot.model.AuditCheckConfiguration.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeAccountAuditConfigurationResponse
  ): zio.aws.iot.model.DescribeAccountAuditConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
