package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeAuditFindingResponse(
    finding: Option[zio.aws.iot.model.AuditFinding] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeAuditFindingResponse = {
    import DescribeAuditFindingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeAuditFindingResponse
      .builder()
      .optionallyWith(finding.map(value => value.buildAwsValue()))(_.finding)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeAuditFindingResponse.ReadOnly =
    zio.aws.iot.model.DescribeAuditFindingResponse.wrap(buildAwsValue())
}
object DescribeAuditFindingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeAuditFindingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeAuditFindingResponse =
      zio.aws.iot.model
        .DescribeAuditFindingResponse(finding.map(value => value.asEditable))
    def finding: Option[zio.aws.iot.model.AuditFinding.ReadOnly]
    def getFinding
        : ZIO[Any, AwsError, zio.aws.iot.model.AuditFinding.ReadOnly] =
      AwsError.unwrapOptionField("finding", finding)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuditFindingResponse
  ) extends zio.aws.iot.model.DescribeAuditFindingResponse.ReadOnly {
    override val finding: Option[zio.aws.iot.model.AuditFinding.ReadOnly] =
      scala
        .Option(impl.finding())
        .map(value => zio.aws.iot.model.AuditFinding.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuditFindingResponse
  ): zio.aws.iot.model.DescribeAuditFindingResponse.ReadOnly = new Wrapper(impl)
}
