package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  MitigationActionName,
  AuditCheckName,
  Timestamp
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DescribeAuditMitigationActionsTaskResponse(
    taskStatus: Option[zio.aws.iot.model.AuditMitigationActionsTaskStatus] =
      None,
    startTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None,
    taskStatistics: Option[
      Map[AuditCheckName, zio.aws.iot.model.TaskStatisticsForAuditCheck]
    ] = None,
    target: Option[zio.aws.iot.model.AuditMitigationActionsTaskTarget] = None,
    auditCheckToActionsMapping: Option[
      Map[AuditCheckName, Iterable[MitigationActionName]]
    ] = None,
    actionsDefinition: Option[Iterable[zio.aws.iot.model.MitigationAction]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskResponse = {
    import DescribeAuditMitigationActionsTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskResponse
      .builder()
      .optionallyWith(taskStatus.map(value => value.unwrap))(_.taskStatus)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        taskStatistics.map(value =>
          value
            .map({ case (key, value) =>
              (AuditCheckName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.taskStatistics)
      .optionallyWith(target.map(value => value.buildAwsValue()))(_.target)
      .optionallyWith(
        auditCheckToActionsMapping.map(value =>
          value
            .map({ case (key, value) =>
              (AuditCheckName.unwrap(key): java.lang.String) -> value.map {
                item =>
                  MitigationActionName.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.auditCheckToActionsMapping)
      .optionallyWith(
        actionsDefinition.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actionsDefinition)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DescribeAuditMitigationActionsTaskResponse.ReadOnly =
    zio.aws.iot.model.DescribeAuditMitigationActionsTaskResponse
      .wrap(buildAwsValue())
}
object DescribeAuditMitigationActionsTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot.model.DescribeAuditMitigationActionsTaskResponse =
      zio.aws.iot.model.DescribeAuditMitigationActionsTaskResponse(
        taskStatus.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        taskStatistics.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        target.map(value => value.asEditable),
        auditCheckToActionsMapping.map(value => value),
        actionsDefinition.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def taskStatus: Option[zio.aws.iot.model.AuditMitigationActionsTaskStatus]
    def startTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def taskStatistics: Option[Map[
      AuditCheckName,
      zio.aws.iot.model.TaskStatisticsForAuditCheck.ReadOnly
    ]]
    def target
        : Option[zio.aws.iot.model.AuditMitigationActionsTaskTarget.ReadOnly]
    def auditCheckToActionsMapping
        : Option[Map[AuditCheckName, List[MitigationActionName]]]
    def actionsDefinition
        : Option[List[zio.aws.iot.model.MitigationAction.ReadOnly]]
    def getTaskStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.AuditMitigationActionsTaskStatus
    ] = AwsError.unwrapOptionField("taskStatus", taskStatus)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getTaskStatistics: ZIO[Any, AwsError, Map[
      AuditCheckName,
      zio.aws.iot.model.TaskStatisticsForAuditCheck.ReadOnly
    ]] = AwsError.unwrapOptionField("taskStatistics", taskStatistics)
    def getTarget: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.AuditMitigationActionsTaskTarget.ReadOnly
    ] = AwsError.unwrapOptionField("target", target)
    def getAuditCheckToActionsMapping
        : ZIO[Any, AwsError, Map[AuditCheckName, List[MitigationActionName]]] =
      AwsError.unwrapOptionField(
        "auditCheckToActionsMapping",
        auditCheckToActionsMapping
      )
    def getActionsDefinition: ZIO[Any, AwsError, List[
      zio.aws.iot.model.MitigationAction.ReadOnly
    ]] = AwsError.unwrapOptionField("actionsDefinition", actionsDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskResponse
  ) extends zio.aws.iot.model.DescribeAuditMitigationActionsTaskResponse.ReadOnly {
    override val taskStatus
        : Option[zio.aws.iot.model.AuditMitigationActionsTaskStatus] = scala
      .Option(impl.taskStatus())
      .map(value =>
        zio.aws.iot.model.AuditMitigationActionsTaskStatus.wrap(value)
      )
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val taskStatistics: Option[Map[
      AuditCheckName,
      zio.aws.iot.model.TaskStatisticsForAuditCheck.ReadOnly
    ]] = scala
      .Option(impl.taskStatistics())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.primitives.AuditCheckName(
              key
            ) -> zio.aws.iot.model.TaskStatisticsForAuditCheck.wrap(value)
          })
          .toMap
      )
    override val target
        : Option[zio.aws.iot.model.AuditMitigationActionsTaskTarget.ReadOnly] =
      scala
        .Option(impl.target())
        .map(value =>
          zio.aws.iot.model.AuditMitigationActionsTaskTarget.wrap(value)
        )
    override val auditCheckToActionsMapping
        : Option[Map[AuditCheckName, List[MitigationActionName]]] = scala
      .Option(impl.auditCheckToActionsMapping())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.primitives
              .AuditCheckName(key) -> value.asScala.map { item =>
              zio.aws.iot.model.primitives.MitigationActionName(item)
            }.toList
          })
          .toMap
      )
    override val actionsDefinition
        : Option[List[zio.aws.iot.model.MitigationAction.ReadOnly]] = scala
      .Option(impl.actionsDefinition())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.MitigationAction.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskResponse
  ): zio.aws.iot.model.DescribeAuditMitigationActionsTaskResponse.ReadOnly =
    new Wrapper(impl)
}
