package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeCaCertificateResponse(
    certificateDescription: Option[zio.aws.iot.model.CACertificateDescription] =
      None,
    registrationConfig: Option[zio.aws.iot.model.RegistrationConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeCaCertificateResponse = {
    import DescribeCaCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeCaCertificateResponse
      .builder()
      .optionallyWith(
        certificateDescription.map(value => value.buildAwsValue())
      )(_.certificateDescription)
      .optionallyWith(registrationConfig.map(value => value.buildAwsValue()))(
        _.registrationConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeCaCertificateResponse.ReadOnly =
    zio.aws.iot.model.DescribeCaCertificateResponse.wrap(buildAwsValue())
}
object DescribeCaCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeCaCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeCaCertificateResponse =
      zio.aws.iot.model.DescribeCaCertificateResponse(
        certificateDescription.map(value => value.asEditable),
        registrationConfig.map(value => value.asEditable)
      )
    def certificateDescription
        : Option[zio.aws.iot.model.CACertificateDescription.ReadOnly]
    def registrationConfig
        : Option[zio.aws.iot.model.RegistrationConfig.ReadOnly]
    def getCertificateDescription: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.CACertificateDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "certificateDescription",
      certificateDescription
    )
    def getRegistrationConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.RegistrationConfig.ReadOnly] =
      AwsError.unwrapOptionField("registrationConfig", registrationConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeCaCertificateResponse
  ) extends zio.aws.iot.model.DescribeCaCertificateResponse.ReadOnly {
    override val certificateDescription
        : Option[zio.aws.iot.model.CACertificateDescription.ReadOnly] = scala
      .Option(impl.certificateDescription())
      .map(value => zio.aws.iot.model.CACertificateDescription.wrap(value))
    override val registrationConfig
        : Option[zio.aws.iot.model.RegistrationConfig.ReadOnly] = scala
      .Option(impl.registrationConfig())
      .map(value => zio.aws.iot.model.RegistrationConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeCaCertificateResponse
  ): zio.aws.iot.model.DescribeCaCertificateResponse.ReadOnly = new Wrapper(
    impl
  )
}
