package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeCertificateResponse(
    certificateDescription: Option[zio.aws.iot.model.CertificateDescription] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeCertificateResponse = {
    import DescribeCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeCertificateResponse
      .builder()
      .optionallyWith(
        certificateDescription.map(value => value.buildAwsValue())
      )(_.certificateDescription)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeCertificateResponse.ReadOnly =
    zio.aws.iot.model.DescribeCertificateResponse.wrap(buildAwsValue())
}
object DescribeCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeCertificateResponse =
      zio.aws.iot.model.DescribeCertificateResponse(
        certificateDescription.map(value => value.asEditable)
      )
    def certificateDescription
        : Option[zio.aws.iot.model.CertificateDescription.ReadOnly]
    def getCertificateDescription: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.CertificateDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "certificateDescription",
      certificateDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeCertificateResponse
  ) extends zio.aws.iot.model.DescribeCertificateResponse.ReadOnly {
    override val certificateDescription
        : Option[zio.aws.iot.model.CertificateDescription.ReadOnly] = scala
      .Option(impl.certificateDescription())
      .map(value => zio.aws.iot.model.CertificateDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeCertificateResponse
  ): zio.aws.iot.model.DescribeCertificateResponse.ReadOnly = new Wrapper(impl)
}
