package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDefaultAuthorizerResponse(
    authorizerDescription: Option[zio.aws.iot.model.AuthorizerDescription] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeDefaultAuthorizerResponse = {
    import DescribeDefaultAuthorizerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeDefaultAuthorizerResponse
      .builder()
      .optionallyWith(
        authorizerDescription.map(value => value.buildAwsValue())
      )(_.authorizerDescription)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeDefaultAuthorizerResponse.ReadOnly =
    zio.aws.iot.model.DescribeDefaultAuthorizerResponse.wrap(buildAwsValue())
}
object DescribeDefaultAuthorizerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeDefaultAuthorizerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeDefaultAuthorizerResponse =
      zio.aws.iot.model.DescribeDefaultAuthorizerResponse(
        authorizerDescription.map(value => value.asEditable)
      )
    def authorizerDescription
        : Option[zio.aws.iot.model.AuthorizerDescription.ReadOnly]
    def getAuthorizerDescription
        : ZIO[Any, AwsError, zio.aws.iot.model.AuthorizerDescription.ReadOnly] =
      AwsError.unwrapOptionField("authorizerDescription", authorizerDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeDefaultAuthorizerResponse
  ) extends zio.aws.iot.model.DescribeDefaultAuthorizerResponse.ReadOnly {
    override val authorizerDescription
        : Option[zio.aws.iot.model.AuthorizerDescription.ReadOnly] = scala
      .Option(impl.authorizerDescription())
      .map(value => zio.aws.iot.model.AuthorizerDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeDefaultAuthorizerResponse
  ): zio.aws.iot.model.DescribeDefaultAuthorizerResponse.ReadOnly = new Wrapper(
    impl
  )
}
