package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{IndexSchema, IndexName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeIndexResponse(
    indexName: Option[IndexName] = None,
    indexStatus: Option[zio.aws.iot.model.IndexStatus] = None,
    schema: Option[IndexSchema] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeIndexResponse = {
    import DescribeIndexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeIndexResponse
      .builder()
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(indexStatus.map(value => value.unwrap))(_.indexStatus)
      .optionallyWith(
        schema.map(value => IndexSchema.unwrap(value): java.lang.String)
      )(_.schema)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeIndexResponse.ReadOnly =
    zio.aws.iot.model.DescribeIndexResponse.wrap(buildAwsValue())
}
object DescribeIndexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeIndexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeIndexResponse =
      zio.aws.iot.model.DescribeIndexResponse(
        indexName.map(value => value),
        indexStatus.map(value => value),
        schema.map(value => value)
      )
    def indexName: Option[IndexName]
    def indexStatus: Option[zio.aws.iot.model.IndexStatus]
    def schema: Option[IndexSchema]
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getIndexStatus: ZIO[Any, AwsError, zio.aws.iot.model.IndexStatus] =
      AwsError.unwrapOptionField("indexStatus", indexStatus)
    def getSchema: ZIO[Any, AwsError, IndexSchema] =
      AwsError.unwrapOptionField("schema", schema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeIndexResponse
  ) extends zio.aws.iot.model.DescribeIndexResponse.ReadOnly {
    override val indexName: Option[IndexName] = scala
      .Option(impl.indexName())
      .map(value => zio.aws.iot.model.primitives.IndexName(value))
    override val indexStatus: Option[zio.aws.iot.model.IndexStatus] = scala
      .Option(impl.indexStatus())
      .map(value => zio.aws.iot.model.IndexStatus.wrap(value))
    override val schema: Option[IndexSchema] = scala
      .Option(impl.schema())
      .map(value => zio.aws.iot.model.primitives.IndexSchema(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeIndexResponse
  ): zio.aws.iot.model.DescribeIndexResponse.ReadOnly = new Wrapper(impl)
}
