package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.JobDocumentSource
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeJobResponse(
    documentSource: Option[JobDocumentSource] = None,
    job: Option[zio.aws.iot.model.Job] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeJobResponse = {
    import DescribeJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeJobResponse
      .builder()
      .optionallyWith(
        documentSource.map(value =>
          JobDocumentSource.unwrap(value): java.lang.String
        )
      )(_.documentSource)
      .optionallyWith(job.map(value => value.buildAwsValue()))(_.job)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeJobResponse.ReadOnly =
    zio.aws.iot.model.DescribeJobResponse.wrap(buildAwsValue())
}
object DescribeJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeJobResponse =
      zio.aws.iot.model.DescribeJobResponse(
        documentSource.map(value => value),
        job.map(value => value.asEditable)
      )
    def documentSource: Option[JobDocumentSource]
    def job: Option[zio.aws.iot.model.Job.ReadOnly]
    def getDocumentSource: ZIO[Any, AwsError, JobDocumentSource] =
      AwsError.unwrapOptionField("documentSource", documentSource)
    def getJob: ZIO[Any, AwsError, zio.aws.iot.model.Job.ReadOnly] =
      AwsError.unwrapOptionField("job", job)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeJobResponse
  ) extends zio.aws.iot.model.DescribeJobResponse.ReadOnly {
    override val documentSource: Option[JobDocumentSource] = scala
      .Option(impl.documentSource())
      .map(value => zio.aws.iot.model.primitives.JobDocumentSource(value))
    override val job: Option[zio.aws.iot.model.Job.ReadOnly] =
      scala.Option(impl.job()).map(value => zio.aws.iot.model.Job.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeJobResponse
  ): zio.aws.iot.model.DescribeJobResponse.ReadOnly = new Wrapper(impl)
}
