package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  JobTemplateArn,
  DateType,
  JobDocument,
  JobDocumentSource,
  JobDescription,
  JobTemplateId
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DescribeJobTemplateResponse(
    jobTemplateArn: Option[JobTemplateArn] = None,
    jobTemplateId: Option[JobTemplateId] = None,
    description: Option[JobDescription] = None,
    documentSource: Option[JobDocumentSource] = None,
    document: Option[JobDocument] = None,
    createdAt: Option[DateType] = None,
    presignedUrlConfig: Option[zio.aws.iot.model.PresignedUrlConfig] = None,
    jobExecutionsRolloutConfig: Option[
      zio.aws.iot.model.JobExecutionsRolloutConfig
    ] = None,
    abortConfig: Option[zio.aws.iot.model.AbortConfig] = None,
    timeoutConfig: Option[zio.aws.iot.model.TimeoutConfig] = None,
    jobExecutionsRetryConfig: Option[
      zio.aws.iot.model.JobExecutionsRetryConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeJobTemplateResponse = {
    import DescribeJobTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeJobTemplateResponse
      .builder()
      .optionallyWith(
        jobTemplateArn.map(value =>
          JobTemplateArn.unwrap(value): java.lang.String
        )
      )(_.jobTemplateArn)
      .optionallyWith(
        jobTemplateId.map(value =>
          JobTemplateId.unwrap(value): java.lang.String
        )
      )(_.jobTemplateId)
      .optionallyWith(
        description.map(value => JobDescription.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        documentSource.map(value =>
          JobDocumentSource.unwrap(value): java.lang.String
        )
      )(_.documentSource)
      .optionallyWith(
        document.map(value => JobDocument.unwrap(value): java.lang.String)
      )(_.document)
      .optionallyWith(createdAt.map(value => DateType.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(presignedUrlConfig.map(value => value.buildAwsValue()))(
        _.presignedUrlConfig
      )
      .optionallyWith(
        jobExecutionsRolloutConfig.map(value => value.buildAwsValue())
      )(_.jobExecutionsRolloutConfig)
      .optionallyWith(abortConfig.map(value => value.buildAwsValue()))(
        _.abortConfig
      )
      .optionallyWith(timeoutConfig.map(value => value.buildAwsValue()))(
        _.timeoutConfig
      )
      .optionallyWith(
        jobExecutionsRetryConfig.map(value => value.buildAwsValue())
      )(_.jobExecutionsRetryConfig)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeJobTemplateResponse.ReadOnly =
    zio.aws.iot.model.DescribeJobTemplateResponse.wrap(buildAwsValue())
}
object DescribeJobTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeJobTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeJobTemplateResponse =
      zio.aws.iot.model.DescribeJobTemplateResponse(
        jobTemplateArn.map(value => value),
        jobTemplateId.map(value => value),
        description.map(value => value),
        documentSource.map(value => value),
        document.map(value => value),
        createdAt.map(value => value),
        presignedUrlConfig.map(value => value.asEditable),
        jobExecutionsRolloutConfig.map(value => value.asEditable),
        abortConfig.map(value => value.asEditable),
        timeoutConfig.map(value => value.asEditable),
        jobExecutionsRetryConfig.map(value => value.asEditable)
      )
    def jobTemplateArn: Option[JobTemplateArn]
    def jobTemplateId: Option[JobTemplateId]
    def description: Option[JobDescription]
    def documentSource: Option[JobDocumentSource]
    def document: Option[JobDocument]
    def createdAt: Option[DateType]
    def presignedUrlConfig
        : Option[zio.aws.iot.model.PresignedUrlConfig.ReadOnly]
    def jobExecutionsRolloutConfig
        : Option[zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly]
    def abortConfig: Option[zio.aws.iot.model.AbortConfig.ReadOnly]
    def timeoutConfig: Option[zio.aws.iot.model.TimeoutConfig.ReadOnly]
    def jobExecutionsRetryConfig
        : Option[zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly]
    def getJobTemplateArn: ZIO[Any, AwsError, JobTemplateArn] =
      AwsError.unwrapOptionField("jobTemplateArn", jobTemplateArn)
    def getJobTemplateId: ZIO[Any, AwsError, JobTemplateId] =
      AwsError.unwrapOptionField("jobTemplateId", jobTemplateId)
    def getDescription: ZIO[Any, AwsError, JobDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDocumentSource: ZIO[Any, AwsError, JobDocumentSource] =
      AwsError.unwrapOptionField("documentSource", documentSource)
    def getDocument: ZIO[Any, AwsError, JobDocument] =
      AwsError.unwrapOptionField("document", document)
    def getCreatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getPresignedUrlConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.PresignedUrlConfig.ReadOnly] =
      AwsError.unwrapOptionField("presignedUrlConfig", presignedUrlConfig)
    def getJobExecutionsRolloutConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jobExecutionsRolloutConfig",
      jobExecutionsRolloutConfig
    )
    def getAbortConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.AbortConfig.ReadOnly] =
      AwsError.unwrapOptionField("abortConfig", abortConfig)
    def getTimeoutConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.TimeoutConfig.ReadOnly] =
      AwsError.unwrapOptionField("timeoutConfig", timeoutConfig)
    def getJobExecutionsRetryConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jobExecutionsRetryConfig",
      jobExecutionsRetryConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeJobTemplateResponse
  ) extends zio.aws.iot.model.DescribeJobTemplateResponse.ReadOnly {
    override val jobTemplateArn: Option[JobTemplateArn] = scala
      .Option(impl.jobTemplateArn())
      .map(value => zio.aws.iot.model.primitives.JobTemplateArn(value))
    override val jobTemplateId: Option[JobTemplateId] = scala
      .Option(impl.jobTemplateId())
      .map(value => zio.aws.iot.model.primitives.JobTemplateId(value))
    override val description: Option[JobDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.iot.model.primitives.JobDescription(value))
    override val documentSource: Option[JobDocumentSource] = scala
      .Option(impl.documentSource())
      .map(value => zio.aws.iot.model.primitives.JobDocumentSource(value))
    override val document: Option[JobDocument] = scala
      .Option(impl.document())
      .map(value => zio.aws.iot.model.primitives.JobDocument(value))
    override val createdAt: Option[DateType] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val presignedUrlConfig
        : Option[zio.aws.iot.model.PresignedUrlConfig.ReadOnly] = scala
      .Option(impl.presignedUrlConfig())
      .map(value => zio.aws.iot.model.PresignedUrlConfig.wrap(value))
    override val jobExecutionsRolloutConfig
        : Option[zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly] = scala
      .Option(impl.jobExecutionsRolloutConfig())
      .map(value => zio.aws.iot.model.JobExecutionsRolloutConfig.wrap(value))
    override val abortConfig: Option[zio.aws.iot.model.AbortConfig.ReadOnly] =
      scala
        .Option(impl.abortConfig())
        .map(value => zio.aws.iot.model.AbortConfig.wrap(value))
    override val timeoutConfig
        : Option[zio.aws.iot.model.TimeoutConfig.ReadOnly] = scala
      .Option(impl.timeoutConfig())
      .map(value => zio.aws.iot.model.TimeoutConfig.wrap(value))
    override val jobExecutionsRetryConfig
        : Option[zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly] = scala
      .Option(impl.jobExecutionsRetryConfig())
      .map(value => zio.aws.iot.model.JobExecutionsRetryConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeJobTemplateResponse
  ): zio.aws.iot.model.DescribeJobTemplateResponse.ReadOnly = new Wrapper(impl)
}
