package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  JobTemplateArn,
  JobDocument,
  ManagedJobTemplateName,
  Environment,
  JobDescription,
  ManagedTemplateVersion
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeManagedJobTemplateResponse(
    templateName: Option[ManagedJobTemplateName] = None,
    templateArn: Option[JobTemplateArn] = None,
    description: Option[JobDescription] = None,
    templateVersion: Option[ManagedTemplateVersion] = None,
    environments: Option[Iterable[Environment]] = None,
    documentParameters: Option[Iterable[zio.aws.iot.model.DocumentParameter]] =
      None,
    document: Option[JobDocument] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeManagedJobTemplateResponse = {
    import DescribeManagedJobTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeManagedJobTemplateResponse
      .builder()
      .optionallyWith(
        templateName.map(value =>
          ManagedJobTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        templateArn.map(value => JobTemplateArn.unwrap(value): java.lang.String)
      )(_.templateArn)
      .optionallyWith(
        description.map(value => JobDescription.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        templateVersion.map(value =>
          ManagedTemplateVersion.unwrap(value): java.lang.String
        )
      )(_.templateVersion)
      .optionallyWith(
        environments.map(value =>
          value.map { item =>
            Environment.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.environments)
      .optionallyWith(
        documentParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentParameters)
      .optionallyWith(
        document.map(value => JobDocument.unwrap(value): java.lang.String)
      )(_.document)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DescribeManagedJobTemplateResponse.ReadOnly =
    zio.aws.iot.model.DescribeManagedJobTemplateResponse.wrap(buildAwsValue())
}
object DescribeManagedJobTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeManagedJobTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeManagedJobTemplateResponse =
      zio.aws.iot.model.DescribeManagedJobTemplateResponse(
        templateName.map(value => value),
        templateArn.map(value => value),
        description.map(value => value),
        templateVersion.map(value => value),
        environments.map(value => value),
        documentParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        document.map(value => value)
      )
    def templateName: Option[ManagedJobTemplateName]
    def templateArn: Option[JobTemplateArn]
    def description: Option[JobDescription]
    def templateVersion: Option[ManagedTemplateVersion]
    def environments: Option[List[Environment]]
    def documentParameters
        : Option[List[zio.aws.iot.model.DocumentParameter.ReadOnly]]
    def document: Option[JobDocument]
    def getTemplateName: ZIO[Any, AwsError, ManagedJobTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getTemplateArn: ZIO[Any, AwsError, JobTemplateArn] =
      AwsError.unwrapOptionField("templateArn", templateArn)
    def getDescription: ZIO[Any, AwsError, JobDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTemplateVersion: ZIO[Any, AwsError, ManagedTemplateVersion] =
      AwsError.unwrapOptionField("templateVersion", templateVersion)
    def getEnvironments: ZIO[Any, AwsError, List[Environment]] =
      AwsError.unwrapOptionField("environments", environments)
    def getDocumentParameters: ZIO[Any, AwsError, List[
      zio.aws.iot.model.DocumentParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("documentParameters", documentParameters)
    def getDocument: ZIO[Any, AwsError, JobDocument] =
      AwsError.unwrapOptionField("document", document)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeManagedJobTemplateResponse
  ) extends zio.aws.iot.model.DescribeManagedJobTemplateResponse.ReadOnly {
    override val templateName: Option[ManagedJobTemplateName] = scala
      .Option(impl.templateName())
      .map(value => zio.aws.iot.model.primitives.ManagedJobTemplateName(value))
    override val templateArn: Option[JobTemplateArn] = scala
      .Option(impl.templateArn())
      .map(value => zio.aws.iot.model.primitives.JobTemplateArn(value))
    override val description: Option[JobDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.iot.model.primitives.JobDescription(value))
    override val templateVersion: Option[ManagedTemplateVersion] = scala
      .Option(impl.templateVersion())
      .map(value => zio.aws.iot.model.primitives.ManagedTemplateVersion(value))
    override val environments: Option[List[Environment]] = scala
      .Option(impl.environments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.Environment(item)
        }.toList
      )
    override val documentParameters
        : Option[List[zio.aws.iot.model.DocumentParameter.ReadOnly]] = scala
      .Option(impl.documentParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.DocumentParameter.wrap(item)
        }.toList
      )
    override val document: Option[JobDocument] = scala
      .Option(impl.document())
      .map(value => zio.aws.iot.model.primitives.JobDocument(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeManagedJobTemplateResponse
  ): zio.aws.iot.model.DescribeManagedJobTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
