package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  RoleArn,
  MitigationActionArn,
  MitigationActionId,
  Timestamp,
  MitigationActionName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DescribeMitigationActionResponse(
    actionName: Option[MitigationActionName] = None,
    actionType: Option[zio.aws.iot.model.MitigationActionType] = None,
    actionArn: Option[MitigationActionArn] = None,
    actionId: Option[MitigationActionId] = None,
    roleArn: Option[RoleArn] = None,
    actionParams: Option[zio.aws.iot.model.MitigationActionParams] = None,
    creationDate: Option[Timestamp] = None,
    lastModifiedDate: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeMitigationActionResponse = {
    import DescribeMitigationActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeMitigationActionResponse
      .builder()
      .optionallyWith(
        actionName.map(value =>
          MitigationActionName.unwrap(value): java.lang.String
        )
      )(_.actionName)
      .optionallyWith(actionType.map(value => value.unwrap))(_.actionType)
      .optionallyWith(
        actionArn.map(value =>
          MitigationActionArn.unwrap(value): java.lang.String
        )
      )(_.actionArn)
      .optionallyWith(
        actionId.map(value =>
          MitigationActionId.unwrap(value): java.lang.String
        )
      )(_.actionId)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(actionParams.map(value => value.buildAwsValue()))(
        _.actionParams
      )
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeMitigationActionResponse.ReadOnly =
    zio.aws.iot.model.DescribeMitigationActionResponse.wrap(buildAwsValue())
}
object DescribeMitigationActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeMitigationActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeMitigationActionResponse =
      zio.aws.iot.model.DescribeMitigationActionResponse(
        actionName.map(value => value),
        actionType.map(value => value),
        actionArn.map(value => value),
        actionId.map(value => value),
        roleArn.map(value => value),
        actionParams.map(value => value.asEditable),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value)
      )
    def actionName: Option[MitigationActionName]
    def actionType: Option[zio.aws.iot.model.MitigationActionType]
    def actionArn: Option[MitigationActionArn]
    def actionId: Option[MitigationActionId]
    def roleArn: Option[RoleArn]
    def actionParams: Option[zio.aws.iot.model.MitigationActionParams.ReadOnly]
    def creationDate: Option[Timestamp]
    def lastModifiedDate: Option[Timestamp]
    def getActionName: ZIO[Any, AwsError, MitigationActionName] =
      AwsError.unwrapOptionField("actionName", actionName)
    def getActionType
        : ZIO[Any, AwsError, zio.aws.iot.model.MitigationActionType] =
      AwsError.unwrapOptionField("actionType", actionType)
    def getActionArn: ZIO[Any, AwsError, MitigationActionArn] =
      AwsError.unwrapOptionField("actionArn", actionArn)
    def getActionId: ZIO[Any, AwsError, MitigationActionId] =
      AwsError.unwrapOptionField("actionId", actionId)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getActionParams: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.MitigationActionParams.ReadOnly
    ] = AwsError.unwrapOptionField("actionParams", actionParams)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeMitigationActionResponse
  ) extends zio.aws.iot.model.DescribeMitigationActionResponse.ReadOnly {
    override val actionName: Option[MitigationActionName] = scala
      .Option(impl.actionName())
      .map(value => zio.aws.iot.model.primitives.MitigationActionName(value))
    override val actionType: Option[zio.aws.iot.model.MitigationActionType] =
      scala
        .Option(impl.actionType())
        .map(value => zio.aws.iot.model.MitigationActionType.wrap(value))
    override val actionArn: Option[MitigationActionArn] = scala
      .Option(impl.actionArn())
      .map(value => zio.aws.iot.model.primitives.MitigationActionArn(value))
    override val actionId: Option[MitigationActionId] = scala
      .Option(impl.actionId())
      .map(value => zio.aws.iot.model.primitives.MitigationActionId(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.RoleArn(value))
    override val actionParams
        : Option[zio.aws.iot.model.MitigationActionParams.ReadOnly] = scala
      .Option(impl.actionParams())
      .map(value => zio.aws.iot.model.MitigationActionParams.wrap(value))
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val lastModifiedDate: Option[Timestamp] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeMitigationActionResponse
  ): zio.aws.iot.model.DescribeMitigationActionResponse.ReadOnly = new Wrapper(
    impl
  )
}
